/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.ruby.rubyproject.SourceRoots;
import org.netbeans.modules.ruby.rubyproject.classpath.BootClassPathImplementation;
import org.netbeans.modules.ruby.rubyproject.classpath.GroupClassPathImplementation;
import org.netbeans.modules.ruby.rubyproject.classpath.SourcePathImplementation;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectHelper;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

public final class ClassPathProviderImpl
implements ClassPathProvider,
PropertyChangeListener {
    private static final String BUILD_CLASSES_DIR = "build.classes.dir";
    private static final String DIST_JAR = "dist.jar";
    private static final String BUILD_TEST_CLASSES_DIR = "build.test.classes.dir";
    private static final String JAVAC_CLASSPATH = "javac.classpath";
    private static final String JAVAC_TEST_CLASSPATH = "javac.test.classpath";
    private static final String RUN_CLASSPATH = "run.classpath";
    private static final String RUN_TEST_CLASSPATH = "run.test.classpath";
    private final RakeProjectHelper helper;
    private final File projectDirectory;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testSourceRoots;
    private final ClassPath[] cache = new ClassPath[8];
    private final Map<String, FileObject> dirCache = new HashMap<String, FileObject>();

    public ClassPathProviderImpl(RakeProjectHelper helper, PropertyEvaluator evaluator, SourceRoots sourceRoots, SourceRoots testSourceRoots) {
        this.helper = helper;
        this.projectDirectory = FileUtil.toFile((FileObject)helper.getProjectDirectory());
        assert (this.projectDirectory != null);
        this.evaluator = evaluator;
        this.sourceRoots = sourceRoots;
        this.testSourceRoots = testSourceRoots;
        evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)evaluator));
    }

    private synchronized FileObject getDir(String propname) {
        String prop;
        FileObject fo = this.dirCache.get(propname);
        if (!(fo != null && fo.isValid() || (prop = this.evaluator.getProperty(propname)) == null)) {
            fo = this.helper.resolveFileObject(prop);
            this.dirCache.put(propname, fo);
        }
        return fo;
    }

    private FileObject[] getPrimarySrcPath() {
        return this.sourceRoots.getRoots();
    }

    private FileObject[] getTestSrcDir() {
        return this.testSourceRoots.getRoots();
    }

    private FileObject getBuildClassesDir() {
        return this.getDir(BUILD_CLASSES_DIR);
    }

    private FileObject getDistJar() {
        return this.getDir(DIST_JAR);
    }

    private FileObject getBuildTestClassesDir() {
        return this.getDir(BUILD_TEST_CLASSES_DIR);
    }

    private int getType(FileObject file) {
        FileObject root;
        int i;
        FileObject[] srcPath = this.getPrimarySrcPath();
        for (i = 0; i < srcPath.length; ++i) {
            root = srcPath[i];
            if (!root.equals(file) && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
            return 0;
        }
        srcPath = this.getTestSrcDir();
        for (i = 0; i < srcPath.length; ++i) {
            root = srcPath[i];
            if (!root.equals(file) && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
            return 1;
        }
        FileObject dir = this.getBuildClassesDir();
        if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
            return 2;
        }
        dir = this.getDistJar();
        if (dir != null && dir.equals(FileUtil.getArchiveFile((FileObject)file))) {
            return 4;
        }
        dir = this.getBuildTestClassesDir();
        if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
            return 3;
        }
        return -1;
    }

    private synchronized ClassPath getSourcepath(FileObject file) {
        int type = this.getType(file);
        return this.getSourcepath(type);
    }

    private ClassPath getSourcepath(int type) {
        if (type < 0 || type > 1) {
            return null;
        }
        ClassPath cp = this.cache[type];
        if (cp == null) {
            switch (type) {
                case 0: {
                    cp = ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePathImplementation(this.sourceRoots, this.helper, this.evaluator));
                    break;
                }
                case 1: {
                    cp = ClassPathFactory.createClassPath((ClassPathImplementation)new GroupClassPathImplementation(new SourcePathImplementation[]{new SourcePathImplementation(this.testSourceRoots), new SourcePathImplementation(this.sourceRoots, this.helper, this.evaluator)}));
                }
            }
        }
        this.cache[type] = cp;
        return cp;
    }

    private synchronized ClassPath getBootClassPath() {
        ClassPath cp = this.cache[7];
        if (cp == null) {
            this.cache[7] = cp = ClassPathFactory.createClassPath((ClassPathImplementation)new BootClassPathImplementation(this.evaluator));
        }
        return cp;
    }

    public ClassPath findClassPath(FileObject file, String type) {
        if (type.equals("ruby/classpath/source")) {
            return this.getSourcepath(file);
        }
        if (type.equals("ruby/classpath/boot")) {
            return this.getBootClassPath();
        }
        if (type.equals("ruby/classpath/compile")) {
            return this.getBootClassPath();
        }
        return null;
    }

    public ClassPath[] getProjectClassPaths(String type) {
        if ("ruby/classpath/boot".equals(type)) {
            return new ClassPath[]{this.getBootClassPath()};
        }
        if ("ruby/classpath/source".equals(type)) {
            ClassPath[] l = new ClassPath[]{this.getSourcepath(0), this.getSourcepath(1)};
            return l;
        }
        return null;
    }

    public ClassPath getProjectSourcesClassPath(String type) {
        if ("ruby/classpath/boot".equals(type)) {
            return this.getBootClassPath();
        }
        if ("ruby/classpath/source".equals(type)) {
            return this.getSourcepath(0);
        }
        return null;
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        this.dirCache.remove(evt.getPropertyName());
    }

    public String getPropertyName(SourceGroup sg, String type) {
        int i;
        FileObject root = sg.getRootFolder();
        FileObject[] path = this.getPrimarySrcPath();
        for (i = 0; i < path.length; ++i) {
            if (!root.equals(path[i])) continue;
            if ("ruby/classpath/compile".equals(type)) {
                return JAVAC_CLASSPATH;
            }
            if ("ruby/classpath/execute".equals(type)) {
                return RUN_CLASSPATH;
            }
            return null;
        }
        path = this.getTestSrcDir();
        for (i = 0; i < path.length; ++i) {
            if (!root.equals(path[i])) continue;
            if ("ruby/classpath/compile".equals(type)) {
                return JAVAC_TEST_CLASSPATH;
            }
            if ("ruby/classpath/execute".equals(type)) {
                return RUN_TEST_CLASSPATH;
            }
            return null;
        }
        return null;
    }
}

