/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui;

import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.ui.GemNode;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;

final class GemChildrenFactory
extends ChildFactory<FileObject> {
    private final RubyPlatform platform;
    private static final String GEMS_DIR = "gems";
    private static final FileFilter DIRS = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };
    private static final Comparator<FileObject> NAME_COMPARATOR = new Comparator<FileObject>(){

        @Override
        public int compare(FileObject o1, FileObject o2) {
            return o1.getNameExt().compareToIgnoreCase(o2.getNameExt());
        }
    };
    private final FileChangeListener fileListener = new FileChangeListener(){

        public void fileFolderCreated(FileEvent fe) {
            GemChildrenFactory.this.refresh(false);
        }

        public void fileDataCreated(FileEvent fe) {
            GemChildrenFactory.this.refresh(false);
        }

        public void fileChanged(FileEvent fe) {
            GemChildrenFactory.this.refresh(false);
        }

        public void fileDeleted(FileEvent fe) {
            GemChildrenFactory.this.refresh(false);
        }

        public void fileRenamed(FileRenameEvent fe) {
            GemChildrenFactory.this.refresh(false);
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
            GemChildrenFactory.this.refresh(false);
        }
    };

    public static GemChildrenFactory create(RubyBaseProject project) {
        RubyPlatform platform = RubyPlatform.platformFor((Project)project);
        GemChildrenFactory result = new GemChildrenFactory(platform);
        return result;
    }

    private GemChildrenFactory(RubyPlatform platform) {
        this.platform = platform;
    }

    protected Node createNodeForKey(FileObject key) {
        return new GemNode(key);
    }

    protected boolean createKeys(List<FileObject> toPopulate) {
        GemManager gemManager = this.platform.getGemManager();
        if (gemManager == null) {
            return true;
        }
        for (File repo : gemManager.getRepositories()) {
            File gemsDir = new File(repo, GEMS_DIR);
            if (!gemsDir.exists() || !gemsDir.isDirectory()) continue;
            try {
                FileUtil.addFileChangeListener((FileChangeListener)this.fileListener, (File)gemsDir);
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
            for (File gem : gemsDir.listFiles(DIRS)) {
                toPopulate.add(FileUtil.toFileObject((File)gem));
            }
        }
        Collections.sort(toPopulate, NAME_COMPARATOR);
        return true;
    }
}

