/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.core.ui.top;

import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.asm.core.assistance.RegisterChooser;
import org.netbeans.modules.cnd.asm.core.assistance.RegisterChooserListener;
import org.netbeans.modules.cnd.asm.core.assistance.RegisterUsageAccesor;
import org.netbeans.modules.cnd.asm.core.dataobjects.AsmObjectUtilities;
import org.netbeans.modules.cnd.asm.core.ui.top.NavigatorTab;
import org.netbeans.modules.cnd.asm.core.ui.top.ext.TableSorter;
import org.netbeans.modules.cnd.asm.model.AsmModel;
import org.netbeans.modules.cnd.asm.model.lang.Register;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class RegisterUsagesPanel
extends JPanel
implements NavigatorTab,
RegisterUsageAccesor,
PropertyChangeListener {
    private AsmModel model;
    private final DefaultTableModel tableModel;
    private RegisterChooserListener chooserListener;
    private static RegisterUsagesPanel instance;
    public static final Color ARG_COLOR;
    public static final Color READ_COLOR;
    public static final Color USED_COLOR;
    public static final Color WRITE_COLOR;
    private JTable jRegisterTable;
    private JScrollPane jTableScrollPane;

    public static synchronized RegisterUsagesPanel getInstance() {
        if (instance == null) {
            instance = new RegisterUsagesPanel();
        }
        return instance;
    }

    private RegisterUsagesPanel() {
        this.initComponents();
        this.tableModel = new RegisterTableModel();
        TableSorter tmpModel = new TableSorter(this.tableModel);
        tmpModel.setColumnComparator(String.class, TableSorter.LEXICAL_COMPARATOR);
        tmpModel.setTableHeader(this.jRegisterTable.getTableHeader());
        this.jRegisterTable.setDefaultRenderer(Register.class, new RegisterCellRendererForRegister());
        this.jRegisterTable.setDefaultRenderer(RegisterUsageAccesor.RegisterStatus.class, new RegisterCellRendererForUsage());
        this.jRegisterTable.setModel(tmpModel);
        this.jRegisterTable.getSelectionModel().addListSelectionListener(new RegisterSelectionListener());
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(RegisterUsagesPanel.class, (String)"CTL_REGS_NAME");
    }

    public void setChooserListener(RegisterChooserListener chooserListener) {
        this.chooserListener = chooserListener;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public void opened() {
    }

    public void closed() {
    }

    @Override
    public void setDocument(DataObject dob) {
        this.model = AsmObjectUtilities.getModel(dob);
        if (this.model == null) {
            return;
        }
        Document doc = AsmObjectUtilities.getDocument(dob);
        this.chooserListener = (RegisterChooserListener)doc.getProperty(RegisterChooserListener.class);
        this.setRegisters();
        this.updateRegisterValues();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateRegisterValues();
    }

    private void updateRegisterValues() {
    }

    private static boolean isTheSame(Register reg, String name) {
        if (reg.getName().equals(name)) {
            return true;
        }
        for (Register child : reg.getChildren()) {
            if (!child.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setRegisterStatus(Register reg, RegisterUsageAccesor.RegisterStatus status) {
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            if (reg != this.tableModel.getValueAt(i, 0)) continue;
            this.tableModel.setValueAt(status, i, 1);
            return;
        }
    }

    @Override
    public void setRegisterStatus(Collection<Register> regs, RegisterUsageAccesor.RegisterStatus status) {
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            if (!regs.contains(this.tableModel.getValueAt(i, 0))) continue;
            this.tableModel.setValueAt(status, i, 1);
        }
    }

    @Override
    public void clearStatuses() {
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            this.tableModel.setValueAt("", i, 1);
        }
    }

    public void clearValues() {
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            this.tableModel.setValueAt("", i, 2);
        }
    }

    private void setRegisters() {
        this.tableModel.setNumRows(0);
        for (Register reg : this.model.getRegisterSet()) {
            if (reg.getDirectParent() != null) continue;
            this.tableModel.addRow(new Object[]{reg, "", ""});
        }
    }

    private void initComponents() {
        this.jTableScrollPane = new JScrollPane();
        this.jRegisterTable = new JTable();
        this.jTableScrollPane.setViewportView(this.jRegisterTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTableScrollPane, -1, 445, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTableScrollPane, -1, 329, Short.MAX_VALUE));
    }

    static {
        ARG_COLOR = new Color(235, 222, 194);
        READ_COLOR = new Color(220, 234, 196);
        USED_COLOR = new Color(253, 242, 196);
        WRITE_COLOR = new Color(235, 199, 194);
    }

    private static class RegisterTableModel
    extends DefaultTableModel {
        public static final int COLUMN_REGISTER = 0;
        public static final int COLUMN_USAGE = 1;
        public static final int COLUMN_VALUE = 2;
        private Class[] types = new Class[]{Register.class, RegisterUsageAccesor.RegisterStatus.class, String.class};

        public RegisterTableModel() {
            super(new Object[0][], new String[]{NbBundle.getMessage(RegisterUsagesPanel.class, (String)"LBL_REGUSAGE_REGISTER"), NbBundle.getMessage(RegisterUsagesPanel.class, (String)"LBL_REGUSAGE_USAGE"), NbBundle.getMessage(RegisterUsagesPanel.class, (String)"LBL_REGUSAGE_VALUE")});
        }

        public Class getColumnClass(int columnIndex) {
            return this.types[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }

    private static class RegisterCellRendererForRegister
    extends DefaultTableCellRenderer.UIResource {
        public RegisterCellRendererForRegister() {
            this.setHorizontalAlignment(0);
        }
    }

    private static class RegisterCellRendererForUsage
    extends DefaultTableCellRenderer.UIResource {
        public RegisterCellRendererForUsage() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setEnabled(table == null || table.isEnabled());
            if (RegisterUsageAccesor.PredefinedStatuses.STATUS_ARG.equals(value)) {
                this.setBackground(ARG_COLOR);
            } else if (RegisterUsageAccesor.PredefinedStatuses.STATUS_READ.equals(value)) {
                this.setBackground(READ_COLOR);
            } else if (RegisterUsageAccesor.PredefinedStatuses.STATUS_USED.equals(value)) {
                this.setBackground(USED_COLOR);
            } else if (RegisterUsageAccesor.PredefinedStatuses.STATUS_WRITE.equals(value)) {
                this.setBackground(WRITE_COLOR);
            } else {
                this.setBackground(null);
            }
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return this;
        }
    }

    private class RegisterSelectionListener
    implements ListSelectionListener {
        private RegisterSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int sel = RegisterUsagesPanel.this.jRegisterTable.getSelectedRow();
            if (RegisterUsagesPanel.this.chooserListener != null) {
                if (sel != -1) {
                    final Register reg = (Register)RegisterUsagesPanel.this.tableModel.getValueAt(sel, 0);
                    RegisterUsagesPanel.this.chooserListener.update(new RegisterChooser(){

                        @Override
                        public Collection<Register> getRegisters() {
                            return Arrays.asList(reg);
                        }
                    });
                } else {
                    RegisterUsagesPanel.this.chooserListener.update(new RegisterChooser(){

                        @Override
                        public Collection<Register> getRegisters() {
                            return Collections.emptyList();
                        }
                    });
                }
            }
        }
    }
}

