/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.refactoring;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.refactoring.RefactoringUtil;
import org.netbeans.modules.web.refactoring.WebRefactoring;
import org.netbeans.modules.web.refactoring.WebRefactoringPlugin;
import org.netbeans.modules.web.refactoring.rename.TldFolderMove;
import org.netbeans.modules.web.refactoring.rename.TldMove;
import org.netbeans.modules.web.refactoring.rename.TldPackageRename;
import org.netbeans.modules.web.refactoring.rename.TldRename;
import org.netbeans.modules.web.refactoring.rename.WebXmlFolderMove;
import org.netbeans.modules.web.refactoring.rename.WebXmlMove;
import org.netbeans.modules.web.refactoring.rename.WebXmlPackageRename;
import org.netbeans.modules.web.refactoring.rename.WebXmlRename;
import org.netbeans.modules.web.refactoring.safedelete.TldSafeDelete;
import org.netbeans.modules.web.refactoring.safedelete.WebXmlSafeDelete;
import org.netbeans.modules.web.refactoring.whereused.TldWhereUsed;
import org.netbeans.modules.web.refactoring.whereused.WebXmlWhereUsed;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class WebRefactoringFactory
implements RefactoringPluginFactory {
    private static final Logger LOGGER = Logger.getLogger(WebRefactoringFactory.class.getName());

    public RefactoringPlugin createInstance(AbstractRefactoring abstractRefactoring) {
        RenameRefactoring renameRefactoring;
        boolean bl;
        NonRecursiveFolder nonRecursiveFolder = (NonRecursiveFolder)abstractRefactoring.getRefactoringSource().lookup(NonRecursiveFolder.class);
        FileObject fileObject = (FileObject)abstractRefactoring.getRefactoringSource().lookup(FileObject.class);
        TreePathHandle treePathHandle = this.resolveTreePathHandle(abstractRefactoring);
        boolean bl2 = nonRecursiveFolder != null && RefactoringUtil.isOnSourceClasspath(nonRecursiveFolder.getFolder());
        boolean bl3 = bl = fileObject != null && fileObject.isFolder();
        if (fileObject == null) {
            if (treePathHandle != null) {
                fileObject = treePathHandle.getFileObject();
            } else if (nonRecursiveFolder != null) {
                fileObject = nonRecursiveFolder.getFolder();
            }
        }
        if (fileObject == null) {
            return null;
        }
        boolean bl4 = fileObject != null && RefactoringUtil.isJavaFile(fileObject);
        WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
        if (webModule == null) {
            return null;
        }
        FileObject fileObject2 = webModule.getDeploymentDescriptor();
        WebApp webApp = this.getWebApp(fileObject2);
        String string = this.resolveClass(treePathHandle);
        if (bl4 && string == null) {
            LOGGER.fine("Could not resolve the class for: " + fileObject + ", possibly an empty Java file");
            return null;
        }
        ArrayList<WebRefactoring> arrayList = new ArrayList<WebRefactoring>();
        if (abstractRefactoring instanceof RenameRefactoring) {
            renameRefactoring = (RenameRefactoring)abstractRefactoring;
            if (bl2 || bl) {
                if (webApp != null) {
                    arrayList.add(new WebXmlPackageRename(fileObject2, webApp, fileObject, renameRefactoring));
                }
                arrayList.add(new TldPackageRename(renameRefactoring, webModule, fileObject));
            } else if (bl4) {
                if (webApp != null) {
                    arrayList.add(new WebXmlRename(string, renameRefactoring, webApp, fileObject2));
                }
                arrayList.add(new TldRename(string, renameRefactoring, webModule));
            }
        }
        if (abstractRefactoring instanceof WhereUsedQuery && bl4) {
            renameRefactoring = (WhereUsedQuery)abstractRefactoring;
            if (webApp != null) {
                arrayList.add(new WebXmlWhereUsed(fileObject2, webApp, string, (WhereUsedQuery)renameRefactoring));
            }
            arrayList.add(new TldWhereUsed(string, webModule, (WhereUsedQuery)renameRefactoring));
        }
        if (abstractRefactoring instanceof SafeDeleteRefactoring && bl4) {
            renameRefactoring = (SafeDeleteRefactoring)abstractRefactoring;
            if (webApp != null) {
                arrayList.add(new WebXmlSafeDelete(fileObject2, webApp, (SafeDeleteRefactoring)renameRefactoring));
            }
            arrayList.add(new TldSafeDelete((SafeDeleteRefactoring)renameRefactoring, webModule));
        }
        if (abstractRefactoring instanceof MoveRefactoring) {
            renameRefactoring = (MoveRefactoring)abstractRefactoring;
            if (bl4) {
                if (webApp != null) {
                    arrayList.add(new WebXmlMove(fileObject2, webApp, (MoveRefactoring)renameRefactoring));
                }
                arrayList.add(new TldMove((MoveRefactoring)renameRefactoring, webModule));
            } else if (bl) {
                if (webApp != null) {
                    arrayList.add(new WebXmlFolderMove(fileObject2, webApp, fileObject, (MoveRefactoring)renameRefactoring));
                }
                arrayList.add(new TldFolderMove(webModule, fileObject, (MoveRefactoring)renameRefactoring));
            }
        }
        return arrayList.isEmpty() ? null : new WebRefactoringPlugin(arrayList);
    }

    private WebApp getWebApp(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        try {
            return DDProvider.getDefault().getDDRoot(fileObject);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
    }

    private TreePathHandle resolveTreePathHandle(AbstractRefactoring abstractRefactoring) {
        TreePathHandle treePathHandle = (TreePathHandle)abstractRefactoring.getRefactoringSource().lookup(TreePathHandle.class);
        if (treePathHandle != null) {
            return treePathHandle;
        }
        FileObject fileObject = (FileObject)abstractRefactoring.getRefactoringSource().lookup(FileObject.class);
        if (fileObject == null || !RefactoringUtil.isJavaFile(fileObject)) {
            return null;
        }
        final TreePathHandle[] treePathHandleArray = new TreePathHandle[1];
        try {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.RESOLVED);
                    CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                    if (compilationUnitTree.getTypeDecls().isEmpty()) {
                        return;
                    }
                    treePathHandleArray[0] = TreePathHandle.create((TreePath)TreePath.getPath(compilationUnitTree, compilationUnitTree.getTypeDecls().get(0)), (CompilationInfo)compilationController);
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return treePathHandleArray[0];
    }

    private String resolveClass(final TreePathHandle treePathHandle) {
        if (treePathHandle == null) {
            return null;
        }
        final String[] stringArray = new String[1];
        try {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)treePathHandle.getFileObject());
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.RESOLVED);
                    Element element = treePathHandle.resolveElement((CompilationInfo)compilationController);
                    stringArray[0] = element == null ? null : ((Object)element.asType()).toString();
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return stringArray[0];
    }
}

