/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.vmd.api.model.AccessController;
import org.netbeans.modules.vmd.api.model.AccessControllerFactory;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.openide.util.Lookup;

final class AccessControllerFactoryRegistry {
    private static final Lookup.Result factoriesLookupResult = Lookup.getDefault().lookupResult(AccessControllerFactory.class);

    AccessControllerFactoryRegistry() {
    }

    static List<AccessController> createAccessControllers(DesignDocument document) {
        ArrayList<AccessController> controllers = new ArrayList<AccessController>();
        for (Object factory : factoriesLookupResult.allInstances()) {
            AccessController controller = ((AccessControllerFactory)factory).createAccessController(document);
            if (controller == null) continue;
            controllers.add(controller);
        }
        return Collections.unmodifiableList(controllers);
    }
}

