/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model.presenters.actions;

import java.util.Collection;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PropertyValue;

public abstract class DeleteDependencyPresenter
extends Presenter {
    protected abstract boolean requiresToLive(Collection<DesignComponent> var1);

    protected abstract void componentsDeleting(Collection<DesignComponent> var1);

    public static Presenter createNullableComponentReferencePresenter(final String ... propertyNames) {
        return new DeleteDependencyPresenter(){

            @Override
            protected boolean requiresToLive(Collection<DesignComponent> componentsToDelete) {
                return false;
            }

            @Override
            protected void componentsDeleting(Collection<DesignComponent> componentsToDelete) {
                for (String propertyName : propertyNames) {
                    DesignComponent component = this.getComponent().readProperty(propertyName).getComponent();
                    if (component == null || !componentsToDelete.contains(component)) continue;
                    this.getComponent().writeProperty(propertyName, PropertyValue.createNull());
                }
            }
        };
    }

    public static Presenter createDependentOnParentComponentPresenter() {
        return new DeleteDependencyPresenter(){

            @Override
            protected boolean requiresToLive(Collection<DesignComponent> componentsToDelete) {
                DesignComponent parentComponent = this.getComponent().getParentComponent();
                return parentComponent != null && componentsToDelete.contains(parentComponent);
            }

            @Override
            protected void componentsDeleting(Collection<DesignComponent> componentsToDelete) {
            }
        };
    }

    public static Presenter createDependentOnPropertyPresenter(final String propertyName) {
        return new DeleteDependencyPresenter(){

            @Override
            protected boolean requiresToLive(Collection<DesignComponent> componentsToDelete) {
                DesignComponent component = this.getComponent().readProperty(propertyName).getComponent();
                return component != null && componentsToDelete.contains(component);
            }

            @Override
            protected void componentsDeleting(Collection<DesignComponent> componentsToDelete) {
            }
        };
    }
}

