/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.inspector;

import java.beans.PropertyVetoException;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.inspector.InspectorManagerView;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public final class InspectorUIManagerSupport {
    public static void selectNodesInInspector(DesignDocument document, String nameToSelect) {
        DataObjectContext context = ProjectUtils.getDataObjectContextForDocument((DesignDocument)document);
        ExplorerManager manager = InspectorManagerView.getExplorerManager(context);
        if (manager == null) {
            return;
        }
        Node rootNode = manager.getRootContext();
        Node nodeToSelect = InspectorUIManagerSupport.dive(rootNode, nameToSelect);
        if (nodeToSelect != null) {
            try {
                manager.setSelectedNodes(new Node[]{nodeToSelect});
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static Node dive(Node parentNode, String nameToSelect) {
        Children children = parentNode.getChildren();
        for (Node node : children.getNodes()) {
            Node nodeToSelect;
            if (node.getHtmlDisplayName().equals(nameToSelect) || node.getDisplayName().equals(nameToSelect)) {
                return node;
            }
            if (node.getChildren() == null || (nodeToSelect = InspectorUIManagerSupport.dive(node, nameToSelect)) == null) continue;
            return nodeToSelect;
        }
        return null;
    }
}

