/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.ui.actions;

import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public class RefreshServiceAction
extends NodeAction {
    protected boolean enable(Node[] nodes) {
        if (nodes == null || nodes.length != 1) {
            return false;
        }
        Saas saas = (Saas)nodes[0].getLookup().lookup(Saas.class);
        return saas != null && saas.getState() != Saas.State.INITIALIZING;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected String iconResource() {
        return "org/netbeans/modules/websvc/saas/ui/resources/ActionIcon.gif";
    }

    public String getName() {
        return NbBundle.getMessage(RefreshServiceAction.class, (String)"REFRESH");
    }

    protected void performAction(Node[] nodes) {
        if (nodes == null || nodes.length != 1) {
            return;
        }
        final Saas saas = (Saas)nodes[0].getLookup().lookup(Saas.class);
        String msg = NbBundle.getMessage(RefreshServiceAction.class, (String)"WS_REFRESH");
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)msg, 0);
        Object response = DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
        if (null != response && response.equals(NotifyDescriptor.YES_OPTION)) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        SaasServicesModel.getInstance().refreshService(saas);
                    }
                    catch (Exception ex) {
                        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)ex.getMessage());
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                    }
                }
            });
        }
    }

    protected boolean asynchronous() {
        return false;
    }
}

