/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.ui.wizards;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.SaasGroup;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.netbeans.modules.websvc.saas.util.WsdlUtil;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class AddWebServiceDlg
extends JPanel
implements ActionListener {
    public static final String DEFAULT_PACKAGE_HOLDER = NbBundle.getMessage(AddWebServiceDlg.class, (String)"MSG_ClickToOverride");
    private DialogDescriptor dlg = null;
    private String addString = NbBundle.getMessage(AddWebServiceDlg.class, (String)"Add");
    private String cancelString = NbBundle.getMessage(AddWebServiceDlg.class, (String)"CANCEL");
    private Dialog dialog;
    private static String previousDirectory = null;
    private static JFileChooser wsdlFileChooser;
    private final FileFilter WSDL_FILE_FILTER = new ServiceFileFilter();
    private SaasGroup group;
    private final boolean jaxRPCAvailable;
    private String defaultMsg;
    private boolean allControlsDisabled;
    private static final String[] KEYWORDS;
    private static final Set<String> KEYWORD_SET;
    private ButtonGroup buttonGroup1;
    private JLabel errorLabel;
    private JButton jBtnBrowse;
    private JButton jBtnProxy;
    private JLabel jLblChooseSource;
    private JRadioButton jRbnFilesystem;
    private JRadioButton jRbnUrl;
    private JTextField jTxServiceURL;
    private JTextField jTxtLocalFilename;
    private JTextField jTxtpackageName;
    private JLabel pkgNameLbl;

    public AddWebServiceDlg(SaasGroup group) {
        this.initComponents();
        this.myInitComponents();
        this.group = group;
        this.jaxRPCAvailable = WsdlUtil.isJAXRPCAvailable();
        this.defaultMsg = this.jaxRPCAvailable ? "" : NbBundle.getMessage(AddWebServiceDlg.class, (String)"WARNING_JAXRPC_UNAVAILABLE");
        this.checkServicesModel();
    }

    private static boolean isValidPackageName(String packageName) {
        if (packageName == null || packageName.length() == 0) {
            return true;
        }
        if (!Character.isJavaIdentifierStart(packageName.charAt(0))) {
            return false;
        }
        StringTokenizer pkgIds = new StringTokenizer(packageName, ".");
        while (pkgIds.hasMoreTokens()) {
            String nextIdStr = pkgIds.nextToken();
            if (KEYWORD_SET.contains(nextIdStr)) {
                return false;
            }
            char[] nextId = nextIdStr.toCharArray();
            if (!Character.isJavaIdentifierStart(nextId[0])) {
                return false;
            }
            for (int i = 1; i < nextId.length; ++i) {
                if (Character.isJavaIdentifierPart(nextId[i])) continue;
                return false;
            }
        }
        boolean lastDot = false;
        for (int i = 0; i < packageName.length(); ++i) {
            boolean isDot;
            boolean bl = isDot = packageName.charAt(i) == '.';
            if (isDot && lastDot) {
                return false;
            }
            lastDot = isDot;
        }
        return !packageName.endsWith(".");
    }

    private void setErrorMessage(String msg) {
        if (msg == null || msg.length() == 0) {
            this.errorLabel.setVisible(false);
            if (this.dlg != null) {
                this.dlg.setValid(true);
            }
        } else {
            this.errorLabel.setVisible(true);
            this.errorLabel.setText(msg);
            if (this.dlg != null) {
                if (msg.equals(this.defaultMsg)) {
                    this.dlg.setValid(true);
                } else {
                    this.dlg.setValid(false);
                }
            }
        }
    }

    private void checkValues() {
        block14: {
            boolean defaultPackage;
            String packageName = this.jTxtpackageName.getText().trim();
            boolean bl = defaultPackage = DEFAULT_PACKAGE_HOLDER.equals(packageName) || packageName.length() == 0;
            if (!defaultPackage && !AddWebServiceDlg.isValidPackageName(packageName)) {
                this.setErrorMessage(NbBundle.getMessage(AddWebServiceDlg.class, (String)"INVALID_PACKAGE"));
            } else if (this.jTxtLocalFilename.isEnabled()) {
                String localText = this.jTxtLocalFilename.getText().trim();
                if (localText.length() == 0) {
                    this.setErrorMessage(NbBundle.getMessage(AddWebServiceDlg.class, (String)"EMPTY_FILE"));
                    return;
                }
                File f = new File(localText);
                if (!f.exists()) {
                    this.setErrorMessage(NbBundle.getMessage(AddWebServiceDlg.class, (String)"INVALID_FILE_NOT_FOUND"));
                    return;
                }
                if (!f.isFile()) {
                    this.setErrorMessage(NbBundle.getMessage(AddWebServiceDlg.class, (String)"INVALID_FILE_NOT_FILE"));
                    return;
                }
                if (this.group.serviceExists(localText)) {
                    this.setErrorMessage(NbBundle.getMessage(AddWebServiceDlg.class, (String)"SERVICE_ALREADY_EXISTS_FOR_FILE"));
                    return;
                }
                this.setErrorMessage(this.defaultMsg);
            } else if (this.jTxServiceURL.isEnabled()) {
                String urlText = this.jTxServiceURL.getText().trim();
                if (urlText.length() == 0) {
                    this.setErrorMessage(NbBundle.getMessage(AddWebServiceDlg.class, (String)"EMPTY_URL"));
                    return;
                }
                try {
                    URL url = new URL(urlText);
                    if (this.group.serviceExists(urlText)) {
                        this.setErrorMessage(NbBundle.getMessage(AddWebServiceDlg.class, (String)"SERVICE_ALREADY_EXISTS_FOR_URL"));
                        break block14;
                    }
                    this.setErrorMessage(this.defaultMsg);
                }
                catch (MalformedURLException ex) {
                    this.setErrorMessage(NbBundle.getMessage(AddWebServiceDlg.class, (String)"INVALID_URL"));
                }
            } else {
                this.setErrorMessage(this.defaultMsg);
            }
        }
    }

    private void myInitComponents() {
        wsdlFileChooser = new JFileChooser();
        ServiceFileFilter myFilter = new ServiceFileFilter();
        wsdlFileChooser.setFileFilter(myFilter);
        this.jTxtLocalFilename.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddWebServiceDlg.this.checkValues();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddWebServiceDlg.this.checkValues();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddWebServiceDlg.this.checkValues();
            }
        });
        this.jTxServiceURL.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddWebServiceDlg.this.checkValues();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddWebServiceDlg.this.checkValues();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddWebServiceDlg.this.checkValues();
            }
        });
        this.jTxtpackageName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddWebServiceDlg.this.checkValues();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddWebServiceDlg.this.checkValues();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddWebServiceDlg.this.checkValues();
            }
        });
        this.enableControls();
        this.setDefaults();
        this.jTxtpackageName.setText(DEFAULT_PACKAGE_HOLDER);
        this.jTxtpackageName.setForeground(Color.GRAY);
    }

    public void displayDialog() {
        this.dlg = new DialogDescriptor((Object)this, NbBundle.getMessage(AddWebServiceDlg.class, (String)"ADD_WEB_SERVICE"), true, 2, DialogDescriptor.OK_OPTION, 0, this.getHelpCtx(), (ActionListener)this);
        this.dialog = DialogDisplayer.getDefault().createDialog(this.dlg);
        this.dlg.setValid(false);
        this.dialog.setVisible(true);
        if (this.dlg.getValue() == DialogDescriptor.OK_OPTION) {
            this.createService();
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("projrave_ui_elements_server_nav_add_websvcdb");
    }

    private void setDefaults() {
        this.jRbnUrl.setSelected(true);
        this.jRbnFilesystem.setSelected(false);
        this.enableControls();
    }

    private void enableControls() {
        if (this.allControlsDisabled) {
            return;
        }
        if (this.jRbnUrl.isSelected()) {
            this.jTxServiceURL.setEnabled(true);
            this.jTxServiceURL.requestFocusInWindow();
            this.jTxtLocalFilename.setEnabled(false);
            this.jLblChooseSource.setLabelFor(this.jTxServiceURL);
        } else if (this.jRbnFilesystem.isSelected()) {
            this.jTxtLocalFilename.setEnabled(true);
            this.jTxtLocalFilename.requestFocusInWindow();
            this.jTxServiceURL.setEnabled(false);
            this.jLblChooseSource.setLabelFor(this.jTxtLocalFilename);
        }
    }

    private void disableAllControls() {
        this.allControlsDisabled = true;
        this.jBtnBrowse.setEnabled(false);
        this.jBtnProxy.setEnabled(false);
        this.jRbnFilesystem.setEnabled(false);
        this.jRbnUrl.setEnabled(false);
        this.jTxServiceURL.setEnabled(false);
        this.jTxtLocalFilename.setEnabled(false);
        this.jTxtpackageName.setEnabled(false);
        this.pkgNameLbl.setEnabled(false);
    }

    private void enableAllControls() {
        this.allControlsDisabled = false;
        this.jBtnBrowse.setEnabled(true);
        this.jBtnProxy.setEnabled(true);
        this.jRbnFilesystem.setEnabled(true);
        this.jRbnUrl.setEnabled(true);
        this.jTxServiceURL.setEnabled(true);
        this.jTxtLocalFilename.setEnabled(true);
        this.jTxtpackageName.setEnabled(true);
        this.pkgNameLbl.setEnabled(true);
    }

    private String fixFileURL(String inFileURL) {
        String returnFileURL = inFileURL;
        try {
            File f = new File(returnFileURL);
            return f.toURI().toURL().toString();
        }
        catch (Exception ex) {
            returnFileURL = returnFileURL.substring(0, 1).equalsIgnoreCase("/") ? "file://" + returnFileURL : "file:///" + returnFileURL;
            return returnFileURL;
        }
    }

    private void createService() {
        if (this.jTxServiceURL.getText() == null && this.jTxtLocalFilename.getText() == null) {
            return;
        }
        String url = this.jRbnUrl.isSelected() ? this.jTxServiceURL.getText().trim() : this.fixFileURL(this.jTxtLocalFilename.getText().trim());
        String packageName = this.jTxtpackageName.getText().trim();
        if (packageName.equals(NbBundle.getMessage(AddWebServiceDlg.class, (String)"MSG_ClickToOverride"))) {
            packageName = "";
        }
        this.dialog.setVisible(false);
        this.dialog.dispose();
        this.dialog = null;
        try {
            SaasServicesModel.getInstance().createSaasService(this.group, url, packageName);
        }
        catch (Exception ex) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)ex.getMessage());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
        }
    }

    private void checkServicesModel() {
        if (SaasServicesModel.getInstance().getState() != SaasServicesModel.State.READY) {
            this.setErrorMessage(NbBundle.getMessage(AddWebServiceDlg.class, (String)"INIT_WEB_SERVICES_MANAGER"));
            this.disableAllControls();
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    SaasServicesModel.getInstance().initRootGroup();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AddWebServiceDlg.this.enableAllControls();
                            AddWebServiceDlg.this.enableControls();
                            AddWebServiceDlg.this.checkValues();
                        }
                    });
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLblChooseSource = new JLabel();
        this.jRbnFilesystem = new JRadioButton();
        this.jTxtLocalFilename = new JTextField();
        this.jBtnBrowse = new JButton();
        this.jRbnUrl = new JRadioButton();
        this.jTxServiceURL = new JTextField();
        this.jBtnProxy = new JButton();
        this.pkgNameLbl = new JLabel();
        this.jTxtpackageName = new JTextField();
        this.errorLabel = new JLabel();
        this.errorLabel.setVisible(false);
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorMoved(AncestorEvent evt) {
            }

            @Override
            public void ancestorAdded(AncestorEvent evt) {
                AddWebServiceDlg.this.formAncestorAdded(evt);
            }

            @Override
            public void ancestorRemoved(AncestorEvent evt) {
            }
        });
        this.jLblChooseSource.setLabelFor(this.jTxServiceURL);
        Mnemonics.setLocalizedText((JLabel)this.jLblChooseSource, (String)NbBundle.getMessage(AddWebServiceDlg.class, (String)"LBL_WsdlSource"));
        this.buttonGroup1.add(this.jRbnFilesystem);
        Mnemonics.setLocalizedText((AbstractButton)this.jRbnFilesystem, (String)NbBundle.getMessage(AddWebServiceDlg.class, (String)"LBL_WsdlSourceFilesystem"));
        this.jRbnFilesystem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddWebServiceDlg.this.jRbnFilesystemActionPerformed(evt);
            }
        });
        this.jTxtLocalFilename.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.jBtnBrowse, (String)NbBundle.getMessage(AddWebServiceDlg.class, (String)"LBL_Browse"));
        this.jBtnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddWebServiceDlg.this.jBtnBrowseActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRbnUrl);
        this.jRbnUrl.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jRbnUrl, (String)NbBundle.getMessage(AddWebServiceDlg.class, (String)"LBL_WsdlUrl"));
        this.jRbnUrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddWebServiceDlg.this.jRbnUrlActionPerformed(evt);
            }
        });
        this.jTxServiceURL.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.jBtnProxy, (String)NbBundle.getMessage(AddWebServiceDlg.class, (String)"LBL_ProxySettings"));
        this.jBtnProxy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddWebServiceDlg.this.jBtnProxyActionPerformed(evt);
            }
        });
        this.pkgNameLbl.setLabelFor(this.jTxtpackageName);
        Mnemonics.setLocalizedText((JLabel)this.pkgNameLbl, (String)NbBundle.getMessage(AddWebServiceDlg.class, (String)"PACKAGE_LABEL"));
        this.jTxtpackageName.setColumns(20);
        this.jTxtpackageName.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AddWebServiceDlg.this.jTxtpackageNameMouseClicked(evt);
            }
        });
        this.errorLabel.setVerticalTextPosition(1);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLblChooseSource).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.pkgNameLbl).add((Component)this.jRbnFilesystem).add((Component)this.jRbnUrl)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTxServiceURL, -1, 548, Short.MAX_VALUE).add((Component)this.jTxtLocalFilename, -1, 548, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jBtnProxy, -2, 118, -2).add((Component)this.jBtnBrowse, -2, 118, -2)).add(14, 14, 14)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTxtpackageName, -1, 551, Short.MAX_VALUE).add(136, 136, 136)))).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.errorLabel, -1, 769, Short.MAX_VALUE).addContainerGap()))));
        layout.linkSize(new Component[]{this.jBtnBrowse, this.jBtnProxy}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLblChooseSource, -2, 28, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jBtnBrowse).add((Component)this.jTxtLocalFilename, -2, -1, -2)).add((Component)this.jRbnFilesystem)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jRbnUrl).add((Component)this.jBtnProxy).add((Component)this.jTxServiceURL, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.pkgNameLbl).add((Component)this.jTxtpackageName, -2, -1, -2)).addPreferredGap(1).add((Component)this.errorLabel, -1, 59, Short.MAX_VALUE).addContainerGap()));
        this.jLblChooseSource.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddWebServiceDlg.class, (String)"LBL_WsdlSource"));
        this.jRbnFilesystem.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddWebServiceDlg.class, (String)"AddWebServiceDlg.localFilelRadioButton.ACC_desc"));
        this.jTxtLocalFilename.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddWebServiceDlg.class, (String)"AddWebServiceDlg.localFileComboBox.ACC_name"));
        this.jTxtLocalFilename.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddWebServiceDlg.class, (String)"AddWebServiceDlg.localFileComboBox.ACC_desc"));
        this.jBtnBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddWebServiceDlg.class, (String)"AddWebServiceDlg.localFileButton.ACC_desc"));
        this.jRbnUrl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddWebServiceDlg.class, (String)"AddWebServiceDlg.urlRadioButton.ACC_desc"));
        this.jTxServiceURL.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddWebServiceDlg.class, (String)"AddWebServiceDlg.urlComboBox.ACC_name"));
        this.jTxServiceURL.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddWebServiceDlg.class, (String)"AddWebServiceDlg.urlComboBox.ACC_desc"));
        this.jBtnProxy.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddWebServiceDlg.class, (String)"AddWebServiceDlg.httpProxyButton.ACC_desc"));
        this.jTxtpackageName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddWebServiceDlg.class, (String)"AddWebServiceDlg.packageTextField.ACC_name"));
        this.jTxtpackageName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddWebServiceDlg.class, (String)"AddWebServiceDlg.packageTextField.ACC_desc"));
        this.errorLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddWebServiceDlg.class, (String)"AddWebServiceDlg.errorLabel.ACC_name"));
        this.getAccessibleContext().setAccessibleName("null");
        this.getAccessibleContext().setAccessibleDescription("null");
    }

    private void jRbnUrlActionPerformed(ActionEvent evt) {
        this.enableControls();
    }

    private void jBtnProxyActionPerformed(ActionEvent evt) {
        OptionsDisplayer.getDefault().open("General");
    }

    private void jBtnBrowseActionPerformed(ActionEvent evt) {
        this.jRbnFilesystem.setSelected(false);
        this.jRbnFilesystem.setSelected(true);
        this.enableControls();
        JFileChooser chooser = new JFileChooser(previousDirectory);
        chooser.setMultiSelectionEnabled(false);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter(this.WSDL_FILE_FILTER);
        chooser.setFileFilter(this.WSDL_FILE_FILTER);
        if (chooser.showOpenDialog(this) == 0) {
            File wsdlFile = chooser.getSelectedFile();
            this.jTxtLocalFilename.setText(wsdlFile.getAbsolutePath());
            previousDirectory = wsdlFile.getPath();
        }
    }

    private void jRbnFilesystemActionPerformed(ActionEvent evt) {
        this.enableControls();
    }

    private void jTxtpackageNameMouseClicked(MouseEvent evt) {
        this.jTxtpackageName.selectAll();
        this.jTxtpackageName.setForeground(Color.BLACK);
    }

    private void formAncestorAdded(AncestorEvent evt) {
        this.enableControls();
    }

    static {
        KEYWORDS = new String[]{"abstract", "continue", "for", "new", "switch", "assert", "default", "if", "package", "synchronized", "boolean", "do", "goto", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "true", "false", "null"};
        KEYWORD_SET = new HashSet<String>(KEYWORDS.length * 2);
        for (int i = 0; i < KEYWORDS.length; ++i) {
            KEYWORD_SET.add(KEYWORDS[i]);
        }
    }

    private static class ServiceFileFilter
    extends FileFilter {
        private ServiceFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String ext = FileUtil.getExtension((String)f.getName());
            for (int i = 0; i < Saas.SUPPORTED_EXTENSIONS.length; ++i) {
                if (!Saas.SUPPORTED_EXTENSIONS[i].equalsIgnoreCase(ext)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(AddWebServiceDlg.class, (String)"LBL_WsdlFilterDescription");
        }
    }
}

