/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.analyzer;

import java.util.SortedMap;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.db.sql.analyzer.CreateStatement;
import org.netbeans.modules.db.sql.analyzer.SQLStatement;
import org.netbeans.modules.db.sql.analyzer.SQLStatementAnalyzer;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;

class CreateStatementAnalyzer
extends SQLStatementAnalyzer {
    private int bodyStartOffset;
    private int bodyEndOffset;

    public static CreateStatement analyze(TokenSequence<SQLTokenId> seq, SQLIdentifiers.Quoter quoter) {
        seq.moveStart();
        if (!seq.moveNext()) {
            return null;
        }
        CreateStatementAnalyzer sa = new CreateStatementAnalyzer(seq, quoter);
        sa.parse();
        return new CreateStatement(sa.startOffset, seq.offset() + seq.token().length(), (SortedMap<Integer, SQLStatement.Context>)sa.offset2Context, sa.bodyStartOffset, sa.bodyEndOffset);
    }

    private CreateStatementAnalyzer(TokenSequence<SQLTokenId> seq, SQLIdentifiers.Quoter quoter) {
        super(seq, quoter);
    }

    private void parse() {
        this.startOffset = this.seq.offset();
        do {
            switch (this.context) {
                case START: {
                    if (!SQLStatementAnalyzer.isKeyword("CREATE", (TokenSequence<SQLTokenId>)this.seq)) break;
                    this.moveToContext(SQLStatement.Context.CREATE);
                    break;
                }
                case CREATE: {
                    if (SQLStatementAnalyzer.isKeyword("PROCEDURE", (TokenSequence<SQLTokenId>)this.seq)) {
                        this.moveToContext(SQLStatement.Context.CREATE_PROCEDURE);
                        break;
                    }
                    if (!SQLStatementAnalyzer.isKeyword("FUNCTION", (TokenSequence<SQLTokenId>)this.seq)) break;
                    this.moveToContext(SQLStatement.Context.CREATE_FUNCTION);
                    break;
                }
                case CREATE_PROCEDURE: 
                case CREATE_FUNCTION: {
                    if (!SQLStatementAnalyzer.isKeyword("BEGIN", (TokenSequence<SQLTokenId>)this.seq)) break;
                    this.moveToContext(SQLStatement.Context.BEGIN);
                    this.bodyStartOffset = this.seq.offset() + this.seq.token().length();
                    break;
                }
                case BEGIN: {
                    if (!SQLStatementAnalyzer.isKeyword("END", (TokenSequence<SQLTokenId>)this.seq)) break;
                    this.moveToContext(SQLStatement.Context.END);
                    this.bodyEndOffset = this.seq.offset();
                    break;
                }
            }
        } while (this.nextToken());
        if (this.context == SQLStatement.Context.BEGIN) {
            this.bodyEndOffset = this.seq.offset() + this.seq.token().length();
        }
    }
}

