/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.api.completion;

import org.netbeans.modules.db.sql.analyzer.SQLStatementAnalyzer;
import org.netbeans.modules.db.sql.analyzer.SQLStatementKind;
import org.netbeans.modules.db.sql.editor.api.completion.SQLCompletionContext;
import org.netbeans.modules.db.sql.editor.api.completion.SQLCompletionResultSet;
import org.netbeans.modules.db.sql.editor.api.completion.SubstitutionHandler;
import org.netbeans.modules.db.sql.editor.completion.SQLCompletionEnv;
import org.netbeans.modules.db.sql.editor.completion.SQLCompletionQuery;

public class SQLCompletion {
    public static final String UNKNOWN_TAG = "__UNKNOWN__";
    private final SQLCompletionContext initContext;
    private final SQLCompletionQuery delegate;

    public static SQLCompletion create(SQLCompletionContext initContext) {
        return new SQLCompletion(initContext);
    }

    public static boolean canComplete(SQLCompletionContext context) {
        String statement = ((Object)context.getStatement()).toString();
        if (statement == null) {
            throw new NullPointerException("The context's charSequence property should not be null.");
        }
        SQLCompletionEnv env = SQLCompletionEnv.forStatement(statement, 0, null);
        SQLStatementKind kind = SQLStatementAnalyzer.analyzeKind(env.getTokenSequence());
        return kind == SQLStatementKind.SELECT || kind == SQLStatementKind.INSERT || kind == SQLStatementKind.DROP || kind == SQLStatementKind.UPDATE || kind == SQLStatementKind.DELETE;
    }

    private SQLCompletion(SQLCompletionContext initContext) {
        this.initContext = initContext;
        this.delegate = new SQLCompletionQuery(initContext.getDatabaseConnection());
    }

    public void query(SQLCompletionResultSet resultSet, SubstitutionHandler substitutionHandler) {
        SQLCompletionEnv env = SQLCompletionEnv.forStatement(((Object)this.initContext.getStatement()).toString(), this.initContext.getOffset(), substitutionHandler);
        this.delegate.query(resultSet, env);
    }
}

