/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.platform.ricoh;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.netbeans.modules.j2me.cdc.platform.CDCDevice;
import org.netbeans.modules.j2me.cdc.platform.CDCPlatform;
import org.netbeans.modules.j2me.cdc.platform.spi.CDCPlatformDetector;
import org.netbeans.modules.j2me.cdc.platform.spi.CDCPlatformUtil;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;

public class RicohPlatformDetector
extends CDCPlatformDetector {
    public String getPlatformName() {
        return "Ricoh";
    }

    public String getPlatformType() {
        return "ricoh";
    }

    public boolean accept(FileObject dir) {
        FileObject tool = CDCPlatformUtil.findTool((String)"", (String)"startemulator", Collections.singleton(dir));
        return tool != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CDCPlatform detectPlatform(FileObject dir) throws IOException {
        assert (dir != null);
        FileObject java = CDCPlatformUtil.findTool((String)"", (String)"startemulator", Collections.singleton(dir));
        if (java == null) {
            throw new IOException("startemulator can not be found in desired location!");
        }
        File javaFile = FileUtil.toFile((FileObject)java);
        if (javaFile == null) {
            throw new IOException("startemulator can not be found in desired location!");
        }
        String javapath = javaFile.getAbsolutePath();
        FileObject bin = dir.getFileObject("");
        ArrayList jdocs = new ArrayList();
        FileObject base = dir.getFileObject("javadoc");
        if (base != null) {
            RicohPlatformDetector.findJavaDoc(base, jdocs);
        }
        String version = null;
        InputStream is = null;
        try {
            FileObject versionFolder = dir.getFileObject("resource/version");
            FileObject versionFo = versionFolder.getFileObject("version", "txt");
            if (versionFo != null) {
                Properties props = new Properties();
                is = versionFo.getInputStream();
                props.load(is);
                version = props.getProperty("Version");
            }
        }
        catch (IOException ioEx) {
            ErrorManager.getDefault().notify(1, (Throwable)ioEx);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        String plafName = this.getPlatformName() + (version != null ? " " + version : "");
        return new CDCPlatform(plafName, plafName, this.getPlatformType(), "1.3", Collections.singletonList(dir.getURL()), Collections.EMPTY_LIST, jdocs, this.getRicohSDKDevice(javapath, FileUtil.toFile((FileObject)bin), dir), false);
    }

    private static void findJavaDoc(FileObject folder, List folders) {
        int i;
        if (folder == null) {
            return;
        }
        FileObject[] fo = folder.getChildren();
        for (i = 0; i < fo.length; ++i) {
            if (!fo[i].isData() || !"index".equals(fo[i].getName())) continue;
            folders.add(fo[i].getParent());
        }
        for (i = 0; i < fo.length; ++i) {
            if (!fo[i].isFolder() || folders.contains(fo[i].getParent())) continue;
            RicohPlatformDetector.findJavaDoc(fo[i], folders);
        }
    }

    private CDCDevice[] getRicohSDKDevice(String javaPath, File path, FileObject dir) throws IOException {
        StringBuffer bcp = new StringBuffer();
        FileObject[] children = dir.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if ("dsdk.jar".equals(children[i].getNameExt())) {
                JarFileSystem jfs = new JarFileSystem();
                try {
                    jfs.setJarFile(FileUtil.toFile((FileObject)children[i]));
                    FileObject fo = jfs.findResource("jp/co/ricoh/dsdk/xlet/Xlet.class");
                    if (fo == null) {
                        throw new IOException("Invalid bootclasspath");
                    }
                    bcp.append(FileUtil.toFile((FileObject)children[i]).getAbsolutePath() + ";");
                }
                catch (PropertyVetoException ex) {
                }
                catch (IOException ex) {}
                continue;
            }
            if ("foundation.jar".equals(children[i].getNameExt())) {
                bcp.append(FileUtil.toFile((FileObject)children[i]).getAbsolutePath() + ";");
                continue;
            }
            if (!"btclasses.zip".equals(children[i].getNameExt())) continue;
            bcp.append(FileUtil.toFile((FileObject)children[i]).getAbsolutePath() + ";");
        }
        HashMap<String, String> modes = new HashMap<String, String>();
        modes.put(CDCPlatform.PROP_EXEC_XLET, "jp.co.ricoh.dsdk.xlet.Xlet");
        CDCDevice.CDCProfile profile = new CDCDevice.CDCProfile("Foundation Profile", "Foundation Profile with Ricoh extensions", "1.0", modes, bcp.toString(), null, true);
        CDCDevice device = new CDCDevice();
        device.setProfiles(new CDCDevice.CDCProfile[]{profile});
        return new CDCDevice[]{device};
    }

    public int getVersion() {
        return 1;
    }
}

