/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.subpanels;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.openide.util.NbBundle;

public class AdvancedSecurityPanel
extends JPanel {
    private Binding binding;
    private boolean inSync = false;
    private DefaultFormatterFactory freshnessff = null;
    private DefaultFormatterFactory skewff = null;
    private ConfigVersion cfgVersion = null;
    private JFormattedTextField freshnessField;
    private JLabel freshnessLabel;
    private JFormattedTextField maxClockSkewField;
    private JLabel maxClockSkewLabel;
    private JCheckBox revocationChBox;

    public AdvancedSecurityPanel(Binding binding, ConfigVersion cfgVersion) {
        this.binding = binding;
        this.cfgVersion = cfgVersion;
        this.freshnessff = new DefaultFormatterFactory();
        NumberFormat freshnessFormat = NumberFormat.getIntegerInstance();
        freshnessFormat.setGroupingUsed(false);
        NumberFormatter freshnessFormatter = new NumberFormatter(freshnessFormat);
        freshnessFormat.setMaximumIntegerDigits(8);
        freshnessFormatter.setCommitsOnValidEdit(true);
        freshnessFormatter.setMinimum(Integer.valueOf(0));
        freshnessFormatter.setMaximum(Integer.valueOf(99999999));
        this.freshnessff.setDefaultFormatter(freshnessFormatter);
        this.skewff = new DefaultFormatterFactory();
        NumberFormat skewFormat = NumberFormat.getIntegerInstance();
        skewFormat.setGroupingUsed(false);
        NumberFormatter skewFormatter = new NumberFormatter(skewFormat);
        skewFormat.setMaximumIntegerDigits(8);
        skewFormatter.setCommitsOnValidEdit(true);
        skewFormatter.setMinimum(Integer.valueOf(0));
        skewFormatter.setMaximum(Integer.valueOf(99999999));
        this.skewff.setDefaultFormatter(skewFormatter);
        this.initComponents();
        this.sync();
    }

    private void sync() {
        this.inSync = true;
        String maxClockSkew = ProprietarySecurityPolicyModelHelper.getMaxClockSkew(this.binding);
        if (maxClockSkew == null) {
            this.setMaxClockSkew("300000");
        } else {
            this.setMaxClockSkew(maxClockSkew);
        }
        String freshnessLimit = ProprietarySecurityPolicyModelHelper.getTimestampFreshness(this.binding);
        if (freshnessLimit == null) {
            this.setFreshness("300000");
        } else {
            this.setFreshness(freshnessLimit);
        }
        this.setRevocation(ProprietarySecurityPolicyModelHelper.isRevocationEnabled(this.binding));
        this.enableDisable();
        this.inSync = false;
    }

    private Number getMaxClockSkew() {
        return (Number)this.maxClockSkewField.getValue();
    }

    private void setMaxClockSkew(String value) {
        this.maxClockSkewField.setText(value);
    }

    private Number getFreshness() {
        return (Number)this.freshnessField.getValue();
    }

    private void setFreshness(String value) {
        this.freshnessField.setText(value);
    }

    private void setRevocation(Boolean enable) {
        if (enable == null) {
            this.revocationChBox.setSelected(false);
        } else {
            this.revocationChBox.setSelected(enable);
        }
    }

    public Boolean getRevocation() {
        if (this.revocationChBox.isSelected()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void storeState() {
        ProprietarySecurityPolicyModelHelper.setRevocation(this.binding, this.revocationChBox.isSelected(), false);
        Number freshness = this.getFreshness();
        if (freshness == null || "300000".equals(freshness.toString())) {
            ProprietarySecurityPolicyModelHelper.setTimestampFreshness(this.binding, null, false);
        } else {
            ProprietarySecurityPolicyModelHelper.setTimestampFreshness(this.binding, freshness.toString(), false);
        }
        Number skew = this.getMaxClockSkew();
        if (skew == null || "300000".equals(skew.toString())) {
            ProprietarySecurityPolicyModelHelper.setMaxClockSkew(this.binding, null, false);
        } else {
            ProprietarySecurityPolicyModelHelper.setMaxClockSkew(this.binding, skew.toString(), false);
        }
    }

    private void enableDisable() {
    }

    private void initComponents() {
        this.maxClockSkewLabel = new JLabel();
        this.freshnessLabel = new JLabel();
        this.freshnessField = new JFormattedTextField();
        this.maxClockSkewField = new JFormattedTextField();
        this.revocationChBox = new JCheckBox();
        this.maxClockSkewLabel.setText(NbBundle.getMessage(AdvancedSecurityPanel.class, (String)"LBL_AdvancedSec_maxClockSkew"));
        this.freshnessLabel.setText(NbBundle.getMessage(AdvancedSecurityPanel.class, (String)"LBL_AdvancedSec_TimestampFreshnessLabel"));
        this.freshnessField.setFormatterFactory(this.freshnessff);
        this.maxClockSkewField.setColumns(8);
        this.maxClockSkewField.setFormatterFactory(this.skewff);
        this.revocationChBox.setText(NbBundle.getMessage(AdvancedSecurityPanel.class, (String)"LBL_AdvancedSec_Revocation"));
        this.revocationChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.revocationChBox.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.freshnessLabel).add((Component)this.maxClockSkewLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.maxClockSkewField, -1, 104, Short.MAX_VALUE).add((Component)this.freshnessField, -1, 104, Short.MAX_VALUE))).add((Component)this.revocationChBox)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.maxClockSkewLabel).add((Component)this.maxClockSkewField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.freshnessLabel).add((Component)this.freshnessField, -2, -1, -2)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.revocationChBox).addContainerGap()));
    }
}

