/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.io;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.providers.IOSupport;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public final class ProjectUtils {
    private ProjectUtils() {
    }

    public static String getProjectID(Project project) {
        return FileUtil.toFile((FileObject)project.getProjectDirectory()).toURI().toString();
    }

    public static Project getProject(String projectID) {
        try {
            return FileOwnerQuery.getOwner((URI)new URI(projectID));
        }
        catch (URISyntaxException e) {
            throw Debug.error((Object[])new Object[]{e});
        }
    }

    public static Project getProject(DataObjectContext context) {
        if (context == null) {
            return null;
        }
        return FileOwnerQuery.getOwner((FileObject)context.getDataObject().getPrimaryFile());
    }

    public static Project getProject(DesignDocument document) {
        return ProjectUtils.getProject(ProjectUtils.getDataObjectContextForDocument(document));
    }

    public static DataObjectContext getDataObjectContextForDocument(DesignDocument document) {
        return IOSupport.getDataObjectContextForDocumentInterface(document);
    }

    public static List<SourceGroup> getSourceGroups(DataObjectContext context) {
        assert (context != null);
        Project project = ProjectUtils.getProject(context);
        if (project == null) {
            return Collections.emptyList();
        }
        Sources sources = org.netbeans.api.project.ProjectUtils.getSources((Project)project);
        SourceGroup[] sg = sources.getSourceGroups("java");
        return Arrays.asList(sg);
    }

    public static List<SourceGroup> getSourceGroups(String projectID) {
        assert (projectID != null);
        Project project = ProjectUtils.getProject(projectID);
        if (project == null) {
            return null;
        }
        Sources sources = org.netbeans.api.project.ProjectUtils.getSources((Project)project);
        SourceGroup[] sg = sources.getSourceGroups("java");
        return Arrays.asList(sg);
    }

    public static void requestVisibility(DataObjectContext context, String topComponentDisplayName) {
        HashSet topComponents = new HashSet(TopComponent.getRegistry().getOpened());
        block0: for (TopComponent tc : topComponents) {
            DataEditorView dev = (DataEditorView)tc.getLookup().lookup(DataEditorView.class);
            if (dev == null || dev.getContext() != context) continue;
            MultiViewHandler handler = MultiViews.findMultiViewHandler((TopComponent)tc);
            for (MultiViewPerspective perspective : handler.getPerspectives()) {
                if (!perspective.getDisplayName().equals(topComponentDisplayName)) continue;
                handler.requestVisible(perspective);
                continue block0;
            }
        }
    }

    public static String getSourceEditorViewDisplayName() {
        return NbBundle.getMessage(ProjectUtils.class, (String)"LBL_SourceEditorView");
    }
}

