/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.maven;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiLicense;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiProjectMember;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Contributor;
import org.netbeans.modules.maven.model.pom.Developer;
import org.netbeans.modules.maven.model.pom.IssueManagement;
import org.netbeans.modules.maven.model.pom.License;
import org.netbeans.modules.maven.model.pom.MailingList;
import org.netbeans.modules.maven.model.pom.POMComponentFactory;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMModelFactory;
import org.netbeans.modules.maven.model.pom.Project;
import org.netbeans.modules.maven.model.pom.Scm;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public final class KenaiUpdateAction
extends AbstractAction
implements ContextAwareAction,
TaskListener {
    private Lookup context;
    private String uri;
    private RequestProcessor.Task updateTask;
    private static final String POM_SCM = "scm";
    private static final String POM_DELIM = ":";
    private static final String POM_HG = "hg";
    private static final String POM_SVN = "svn";
    private static final String POM_EXTERNAL = "???";
    private static final String KENAI_SITE = ".kenai.com";
    private static final String KENAI_SYMPA = "sympa@";
    private static final String KENAI_SUBSCRIBE = "?subject=sub%20";
    private static final String KENAI_UNSUBSCRIBE = "?subject=unsub%20";

    public KenaiUpdateAction() {
        this.putValue("Name", NbBundle.getMessage(KenaiUpdateAction.class, (String)"CTL_KenaiUpdateAction"));
        this.putValue("ShortDescription", NbBundle.getMessage(KenaiUpdateAction.class, (String)"TIP_KenaiUpdateAction"));
    }

    public KenaiUpdateAction(Lookup context) {
        this();
        this.context = context;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    @Override
    public boolean isEnabled() {
        FileObject fo = (FileObject)this.context.lookup(FileObject.class);
        if (fo == null) {
            return false;
        }
        Object attr = fo.getAttribute("ProvidedExtensions.RemoteLocation");
        if (attr == null || !(attr instanceof String)) {
            return false;
        }
        this.uri = (String)attr;
        return KenaiUpdateAction.isKenai(this.uri);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.updateTask != null) {
            return;
        }
        this.updateTask = RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                KenaiUpdateAction.this.doPerformAction();
            }
        });
        this.updateTask.addTaskListener((TaskListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPerformAction() {
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(KenaiUpdateAction.class, (String)"LBL_UpdateProgress"));
        try {
            String msgFail;
            handle.start(4);
            FileObject fo = (FileObject)this.context.lookup(FileObject.class);
            ModelSource ms = Utilities.createModelSource((FileObject)fo);
            POMModel model = null;
            if (ms.isEditable()) {
                model = POMModelFactory.getDefault().getModel(ms);
            } else {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(KenaiUpdateAction.class, (String)"MSG_NotEditable"));
            }
            handle.progress(1);
            KenaiProject project = null;
            try {
                project = KenaiProject.forRepository((String)this.uri);
            }
            catch (KenaiException ex) {
                String msgNoProject = NbBundle.getMessage(KenaiUpdateAction.class, (String)"MSG_NoProject");
                StatusDisplayer.getDefault().setStatusText(msgNoProject);
                Logger.getLogger(KenaiUpdateAction.class.getName()).log(Level.WARNING, msgNoProject, ex);
            }
            handle.progress(2);
            if (model != null && project != null) {
                try {
                    KenaiUpdateAction.performUpdate(model, project);
                }
                catch (KenaiException ex) {
                    msgFail = NbBundle.getMessage(KenaiUpdateAction.class, (String)"MSG_UpdateFail");
                    StatusDisplayer.getDefault().setStatusText(msgFail);
                    Logger.getLogger(KenaiUpdateAction.class.getName()).log(Level.WARNING, msgFail, ex);
                }
            }
            handle.progress(3);
            try {
                Utilities.saveChanges((AbstractDocumentModel)model);
            }
            catch (IOException ex) {
                msgFail = NbBundle.getMessage(KenaiUpdateAction.class, (String)"MSG_SaveFail");
                StatusDisplayer.getDefault().setStatusText(msgFail);
                Logger.getLogger(KenaiUpdateAction.class.getName()).log(Level.WARNING, msgFail, ex);
            }
        }
        finally {
            handle.finish();
        }
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new KenaiUpdateAction(actionContext);
    }

    private static boolean isKenai(String uri) {
        return KenaiProject.getNameForRepository((String)uri) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void performUpdate(POMModel model, KenaiProject kProj) throws KenaiException {
        try {
            model.startTransaction();
            Project mProj = model.getProject();
            POMComponentFactory factory = model.getFactory();
            mProj.setName(kProj.getDisplayName());
            mProj.setDescription(kProj.getDescription());
            mProj.setURL(kProj.getWebLocation().toExternalForm());
            KenaiLicense[] kLicenses = kProj.getLicenses();
            for (int i = 0; i < kLicenses.length; ++i) {
                KenaiUpdateAction.updateLicense(mProj, kLicenses[i], factory);
            }
            KenaiProjectMember[] kMembers = kProj.getMembers();
            for (int i = 0; i < kMembers.length; ++i) {
                KenaiUpdateAction.updateMember(mProj, kMembers[i], factory);
            }
            KenaiFeature[] kfs = kProj.getFeatures();
            block10: for (int i = 0; i < kfs.length; ++i) {
                KenaiFeature kf = kfs[i];
                switch (kf.getType()) {
                    case SOURCE: {
                        Scm scm = mProj.getScm();
                        if (scm == null) {
                            scm = factory.createScm();
                            mProj.setScm(scm);
                        }
                        KenaiUpdateAction.updateScm(scm, kf);
                        continue block10;
                    }
                    case ISSUES: {
                        IssueManagement iMng = mProj.getIssueManagement();
                        if (iMng == null) {
                            iMng = factory.createIssueManagement();
                            mProj.setIssueManagement(iMng);
                        }
                        KenaiUpdateAction.updateIssueMng(iMng, kf);
                        continue block10;
                    }
                    case LISTS: {
                        KenaiUpdateAction.updateLists(mProj, kf, factory, kProj);
                    }
                }
            }
        }
        finally {
            model.endTransaction();
        }
    }

    private static void updateScm(Scm scm, KenaiFeature kf) {
        StringBuilder conn = new StringBuilder();
        conn.append(POM_SCM);
        conn.append(POM_DELIM);
        String scmName = kf.getName();
        if ("subversion".equals(scmName)) {
            conn.append(POM_SVN);
        } else if ("mercurial".equals(scmName)) {
            conn.append(POM_HG);
        } else if ("external_repository".equals(scmName)) {
            conn.append(POM_EXTERNAL);
        }
        conn.append(POM_DELIM);
        conn.append(kf.getLocation());
        String strConn = conn.toString();
        scm.setConnection(strConn);
        scm.setDeveloperConnection(strConn);
        scm.setUrl(kf.getWebLocation().toExternalForm());
    }

    private static void updateIssueMng(IssueManagement iMng, KenaiFeature kf) {
        iMng.setSystem(kf.getService());
        iMng.setUrl(kf.getLocation());
    }

    private static void updateLists(Project mProj, KenaiFeature kf, POMComponentFactory factory, KenaiProject kProj) {
        List mLists = mProj.getMailingLists();
        MailingList mList = null;
        if (mLists != null) {
            for (MailingList ml : mLists) {
                if (ml.getName() == null || !ml.getName().equals(kf.getName())) continue;
                mList = ml;
                break;
            }
        }
        if (mList == null) {
            mList = factory.createMailingList();
            mProj.addMailingList(mList);
        }
        mList.setName(kf.getName());
        mList.setArchive(kf.getWebLocation().toExternalForm());
        StringBuilder sb = new StringBuilder();
        sb.append(kf.getName());
        sb.append('@');
        sb.append(kProj.getName());
        sb.append(KENAI_SITE);
        mList.setPost(sb.toString());
        sb.delete(0, sb.length());
        sb.append(KENAI_SYMPA);
        sb.append(kProj.getName());
        sb.append(KENAI_SITE);
        StringBuilder sb2 = new StringBuilder();
        sb2.append((CharSequence)sb);
        sb.append(KENAI_SUBSCRIBE);
        sb.append(kf.getName());
        sb2.append(KENAI_UNSUBSCRIBE);
        sb2.append(kf.getName());
        mList.setSubscribe(sb.toString());
        mList.setUnsubscribe(sb2.toString());
    }

    private static void updateLicense(Project mProj, KenaiLicense kLicense, POMComponentFactory factory) {
        List mLicenses = mProj.getLicenses();
        License mLicense = null;
        if (mLicenses != null) {
            for (License l : mLicenses) {
                if (l.getName() == null || !l.getName().equals(kLicense.getName())) continue;
                mLicense = l;
                break;
            }
        }
        if (mLicense == null) {
            mLicense = factory.createLicense();
            mProj.addLicense(mLicense);
        }
        mLicense.setName(kLicense.getName());
        mLicense.setUrl(kLicense.getUri().toString());
        mLicense.setComments(kLicense.getDisplayName());
    }

    private static void updateMember(Project mProj, KenaiProjectMember kUser, POMComponentFactory factory) {
        String kName = kUser.getKenaiUser().getFirstName() + " " + kUser.getKenaiUser().getLastName();
        if (KenaiProjectMember.Role.OBSERVER.equals((Object)kUser.getRole())) {
            List contrs = mProj.getContributors();
            Contributor contributor = null;
            if (contrs != null) {
                for (Contributor con : contrs) {
                    if (!kName.equalsIgnoreCase(con.getName())) continue;
                    contributor = con;
                    break;
                }
            }
            if (contributor == null) {
                contributor = factory.createContributor();
                mProj.addContributor(contributor);
            }
            contributor.setName(kName);
            String role = kUser.getRole().name().toLowerCase();
            List roles = contributor.getRoles();
            boolean exists = false;
            if (roles != null) {
                for (String mRole : roles) {
                    if (!mRole.equals(role)) continue;
                    exists = true;
                }
            }
            if (!exists) {
                contributor.addRole(role);
            }
        } else {
            List devels = mProj.getDevelopers();
            Developer developer = null;
            if (devels != null) {
                for (Developer dev : devels) {
                    if (!dev.getId().equalsIgnoreCase(kUser.getUserName())) continue;
                    developer = dev;
                    break;
                }
            }
            if (developer == null) {
                developer = factory.createDeveloper();
                mProj.addDeveloper(developer);
            }
            developer.setId(kUser.getUserName());
            developer.setName(kName);
            String role = kUser.getRole().name().toLowerCase();
            List roles = developer.getRoles();
            boolean exists = false;
            if (roles != null) {
                for (String mRole : roles) {
                    if (!mRole.equals(role)) continue;
                    exists = true;
                }
            }
            if (!exists) {
                developer.addRole(role);
            }
        }
    }

    public void taskFinished(Task task) {
        this.updateTask = null;
    }
}

