/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran;

import java.util.List;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.FortranTokenId;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.BracesMatcherFactory;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;
import org.netbeans.spi.editor.bracesmatching.support.BracesMatcherSupport;

public class FortranBracesMatcher
implements BracesMatcher,
BracesMatcherFactory {
    private static final char[] PAIRS = new char[]{'(', ')'};
    private static final FortranTokenId[] PAIR_TOKEN_IDS = new FortranTokenId[]{FortranTokenId.LPAREN, FortranTokenId.RPAREN};
    private final MatcherContext context;
    private int originOffset;
    private char originChar;
    private char matchingChar;
    private boolean backward;
    private List<TokenSequence<?>> sequences;

    public FortranBracesMatcher() {
        this(null);
    }

    private FortranBracesMatcher(MatcherContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findOrigin() throws BadLocationException, InterruptedException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            int[] origin = BracesMatcherSupport.findChar((Document)this.context.getDocument(), (int)this.context.getSearchOffset(), (int)this.context.getLimitOffset(), (char[])PAIRS);
            if (origin != null) {
                TokenSequence<?> seq;
                this.originOffset = origin[0];
                this.originChar = PAIRS[origin[1]];
                this.matchingChar = PAIRS[origin[1] + origin[2]];
                this.backward = origin[2] < 0;
                TokenHierarchy th = TokenHierarchy.get((Document)this.context.getDocument());
                this.sequences = th.embeddedTokenSequences(this.originOffset, this.backward);
                if (!this.sequences.isEmpty() && (seq = this.getTokenSequence()) == null) {
                    int[] nArray = null;
                    return nArray;
                }
                int[] nArray = new int[]{this.originOffset, this.originOffset + 1};
                return nArray;
            }
            int[] nArray = null;
            return nArray;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TokenSequence<?> getTokenSequence() {
        if (this.sequences.isEmpty()) {
            return null;
        }
        TokenSequence<?> seq = this.sequences.get(this.sequences.size() - 1);
        seq.move(this.originOffset);
        if (!seq.moveNext()) {
            if (this.sequences.size() <= 1) return null;
            seq = this.sequences.get(this.sequences.size() - 2);
            seq.move(this.originOffset);
            if (!seq.moveNext() || seq.token().id() != FortranTokenId.LINE_COMMENT_FIXED && seq.token().id() != FortranTokenId.LINE_COMMENT_FREE) return seq;
            return null;
        }
        if (seq.token().id() != FortranTokenId.LINE_COMMENT_FIXED && seq.token().id() != FortranTokenId.LINE_COMMENT_FREE) return seq;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findMatches() throws InterruptedException, BadLocationException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            TokenSequence<?> seq = this.getTokenSequence();
            if (seq == null) {
                int[] nArray = null;
                return nArray;
            }
            seq.move(this.originOffset);
            if (seq.moveNext() && seq.token().id() == FortranTokenId.STRING_LITERAL) {
                int offset = BracesMatcherSupport.matchChar((Document)this.context.getDocument(), (int)(this.backward ? this.originOffset : this.originOffset + 1), (int)(this.backward ? seq.offset() : seq.offset() + seq.token().length()), (char)this.originChar, (char)this.matchingChar);
                if (offset != -1) {
                    int[] nArray = new int[]{offset, offset + 1};
                    return nArray;
                }
                int[] nArray = null;
                return nArray;
            }
            FortranTokenId originId = this.getTokenId(this.originChar);
            FortranTokenId lookingForId = this.getTokenId(this.matchingChar);
            seq.move(this.originOffset);
            int counter = 0;
            if (this.backward) {
                while (seq.movePrevious()) {
                    if (originId == seq.token().id()) {
                        ++counter;
                        continue;
                    }
                    if (lookingForId != seq.token().id()) continue;
                    if (counter == 0) {
                        int[] nArray = new int[]{seq.offset(), seq.offset() + seq.token().length()};
                        return nArray;
                    }
                    --counter;
                }
            } else {
                seq.moveNext();
                while (seq.moveNext()) {
                    if (originId == seq.token().id()) {
                        ++counter;
                        continue;
                    }
                    if (lookingForId != seq.token().id()) continue;
                    if (counter == 0) {
                        int[] nArray = new int[]{seq.offset(), seq.offset() + seq.token().length()};
                        return nArray;
                    }
                    --counter;
                }
            }
            int[] nArray = null;
            return nArray;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    private FortranTokenId getTokenId(char ch) {
        for (int i = 0; i < PAIRS.length; ++i) {
            if (PAIRS[i] != ch) continue;
            return PAIR_TOKEN_IDS[i];
        }
        return null;
    }

    public BracesMatcher createMatcher(MatcherContext context) {
        return new FortranBracesMatcher(context);
    }
}

