/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran.indent;

import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.FortranTokenId;

public final class TokenItem {
    private final int index;
    private final FortranTokenId tokenId;
    protected final TokenSequence<FortranTokenId> tokenSeq;
    private final String text;

    public TokenItem(TokenSequence<FortranTokenId> ts) {
        this.index = ts.index();
        this.tokenId = (FortranTokenId)ts.token().id();
        this.tokenSeq = ts;
        this.text = ((Object)ts.token().text()).toString();
    }

    public TokenSequence<FortranTokenId> getTokenSequence() {
        return this.tokenSeq;
    }

    private void go() {
        this.tokenSeq.moveIndex(this.index);
        this.tokenSeq.moveNext();
    }

    public FortranTokenId getTokenID() {
        return this.tokenId;
    }

    public int index() {
        return this.index;
    }

    public String getImage() {
        return this.text;
    }

    public TokenItem getNext() {
        this.go();
        while (this.tokenSeq.moveNext()) {
            if (this.tokenSeq.token().id() == FortranTokenId.PREPROCESSOR_DIRECTIVE) continue;
            return new TokenItem(this.tokenSeq);
        }
        return null;
    }

    public TokenItem getPrevious() {
        this.go();
        while (this.tokenSeq.movePrevious()) {
            if (this.tokenSeq.token().id() == FortranTokenId.PREPROCESSOR_DIRECTIVE) continue;
            return new TokenItem(this.tokenSeq);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TokenItem) {
            return ((TokenItem)obj).index == this.index;
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 43 * hash + this.index;
        hash = 43 * hash + (this.tokenId != null ? this.tokenId.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.tokenId + "(" + this.index + ")";
    }
}

