/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.IArgumentNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.PreviewableFix;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ConvertBlockType
extends RubyAstRule {
    public boolean appliesTo(RuleContext context) {
        ParserResult info = context.parserResult;
        return RubyUtils.getFileObject((Parser.Result)info).getMIMEType().equals("text/x-ruby");
    }

    @Override
    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.ITERNODE);
    }

    @Override
    public void run(RubyRuleContext context, List<Hint> result) {
        Node node = context.node;
        ParserResult info = context.parserResult;
        int caretOffset = context.caretOffset;
        BaseDocument doc = context.doc;
        assert (node.getNodeType() == NodeType.ITERNODE);
        try {
            Token token;
            int caretRowEnd;
            int astOffset = node.getPosition().getStartOffset();
            int lexOffset = LexUtilities.getLexerOffset((Parser.Result)info, (int)astOffset);
            if (lexOffset == -1 || lexOffset > doc.getLength() - 1) {
                return;
            }
            boolean caretOnStart = true;
            int beginRowEnd = Utilities.getRowEnd((BaseDocument)doc, (int)lexOffset);
            boolean caretLine = beginRowEnd == (caretRowEnd = Utilities.getRowEnd((BaseDocument)doc, (int)caretOffset));
            int endLexOffset = -1;
            if (!caretLine) {
                int endAstOffset = node.getPosition().getEndOffset();
                endLexOffset = LexUtilities.getLexerOffset((Parser.Result)info, (int)endAstOffset);
                if (endLexOffset == -1) {
                    return;
                }
                int endRowEnd = endLexOffset;
                if (endRowEnd < doc.getLength()) {
                    endRowEnd = Utilities.getRowEnd((BaseDocument)doc, (int)endLexOffset);
                }
                boolean bl = caretLine = endRowEnd == caretRowEnd;
                if (!caretLine) {
                    return;
                }
                if (endRowEnd != beginRowEnd) {
                    caretOnStart = false;
                }
            }
            if ((token = LexUtilities.getToken((BaseDocument)doc, (int)lexOffset)) == null) {
                return;
            }
            TokenId id = token.id();
            if (id == RubyTokenId.LBRACE || id == RubyTokenId.DO) {
                boolean sameLine;
                OffsetRange range;
                if (caretOnStart) {
                    range = new OffsetRange(lexOffset, lexOffset + token.length());
                } else {
                    assert (endLexOffset != -1);
                    int len = id == RubyTokenId.LBRACE ? 1 : 3;
                    range = new OffsetRange(endLexOffset - len, endLexOffset);
                }
                ArrayList<ConvertTypeFix> fixList = new ArrayList<ConvertTypeFix>(1);
                boolean convertFromBrace = id == RubyTokenId.LBRACE;
                int endOffset = node.getPosition().getEndOffset();
                if (endOffset > doc.getLength()) {
                    endOffset = doc.getLength();
                }
                String text = doc.getText(lexOffset, endOffset - lexOffset);
                int nonspaceChars = 0;
                for (int i = 0; i < text.length(); ++i) {
                    char c = text.charAt(i);
                    if (Character.isWhitespace(c)) continue;
                    ++nonspaceChars;
                }
                int rightMargin = 350;
                int startColumn = lexOffset - Utilities.getRowStart((BaseDocument)doc, (int)lexOffset);
                boolean offerCollapse = rightMargin > startColumn + nonspaceChars;
                boolean bl = sameLine = Utilities.getRowEnd((BaseDocument)doc, (int)lexOffset) == Utilities.getRowEnd((BaseDocument)doc, (int)endOffset);
                if (sameLine && convertFromBrace) {
                    fixList.add(new ConvertTypeFix(context, node, convertFromBrace, !convertFromBrace, true, false));
                } else if (!sameLine && !convertFromBrace && offerCollapse) {
                    fixList.add(new ConvertTypeFix(context, node, convertFromBrace, !convertFromBrace, false, true));
                }
                fixList.add(new ConvertTypeFix(context, node, convertFromBrace, !convertFromBrace, false, false));
                if (sameLine || !sameLine && offerCollapse) {
                    fixList.add(new ConvertTypeFix(context, node, false, false, sameLine, !sameLine));
                }
                Hint desc = new Hint((Rule)this, this.getDisplayName(), RubyUtils.getFileObject((Parser.Result)info), range, fixList, 500);
                result.add(desc);
            }
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public String getId() {
        return "Convert_Blocktype";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ConvertBlockType.class, (String)"ConvertBlockType");
    }

    public String getDescription() {
        return NbBundle.getMessage(ConvertBlockType.class, (String)"ConvertBlockTypeDesc");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.CURRENT_LINE_WARNING;
    }

    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    public boolean showInTasklist() {
        return false;
    }

    private static class ConvertTypeFix
    implements PreviewableFix {
        private final RubyRuleContext context;
        private final boolean convertToDo;
        private final boolean convertToBrace;
        private final Node node;
        private final boolean expand;
        private final boolean collapse;

        ConvertTypeFix(RubyRuleContext context, Node node, boolean convertToDo, boolean convertToBrace, boolean expand, boolean collapse) {
            this.context = context;
            this.node = node;
            this.convertToDo = convertToDo;
            this.convertToBrace = convertToBrace;
            this.expand = expand;
            this.collapse = collapse;
        }

        public String getDescription() {
            String key;
            if (this.convertToDo) {
                key = this.expand ? "ConvertBraceToDoMulti" : (this.collapse ? "ConvertBraceToDoSingle" : "ConvertBraceToDo");
            } else if (this.convertToBrace) {
                key = this.expand ? "ConvertDoToBraceMulti" : (this.collapse ? "ConvertDoToBraceSingle" : "ConvertDoToBrace");
            } else if (this.expand) {
                key = "ChangeBlockToMulti";
            } else {
                assert (this.collapse);
                key = "ChangeBlockToSingle";
            }
            return NbBundle.getMessage(ConvertBlockType.class, (String)key);
        }

        public boolean canPreview() {
            return true;
        }

        public void implement() throws Exception {
            this.getEditList().apply();
        }

        public EditList getEditList() throws Exception {
            BaseDocument doc = this.context.doc;
            EditList edits = new EditList(doc);
            SourcePosition pos = this.node.getPosition();
            int startOffset = pos.getStartOffset();
            int originalEnd = pos.getEndOffset();
            int endOffset = this.convertToDo ? originalEnd - 1 : (this.convertToBrace ? originalEnd - 3 : originalEnd);
            if (startOffset > doc.getLength() - 1 || endOffset > doc.getLength()) {
                return edits;
            }
            if (this.convertToDo) {
                if (doc.getText(startOffset, 1).charAt(0) == '{' && doc.getText(endOffset, 1).charAt(0) == '}') {
                    String end = endOffset > 0 && !Character.isWhitespace(doc.getText(endOffset - 1, 1).charAt(0)) ? " end" : "end";
                    edits.replace(endOffset, 1, end, false, 0);
                    boolean spaceBefore = true;
                    boolean spaceAfter = true;
                    if (startOffset > 0) {
                        String s = doc.getText(startOffset - 1, 3);
                        spaceBefore = Character.isWhitespace(s.charAt(0));
                        spaceAfter = Character.isWhitespace(s.charAt(2));
                    }
                    String insert = "do";
                    if (!spaceAfter) {
                        insert = insert + " ";
                    }
                    if (!spaceBefore) {
                        insert = " " + insert;
                    }
                    edits.replace(startOffset, 1, insert, false, 1);
                    if (this.expand) {
                        this.expand(edits, doc, this.node, startOffset, originalEnd);
                    } else if (this.collapse) {
                        this.collapse(edits, doc, this.node, startOffset, originalEnd);
                    }
                }
            } else if (this.convertToBrace) {
                if (doc.getText(startOffset, 2).equals("do") && endOffset <= doc.getLength() - 3 && doc.getText(endOffset, 3).equals("end")) {
                    AstPath path = new AstPath(AstUtilities.getRoot((Parser.Result)this.context.parserResult), this.node);
                    assert (path.leaf() == this.node);
                    boolean parenIsNecessary = this.isArgParenNecessary(path, doc);
                    edits.replace(endOffset, 3, "}", false, 0);
                    edits.replace(startOffset, 2, "{", false, 0);
                    if (parenIsNecessary) {
                        assert (AstUtilities.isCall((Node)path.leafParent()));
                        OffsetRange range = AstUtilities.getCallRange((Node)path.leafParent());
                        int insertPos = range.getEnd();
                        if (Character.isWhitespace(doc.getText(insertPos, 1).charAt(0))) {
                            edits.replace(insertPos, 1, "(", false, 1);
                        } else {
                            edits.replace(insertPos, 0, "(", false, 1);
                        }
                        edits.replace(startOffset - 1, 0, ")", false, 2);
                        if (!Character.isWhitespace(doc.getText(startOffset - 1, 1).charAt(0))) {
                            edits.replace(startOffset - 1, 0, " ", false, 3);
                        }
                    }
                    if (this.expand) {
                        this.expand(edits, doc, this.node, startOffset, originalEnd);
                    } else if (this.collapse) {
                        this.collapse(edits, doc, this.node, startOffset, originalEnd);
                    }
                }
            } else {
                assert (this.collapse || this.expand);
                if (this.expand) {
                    this.expand(edits, doc, this.node, startOffset, endOffset);
                } else {
                    this.collapse(edits, doc, this.node, startOffset, endOffset);
                }
            }
            return edits;
        }

        private int findRealStart(Node node) {
            int min = Integer.MAX_VALUE;
            while (true) {
                List list;
                int start;
                if ((start = node.getPosition().getStartOffset()) < min) {
                    min = start;
                }
                if ((list = node.childNodes()) == null || list.size() <= 0) break;
                node = (Node)list.get(0);
            }
            return min;
        }

        private void findLineBreaks(Node node, Set<Integer> offsets) {
            if (node.getNodeType() == NodeType.NEWLINENODE) {
                int start = this.findRealStart(node);
                offsets.add(start);
            }
            List list = node.childNodes();
            for (Node child : list) {
                if (child.isInvisible() || child.getNodeType() == NodeType.EVSTRNODE) continue;
                this.findLineBreaks(child, offsets);
            }
        }

        private void expand(EditList edits, BaseDocument doc, Node node, int startOffset, int endOffset) {
            assert (endOffset <= doc.getLength());
            HashSet<Integer> offsetSet = new HashSet<Integer>();
            this.findLineBreaks(node, offsetSet);
            TokenSequence ts = LexUtilities.getRubyTokenSequence((BaseDocument)doc, (int)endOffset);
            if (ts != null) {
                ts.move(endOffset);
                while (ts.movePrevious() && ts.offset() > startOffset) {
                    Token token = ts.token();
                    TokenId id = token.id();
                    if (id == RubyTokenId.IDENTIFIER && ";".equals(((Object)token.text()).toString()) || id != RubyTokenId.END && id != RubyTokenId.RBRACE) continue;
                    offsetSet.add(ts.offset());
                }
            }
            ArrayList<Integer> offsets = new ArrayList<Integer>(offsetSet);
            Collections.sort(offsets);
            Collections.reverse(offsets);
            if (offsets.size() > 0) {
                try {
                    int offset;
                    int prev = -1;
                    int added = 0;
                    Iterator i$ = offsets.iterator();
                    while (i$.hasNext()) {
                        char c;
                        offset = (Integer)i$.next();
                        if (offset == prev) continue;
                        prev = offset;
                        int whitespaces = 0;
                        for (int i = 1; i < 5 && offset - i > 0 && Character.isWhitespace(c = doc.getText(offset - i, 1).charAt(0)); ++i) {
                            ++whitespaces;
                        }
                        if (whitespaces > 0) {
                            edits.replace(offset - whitespaces, whitespaces, "\n", false, 4);
                        } else {
                            edits.replace(offset, 0, "\n", false, 4);
                        }
                        ++added;
                    }
                    i$ = offsets.iterator();
                    while (i$.hasNext()) {
                        offset = (Integer)i$.next();
                        char c = doc.getText(offset - 1, 1).charAt(0);
                        if (c == ';') {
                            edits.replace(offset - 1, 1, null, false, 5);
                            continue;
                        }
                        if (!Character.isWhitespace(c) || (c = doc.getText(offset - 2, 1).charAt(0)) != ';') continue;
                        edits.replace(offset - 2, 1, null, false, 5);
                    }
                    int newEnd = endOffset + added;
                }
                catch (BadLocationException ble) {
                    Exceptions.printStackTrace((Throwable)ble);
                }
            }
            edits.setFormatAll(true);
        }

        private void collapse(EditList edits, BaseDocument doc, Node node, int startOffset, int endOffset) {
            assert (endOffset <= doc.getLength());
            HashSet<Integer> offsetSet = new HashSet<Integer>();
            this.findLineBreaks(node, offsetSet);
            Token t = LexUtilities.getToken((BaseDocument)doc, (int)startOffset);
            TokenId tid = t.id();
            assert (tid == RubyTokenId.LBRACE || tid == RubyTokenId.DO);
            boolean isDoBlock = tid == RubyTokenId.DO;
            TokenSequence ts = LexUtilities.getRubyTokenSequence((BaseDocument)doc, (int)endOffset);
            if (ts != null) {
                ts.move(endOffset);
                while (ts.movePrevious() && ts.offset() > startOffset) {
                    Token token = ts.token();
                    TokenId id = token.id();
                    if (id != RubyTokenId.END && id != RubyTokenId.RBRACE) continue;
                    offsetSet.add(ts.offset());
                }
            }
            ArrayList<Integer> offsets = new ArrayList<Integer>(offsetSet);
            Collections.sort(offsets);
            if (offsets.size() > 0) {
                try {
                    int prev = -1;
                    for (int i = offsets.size() - 1; i >= 0; --i) {
                        char c;
                        char c2;
                        int segmentOffset;
                        int offset = (Integer)offsets.get(i);
                        if (offset == prev) continue;
                        prev = offset;
                        int prevOffset = i > 0 ? (Integer)offsets.get(i - 1) : 0;
                        int s = segmentOffset = offset;
                        while (s > prevOffset && Character.isWhitespace(c2 = doc.getText(--s, 1).charAt(0))) {
                            segmentOffset = s;
                        }
                        int segmentLength = offset - segmentOffset;
                        s = offset - 1;
                        while (s < doc.getLength() && Character.isWhitespace(c = doc.getText(++s, 1).charAt(0))) {
                            ++segmentLength;
                        }
                        int prevChar = 63;
                        if (segmentOffset > 0) {
                            prevChar = doc.getText(segmentOffset - 1, 1).charAt(0);
                        }
                        if (prevChar == 124 || isDoBlock && segmentOffset <= startOffset + 3 || !isDoBlock && segmentOffset <= startOffset + 1) {
                            edits.replace(segmentOffset, segmentLength, " ", false, 4);
                            continue;
                        }
                        boolean skipSemicolon = false;
                        TokenSequence rts = LexUtilities.getRubyTokenSequence((BaseDocument)doc, (int)segmentOffset);
                        rts.move(segmentOffset);
                        while (rts.moveNext()) {
                            Token tk = rts.token();
                            TokenId tkid = tk.id();
                            if (tkid == RubyTokenId.END || tkid == RubyTokenId.RBRACE || tkid == RubyTokenId.LPAREN) {
                                skipSemicolon = true;
                                break;
                            }
                            if (tkid == RubyTokenId.WHITESPACE) continue;
                            break;
                        }
                        if (skipSemicolon) {
                            edits.replace(segmentOffset, segmentLength, " ", false, 4);
                            continue;
                        }
                        edits.replace(segmentOffset, segmentLength, "; ", false, 4);
                    }
                }
                catch (BadLocationException ble) {
                    Exceptions.printStackTrace((Throwable)ble);
                }
            }
            edits.setFormatAll(true);
        }

        private boolean isArgParenNecessary(AstPath path, BaseDocument doc) throws BadLocationException {
            assert (path.leaf().getNodeType() == NodeType.ITERNODE);
            Node n = path.leafParent();
            if (n != null && AstUtilities.isCall((Node)n) && n instanceof IArgumentNode && ((IArgumentNode)n).getArgsNode() != null) {
                int end = this.node.getPosition().getStartOffset();
                for (int i = end - 1; i >= 0 && i < doc.getLength(); --i) {
                    char c = doc.getText(i, 1).charAt(0);
                    if (Character.isWhitespace(c)) continue;
                    return c != ')';
                }
            }
            return false;
        }

        public boolean isSafe() {
            return !this.convertToBrace && !this.convertToDo;
        }

        public boolean isInteractive() {
            return false;
        }
    }
}

