/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.util.NbBundle;

public class Misspellings
extends RubyAstRule {
    private static final Set<Pair> WORD_PAIRS = Misspellings.initWordPairs();

    private static Set<Pair> initWordPairs() {
        HashSet<Pair> result = new HashSet<Pair>();
        result.add(new Pair("initialize", "initialise"));
        result.add(new Pair("initialize_copy", "initialise_copy"));
        result.add(new Pair("marshal_dump", "marshall_dump"));
        result.add(new Pair("marshal_load", "marshall_load"));
        return result;
    }

    public boolean appliesTo(RuleContext context) {
        return true;
    }

    @Override
    public Set<NodeType> getKinds() {
        HashSet<NodeType> types = new HashSet<NodeType>();
        types.add(NodeType.DEFNNODE);
        return types;
    }

    @Override
    public void run(RubyRuleContext context, List<Hint> result) {
        Node node = context.node;
        ParserResult info = context.parserResult;
        String name = ((INameNode)node).getName();
        for (Pair each : WORD_PAIRS) {
            if (!each.incorrect.equals(name)) continue;
            String displayName = NbBundle.getMessage(Misspellings.class, (String)"Misspellings", (Object)("'" + each.correct + "'"), (Object)("'" + each.incorrect + "'"));
            OffsetRange range = AstUtilities.getNameRange((Node)node);
            List fixList = Collections.emptyList();
            if ((range = LexUtilities.getLexerOffsets((Parser.Result)info, (OffsetRange)range)) == OffsetRange.NONE) break;
            Hint desc = new Hint((Rule)this, displayName, RubyUtils.getFileObject((Parser.Result)info), range, fixList, 600);
            result.add(desc);
            break;
        }
    }

    public String getId() {
        return "Misspellings";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(Misspellings.class, (String)"MisspellingsHint");
    }

    public String getDescription() {
        return NbBundle.getMessage(Misspellings.class, (String)"MisspellingsHintDesc");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public boolean showInTasklist() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    private static class Pair {
        private final String correct;
        private final String incorrect;

        public Pair(String correct, String incorrect) {
            this.correct = correct;
            this.incorrect = incorrect;
        }
    }
}

