/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.Deprecations;
import org.netbeans.modules.ruby.hints.RailsDeprecations;
import org.netbeans.modules.ruby.hints.RubyHints;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.util.NbBundle;

public class Rails3Deprecations
extends RubyAstRule {
    private static final Set<Deprecations.Deprecation> DEPRECATED_CONSTANTS = new HashSet<Deprecations.Deprecation>();
    private static final Set<Deprecations.Deprecation> DEPRECATED_CONTROLLER_METHODS = new HashSet<Deprecations.Deprecation>();
    private static final Set<Deprecations.Deprecation> DEPRECATED_AR_METHODS = new HashSet<Deprecations.Deprecation>();
    private RubyRuleContext context;

    public boolean appliesTo(RuleContext context) {
        ParserResult info = context.parserResult;
        return RubyHints.isInRails3Project(RubyUtils.getFileObject((Parser.Result)info));
    }

    @Override
    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.ROOTNODE);
    }

    @Override
    public void run(RubyRuleContext context, List<Hint> result) {
        this.context = context;
        Node root = context.node;
        ParserResult info = context.parserResult;
        AstPath path = context.path;
        if (root == null) {
            return;
        }
        assert (path.leaf() == root);
        this.scan(info, root, result);
    }

    public void cancel() {
    }

    public String getId() {
        return "Rails3_Deprecations";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(RailsDeprecations.class, (String)"Rails3Deprecation");
    }

    public String getDescription() {
        return NbBundle.getMessage(RailsDeprecations.class, (String)"Rails3DeprecationDesc");
    }

    private void scan(ParserResult info, Node node, List<Hint> result) {
        String message;
        if (node.getNodeType() == NodeType.CONSTNODE) {
            String name = AstUtilities.getName((Node)node);
            Deprecations.Deprecation deprecation = this.findMatching(name, DEPRECATED_CONSTANTS);
            if (deprecation != null) {
                message = NbBundle.getMessage(Rails3Deprecations.class, (String)"DeprecatedRailsConstant", (Object)deprecation.oldName, (Object)deprecation.newName);
                this.addHintAndFix(node, result, message, deprecation);
            }
        } else if (AstUtilities.isCall((Node)node)) {
            Deprecations.Deprecation deprecation = null;
            String name = AstUtilities.getName((Node)node);
            if (RailsDeprecations.inActionController(info, node, this)) {
                deprecation = this.findMatching(name, DEPRECATED_CONTROLLER_METHODS);
            } else if (RailsDeprecations.inActiveRecordModel(info, node, this)) {
                deprecation = this.findMatching(name, DEPRECATED_AR_METHODS);
            }
            if (deprecation != null) {
                message = NbBundle.getMessage(Rails3Deprecations.class, (String)"DeprecatedRailsMethodUse", (Object)deprecation.oldName, (Object)deprecation.newName);
                this.addHintAndFix(node, result, message, deprecation);
            }
        }
        List list = node.childNodes();
        for (Node child : list) {
            if (child.isInvisible()) continue;
            this.scan(info, child, result);
        }
    }

    private Deprecations.Deprecation findMatching(String name, Collection<Deprecations.Deprecation> deprecations) {
        for (Deprecations.Deprecation deprecation : deprecations) {
            if (!deprecation.oldName.equals(name)) continue;
            return deprecation;
        }
        return null;
    }

    private void addHintAndFix(Node node, List<Hint> result, String displayName, Deprecations.Deprecation deprecation) {
        OffsetRange range = AstUtilities.getNameRange((Node)node);
        ParserResult info = this.context.parserResult;
        if ((range = LexUtilities.getLexerOffsets((Parser.Result)info, (OffsetRange)range)) != OffsetRange.NONE) {
            List<Object> fixes;
            if (deprecation.enableFix) {
                Deprecations.DeprecationCallFix fix = new Deprecations.DeprecationCallFix(this.context, node, deprecation, false);
                fixes = Collections.singletonList(fix);
            } else {
                fixes = Collections.emptyList();
            }
            Hint desc = new Hint((Rule)this, displayName, RubyUtils.getFileObject((Parser.Result)info), range, fixes, 100);
            result.add(desc);
        }
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public boolean showInTasklist() {
        return true;
    }

    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    static {
        DEPRECATED_CONSTANTS.add(new Deprecations.Deprecation("RAILS_ROOT", "Rails.root", null, null));
        DEPRECATED_CONSTANTS.add(new Deprecations.Deprecation("RAILS_ENV", "Rails.env", null, null));
        DEPRECATED_CONSTANTS.add(new Deprecations.Deprecation("RAILS_DEFAULT_LOGGER", "Rails.logger", null, null));
        DEPRECATED_CONTROLLER_METHODS.add(new Deprecations.Deprecation("filter_parameter_logging", "config.filter_parameters", null, null));
        DEPRECATED_AR_METHODS.add(new Deprecations.Deprecation("named_scope", "scope", null, null));
        DEPRECATED_AR_METHODS.add(new Deprecations.Deprecation("validates_presence_of", "validates...:presence => true", null, null, false));
    }
}

