/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.Arity;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.AstElement;
import org.netbeans.modules.ruby.hints.NestedLocal;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class RailsViews
extends RubyAstRule {
    public boolean appliesTo(RuleContext context) {
        ParserResult info = context.parserResult;
        return RubyUtils.getFileObject((Parser.Result)info).getName().endsWith("_controller");
    }

    @Override
    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.DEFNNODE);
    }

    @Override
    public void run(RubyRuleContext context, List<Hint> result) {
        Node node = context.node;
        ParserResult info = context.parserResult;
        FileObject file = RubyUtils.getFileObject((Parser.Result)info);
        assert (file.getName().endsWith("_controller"));
        Arity arity = Arity.getDefArity((Node)node);
        if (arity.getMinArgs() != 0 || arity.getMaxArgs() != 0) {
            return;
        }
        String name = ((INameNode)node).getName();
        FileObject view = RubyUtils.getRailsViewFor((FileObject)file, (String)name, (String)"_controller", (String)"controllers", (boolean)true);
        if (view == null && this.shouldHaveView(info, node) && this.isPublic(context.parserResult, node)) {
            String displayName = NbBundle.getMessage(RailsViews.class, (String)"MissingView");
            OffsetRange range = AstUtilities.getNameRange((Node)node);
            List<CreateViewFix> fixList = Collections.singletonList(new CreateViewFix(file, name));
            Hint desc = new Hint((Rule)this, displayName, file, range, fixList, 400);
            result.add(desc);
        }
    }

    private boolean isPublic(ParserResult result, Node node) {
        Set modifiers;
        RubyParseResult rpr = (RubyParseResult)result;
        AstElement element = rpr.getStructure().getElementFor(node);
        if (element != null && (modifiers = element.getModifiers()) != null) {
            return !modifiers.contains(Modifier.PRIVATE) && !modifiers.contains(Modifier.PROTECTED);
        }
        return true;
    }

    private boolean shouldHaveView(ParserResult info, Node node) {
        String method;
        if (node.getNodeType() == NodeType.FCALLNODE && ((method = ((INameNode)node).getName()).startsWith("redirect_") || method.equals("render"))) {
            return false;
        }
        List list = node.childNodes();
        for (Node child : list) {
            boolean result;
            if (child.isInvisible() || (result = this.shouldHaveView(info, child))) continue;
            return result;
        }
        return true;
    }

    public String getId() {
        return "Rails_Views";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(RailsViews.class, (String)"FindActionViews");
    }

    public String getDescription() {
        return NbBundle.getMessage(RailsViews.class, (String)"FindActionViewsDesc");
    }

    public boolean getDefaultEnabled() {
        return false;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public boolean showInTasklist() {
        return false;
    }

    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    private static class CreateViewFix
    implements HintFix {
        private FileObject controller;
        private String action;

        CreateViewFix(FileObject controller, String action) {
            this.controller = controller;
            this.action = action;
        }

        public String getDescription() {
            return NbBundle.getMessage(NestedLocal.class, (String)"CreateView");
        }

        public void implement() throws Exception {
            String controllerName = RubyUtils.getControllerName((FileObject)this.controller);
            Project project = FileOwnerQuery.getOwner((FileObject)this.controller);
            if (project == null) {
                return;
            }
            try {
                Class<?> c = Class.forName("org.netbeans.modules.ruby.railsprojects.GenerateAction", true, Thread.currentThread().getContextClassLoader());
                if (c != null) {
                    SystemAction generateAction = SystemAction.get(c);
                    Method m = c.getMethod("generate", Project.class, String.class, String.class, String.class);
                    m.invoke((Object)generateAction, project, "controller", controllerName, this.action);
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public boolean isSafe() {
            return false;
        }

        public boolean isInteractive() {
            return true;
        }
    }
}

