/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints.introduce;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jrubyparser.ast.BignumNode;
import org.jrubyparser.ast.FixnumNode;
import org.jrubyparser.ast.FloatNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.StrNode;
import org.jrubyparser.ast.SymbolNode;
import org.jrubyparser.ast.XStrNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.ruby.AstUtilities;

public class DuplicateDetector {
    private ParserResult info;
    private BaseDocument doc;
    private List<Node> nodes;
    private Node startNode;
    private Node endNode;
    private Node root;
    private int currentStart;
    private int currentEnd;
    private List<OffsetRange> duplicates = new ArrayList<OffsetRange>();

    public DuplicateDetector(ParserResult info, BaseDocument doc, Node root, List<Node> nodes, Node startNode, Node endNode) {
        this.info = info;
        this.doc = doc;
        this.root = root;
        this.nodes = nodes;
        this.startNode = startNode;
        this.endNode = endNode;
    }

    public static List<OffsetRange> findDuplicates(ParserResult info, BaseDocument doc, Node root, List<Node> nodes, Node startNode, Node endNode) {
        if (nodes.size() == 0 || startNode != endNode) {
            return Collections.emptyList();
        }
        if (startNode.getNodeType() == NodeType.ARRAYNODE) {
            if (startNode.childNodes().size() == 1) {
                startNode = (Node)startNode.childNodes().get(0);
            } else {
                return Collections.emptyList();
            }
        }
        DuplicateDetector detector = new DuplicateDetector(info, doc, root, nodes, startNode, endNode);
        detector.visit(root, startNode);
        return detector.duplicates;
    }

    private void visit(Node node, Node target) {
        if (node.getNodeType() == target.getNodeType()) {
            boolean equal = false;
            switch (node.getNodeType()) {
                case FLOATNODE: {
                    equal = ((FloatNode)node).getValue() == ((FloatNode)target).getValue();
                    break;
                }
                case BIGNUMNODE: {
                    equal = ((BignumNode)node).getValue() == ((BignumNode)target).getValue();
                    break;
                }
                case FIXNUMNODE: {
                    equal = ((FixnumNode)node).getValue() == ((FixnumNode)target).getValue();
                    break;
                }
                case SYMBOLNODE: {
                    equal = ((SymbolNode)node).getName().equals(((SymbolNode)target).getName());
                    break;
                }
                case STRNODE: {
                    equal = ((StrNode)node).getValue().equals(((StrNode)target).getValue());
                    break;
                }
                case XSTRNODE: {
                    equal = ((XStrNode)node).getValue().equals(((XStrNode)target).getValue());
                }
            }
            if (equal) {
                this.duplicates.add(AstUtilities.getRange((Node)node));
            }
        }
        List list = node.childNodes();
        for (Node child : list) {
            if (child.isInvisible()) continue;
            this.visit(child, target);
        }
    }
}

