/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints.introduce;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.ParseTreeVisitor;
import org.netbeans.modules.ruby.ParseTreeWalker;
import org.netbeans.modules.ruby.RubyFormatter;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.hints.infrastructure.RubySelectionRule;
import org.netbeans.modules.ruby.hints.introduce.IntroduceFix;
import org.netbeans.modules.ruby.hints.introduce.IntroduceKind;
import org.netbeans.modules.ruby.hints.introduce.IntroduceKindFinder;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class IntroduceHint
extends RubySelectionRule {
    @Override
    public void run(RubyRuleContext context, List<Hint> result) {
        ParserResult info = context.parserResult;
        int start = context.selectionStart;
        int end = context.selectionEnd;
        assert (start < end);
        try {
            ClassNode clz;
            BaseDocument doc = context.doc;
            if (end > doc.getLength()) {
                return;
            }
            if (end - start > 1000) {
                return;
            }
            if (RubyFormatter.getTokenBalance((BaseDocument)doc, (int)start, (int)end, (boolean)true, (RubyUtils.isRhtmlDocument((Document)doc) || RubyUtils.isYamlDocument((Document)doc) ? 1 : 0) != 0) != 0) {
                return;
            }
            Node root = AstUtilities.getRoot((Parser.Result)info);
            if (root == null) {
                return;
            }
            OffsetRange lexOffsets = this.adjustOffsets(info, doc, start, end);
            if (lexOffsets == OffsetRange.NONE) {
                return;
            }
            OffsetRange astOffsets = AstUtilities.getAstOffsets((Parser.Result)info, (OffsetRange)lexOffsets);
            if (astOffsets == OffsetRange.NONE) {
                return;
            }
            int astStart = astOffsets.getStart();
            int astEnd = astOffsets.getEnd();
            HashMap<Integer, List<Node>> nodeDepthMap = new HashMap<Integer, List<Node>>();
            this.findApplicableNodes(root, astStart, astEnd, nodeDepthMap, 0);
            if (nodeDepthMap.keySet().size() != 1) {
                return;
            }
            List nodes = (List)nodeDepthMap.values().iterator().next();
            assert (nodes.size() > 0);
            IntroduceKindFinder typeChecker = new IntroduceKindFinder();
            ParseTreeWalker walker = new ParseTreeWalker((ParseTreeVisitor)typeChecker);
            for (Node node : nodes) {
                walker.walk(node);
            }
            List<IntroduceKind> kinds = typeChecker.getKinds();
            if (kinds == null || kinds.size() == 0) {
                return;
            }
            OffsetRange range = new OffsetRange(start, end);
            JTextComponent target = GsfUtilities.getPaneFor((FileObject)RubyUtils.getFileObject((Parser.Result)info));
            if (target != null) {
                int dot = target.getCaret().getDot();
                if (start == dot) {
                    range = new OffsetRange(start, start);
                } else if (end == dot) {
                    range = new OffsetRange(end, end);
                }
            }
            if (RubyUtils.isRhtmlDocument((Document)doc) || RubyUtils.isYamlDocument((Document)doc)) {
                kinds.retainAll(Collections.singleton(IntroduceKind.CREATE_VARIABLE));
            } else if (kinds.contains((Object)IntroduceKind.CREATE_FIELD) && (clz = AstUtilities.findClassAtOffset((Node)root, (int)start)) == null) {
                kinds.remove((Object)IntroduceKind.CREATE_FIELD);
                if (kinds.size() == 0) {
                    return;
                }
            }
            for (IntroduceKind kind : kinds) {
                IntroduceFix fix = new IntroduceFix(context, nodes, lexOffsets, astOffsets, kind);
                ArrayList<IntroduceFix> fixList = new ArrayList<IntroduceFix>(1);
                fixList.add(fix);
                String displayName = fix.getDescription();
                Hint desc = new Hint((Rule)this, displayName, RubyUtils.getFileObject((Parser.Result)info), range, fixList, 292);
                result.add(desc);
            }
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public boolean appliesTo(RuleContext context) {
        return true;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(IntroduceHint.class, (String)"IntroduceHint");
    }

    public String getId() {
        return "RubyIntroduceHint";
    }

    public String getDescription() {
        return NbBundle.getMessage(IntroduceHint.class, (String)"IntroduceHintDesc");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    public boolean showInTasklist() {
        return false;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.CURRENT_LINE_WARNING;
    }

    private OffsetRange adjustOffsets(ParserResult info, BaseDocument doc, int start, int end) throws BadLocationException {
        int adjustedEnd;
        int adjustedStart;
        int startRowEnd = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)start);
        startRowEnd = startRowEnd == -1 ? Utilities.getRowEnd((BaseDocument)doc, (int)end) : ++startRowEnd;
        if (start >= startRowEnd) {
            adjustedStart = Utilities.getRowEnd((BaseDocument)doc, (int)start) + 1;
            if (adjustedStart <= doc.getLength()) {
                int nextRow = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)adjustedStart);
                if (nextRow != -1) {
                    adjustedStart = nextRow;
                }
            } else {
                adjustedStart = doc.getLength();
            }
        } else {
            adjustedStart = Math.max(start, Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)start));
        }
        int rowBegin = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)end);
        if (rowBegin == -1) {
            adjustedEnd = Math.max(0, Utilities.getRowStart((BaseDocument)doc, (int)end) - 1);
        } else if (end <= rowBegin) {
            adjustedEnd = Math.max(0, Utilities.getRowStart((BaseDocument)doc, (int)end) - 1);
        } else {
            int rowEnd = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)end);
            adjustedEnd = Math.min(end, rowEnd + 1);
        }
        adjustedStart = Math.min(adjustedStart, doc.getLength());
        adjustedEnd = Math.min(adjustedEnd, doc.getLength());
        if (adjustedEnd <= adjustedStart) {
            return OffsetRange.NONE;
        }
        return new OffsetRange(adjustedStart, adjustedEnd);
    }

    private void findApplicableNodes(Node node, int start, int end, Map<Integer, List<Node>> result, int depth) {
        List list = node.childNodes();
        for (Node child : list) {
            if (child.isInvisible()) continue;
            if (child.getNodeType() == NodeType.NEWLINENODE || child.getNodeType() == NodeType.HASHNODE) {
                this.findApplicableNodes(child, start, end, result, depth + 1);
                continue;
            }
            boolean add = false;
            SourcePosition pos = child.getPosition();
            if (pos.getStartOffset() >= start && pos.getEndOffset() <= end) {
                add = true;
            } else if (pos.getStartOffset() <= start && pos.getEndOffset() >= end) {
                if (pos.getStartOffset() == start && pos.getEndOffset() == end) {
                    add = true;
                } else {
                    this.findApplicableNodes(child, start, end, result, depth + 1);
                }
            } else if (pos.getStartOffset() <= start && start <= pos.getEndOffset()) {
                this.findApplicableNodes(child, start, end, result, depth + 1);
            } else if (pos.getStartOffset() <= end && end <= pos.getEndOffset()) {
                this.findApplicableNodes(child, start, end, result, depth + 1);
            }
            if (!add) continue;
            List<Node> l = result.get(depth);
            if (l == null) {
                l = new ArrayList<Node>();
                result.put(depth, l);
            }
            l.add(child);
        }
    }
}

