/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors.timezone;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.netbeans.modules.vmd.midp.propertyeditors.timezone.TimeZoneComboboxModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PropertyEditorTimeZone
extends PropertyEditorUserCode {
    private TimeZoneEditor timeZoneEditor;

    private PropertyEditorTimeZone() {
        super(NbBundle.getMessage(PropertyEditorTimeZone.class, (String)"LBL_TIME_ZONE_UCLABEL"));
    }

    public static PropertyEditorTimeZone createInstance() {
        return new PropertyEditorTimeZone();
    }

    @Override
    public void cleanUp(DesignComponent component) {
        super.cleanUp(component);
        if (this.timeZoneEditor != null) {
            this.timeZoneEditor.cleanUp();
            this.timeZoneEditor = null;
        }
    }

    @Override
    public String getAsText() {
        String superText = super.getAsText();
        if (superText != null) {
            return superText;
        }
        PropertyValue value = (PropertyValue)super.getValue();
        return (String)value.getPrimitiveValue();
    }

    private void saveValue(String text) {
        if (text.length() > 0) {
            super.setValue((Object)MidpTypes.createStringValue(text));
        }
    }

    @Override
    public Component getCustomEditor() {
        if (this.timeZoneEditor == null) {
            this.timeZoneEditor = new TimeZoneEditor();
            this.initElements(Collections.singleton(this.timeZoneEditor));
        }
        return super.getCustomEditor();
    }

    @Override
    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.timeZoneEditor.getRadioButton().isSelected()) {
            this.saveValue(this.timeZoneEditor.getTextForPropertyValue());
        }
    }

    private final class TimeZoneEditor
    implements PropertyEditorElement,
    ActionListener {
        private JRadioButton radioButton = new JRadioButton();
        private TimeZoneComboboxModel model;
        private JComboBox combobox;

        public TimeZoneEditor() {
            Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorTimeZone.class, (String)"LBL_TIMEZONE"));
            this.model = new TimeZoneComboboxModel();
            this.combobox = new JComboBox(this.model);
            this.combobox.setEditable(true);
            this.combobox.addActionListener(this);
        }

        void cleanUp() {
            this.radioButton = null;
            this.model = null;
            if (this.combobox != null) {
                this.combobox.removeActionListener(this);
                this.combobox = null;
            }
        }

        @Override
        public void updateState(PropertyValue value) {
            if (!PropertyEditorTimeZone.this.isCurrentValueANull() && value != null) {
                for (int i = 0; i < this.model.getSize(); ++i) {
                    String timeZone = (String)this.model.getElementAt(i);
                    if (!timeZone.equals(value.getPrimitiveValue())) continue;
                    this.model.setSelectedItem(timeZone);
                    break;
                }
            }
        }

        @Override
        public void setTextForPropertyValue(String text) {
            PropertyEditorTimeZone.this.saveValue(text);
        }

        @Override
        public String getTextForPropertyValue() {
            return (String)this.combobox.getSelectedItem();
        }

        @Override
        public JComponent getCustomEditorComponent() {
            return this.combobox;
        }

        @Override
        public JRadioButton getRadioButton() {
            return this.radioButton;
        }

        @Override
        public boolean isInitiallySelected() {
            return true;
        }

        @Override
        public boolean isVerticallyResizable() {
            return false;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.radioButton.setSelected(true);
        }
    }
}

