/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display;

import java.awt.Dimension;
import java.awt.Graphics;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import org.openide.util.NbBundle;

abstract class WrappedLabel
extends JPanel {
    private static final long serialVersionUID = 1123746185724284730L;
    private String myText;
    private Mode myMode;
    private List<String> myList;
    private int myWidth = -1;

    WrappedLabel() {
    }

    @Override
    public void paintComponent(Graphics g) {
        this.fillWrapList(g);
        int height = g.getFontMetrics().getHeight();
        int i = 1;
        for (String string : this.myList) {
            g.drawString(string, 0, (i - 1) * height + g.getFontMetrics().getAscent());
            ++i;
        }
        int componentHeight = this.myList.size() * height;
        this.setPreferredSize(new Dimension(this.getPreferedWidth(), componentHeight));
        this.setMaximumSize(this.getPreferredSize());
        this.setMinimumSize(this.getPreferredSize());
        this.revalidate();
    }

    public String getText() {
        return this.myText;
    }

    public void setText(String text) {
        this.myText = text == null || text.length() == 0 ? " " : text;
    }

    protected Mode getMode() {
        return this.myMode;
    }

    protected int getLabelHeight() {
        return -1;
    }

    protected int getPreferedWidth() {
        if (this.myWidth == -1) {
            return this.getLabelWidth();
        }
        return this.myWidth;
    }

    protected void setPreferedWidth(int width) {
        this.myWidth = width;
    }

    protected abstract int getLabelWidth();

    protected void setMode(Mode mode) {
        this.myMode = mode;
    }

    protected String getSuffix() {
        if (this.getMode() == Mode.WRAP_ON) {
            return NbBundle.getMessage(WrappedLabel.class, (String)"TXT_NoWrapSign");
        }
        if (this.getMode() == Mode.DEFAULT) {
            return "";
        }
        return null;
    }

    private Dimension getLabelSize() {
        int height = this.getLabelHeight();
        if (height == -1) {
            height = (int)super.getSize().getHeight();
        }
        return new Dimension(this.getPreferedWidth(), height);
    }

    private void fillWrapList(Graphics g) {
        int indx;
        boolean noWrap;
        if (this.myList == null) {
            this.myList = new LinkedList<String>();
        }
        String str = this.getText();
        int width = this.getPreferedWidth();
        double empiricLetterWidth = g.getFontMetrics().getStringBounds("a", g).getWidth();
        int empiricSize = (int)((double)width / empiricLetterWidth);
        this.myList.clear();
        boolean bl = noWrap = this.getSuffix() != null;
        while ((indx = this.getWrapIndex(str, g, width, empiricSize)) != str.length()) {
            if (indx == 0) {
                return;
            }
            String start = str.substring(0, indx);
            if (noWrap) {
                start = start + this.getSuffix();
            }
            this.myList.add(start);
            if (noWrap) {
                str = "";
                break;
            }
            str = str.substring(indx);
        }
        if (str.length() > 0) {
            this.myList.add(str);
        }
    }

    private int getWrapIndex(String str, Graphics g, double width, int empiricSize) {
        double startWidth;
        if (g.getFontMetrics().getStringBounds(str, g).getWidth() <= width) {
            return str.length();
        }
        if (str.length() == 0) {
            return str.length();
        }
        if (empiricSize >= str.length()) {
            empiricSize = str.length();
        }
        if ((startWidth = g.getFontMetrics().getStringBounds(this.getSubstring(str, empiricSize), g).getWidth()) <= width) {
            for (int i = empiricSize; i <= str.length(); ++i) {
                double stringWidth = g.getFontMetrics().getStringBounds(this.getSubstring(str, i), g).getWidth();
                if (!(stringWidth > width)) continue;
                return i - 1;
            }
            return str.length();
        }
        for (int i = empiricSize; i >= 0; --i) {
            double stringWidth = g.getFontMetrics().getStringBounds(this.getSubstring(str, i), g).getWidth();
            if (!(stringWidth <= width)) continue;
            return i;
        }
        return str.length();
    }

    private String getSubstring(String main, int index) {
        if (this.getSuffix() == null) {
            return main.substring(0, index);
        }
        StringBuilder builder = new StringBuilder(main);
        return builder.delete(index, main.length()).append(this.getSuffix()).toString();
    }

    static enum Mode {
        WRAP_ON(2),
        WRAP_OFF(1),
        DEFAULT(0);

        private final int myMode;

        private Mode(int mode) {
            this.myMode = mode;
        }

        public static Mode forInt(int mode) {
            for (Mode md : Mode.values()) {
                if (md.myMode != mode) continue;
                return md;
            }
            return DEFAULT;
        }
    }
}

