/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.indirection;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import oracle.toplink.essentials.indirection.IndirectContainer;
import oracle.toplink.essentials.indirection.ValueHolder;
import oracle.toplink.essentials.indirection.ValueHolderInterface;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.indirection.UnitOfWorkQueryValueHolder;

public class IndirectList
extends Vector
implements IndirectContainer {
    protected Vector delegate;
    protected ValueHolderInterface valueHolder;
    private transient String attributeName;
    protected int initialCapacity = 10;

    public IndirectList() {
        this(10);
    }

    public IndirectList(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public IndirectList(int initialCapacity, int capacityIncrement) {
        super(0);
        this.initialize(initialCapacity, capacityIncrement);
    }

    public IndirectList(Collection c) {
        super(0);
        this.initialize(c);
    }

    public void add(int index, Object element) {
        this.getDelegate().add(index, element);
        this.raiseAddChangeEvent(element);
    }

    protected void raiseAddChangeEvent(Object element) {
        if (this.hasBeenRegistered()) {
            ((UnitOfWorkQueryValueHolder)this.getValueHolder()).updateForeignReferenceSet(element, null);
        }
    }

    protected void raiseRemoveChangeEvent(Object element) {
        if (this.hasBeenRegistered()) {
            ((UnitOfWorkQueryValueHolder)this.getValueHolder()).updateForeignReferenceRemove(element);
        }
    }

    public synchronized boolean add(Object o) {
        this.getDelegate().add(o);
        this.raiseAddChangeEvent(o);
        return true;
    }

    public synchronized boolean addAll(int index, Collection c) {
        Iterator objects = c.iterator();
        if (this.hasBeenRegistered()) {
            while (objects.hasNext()) {
                this.add(index, objects.next());
                ++index;
            }
            return true;
        }
        return this.getDelegate().addAll(index, c);
    }

    public synchronized boolean addAll(Collection c) {
        if (this.hasBeenRegistered()) {
            Iterator objects = c.iterator();
            while (objects.hasNext()) {
                this.add(objects.next());
            }
            return true;
        }
        return this.getDelegate().addAll(c);
    }

    public synchronized void addElement(Object obj) {
        this.add(obj);
    }

    protected Vector buildDelegate() {
        return (Vector)this.getValueHolder().getValue();
    }

    public int capacity() {
        return this.getDelegate().capacity();
    }

    public void clear() {
        if (this.hasBeenRegistered()) {
            Iterator objects = this.iterator();
            while (objects.hasNext()) {
                Object o = objects.next();
                objects.remove();
                this.raiseRemoveChangeEvent(o);
            }
        } else {
            this.getDelegate().clear();
        }
    }

    public synchronized Object clone() {
        IndirectList result = (IndirectList)super.clone();
        result.delegate = (Vector)this.getDelegate().clone();
        result.attributeName = null;
        return result;
    }

    public boolean contains(Object elem) {
        return this.getDelegate().contains(elem);
    }

    public synchronized boolean containsAll(Collection c) {
        return this.getDelegate().containsAll(c);
    }

    public synchronized void copyInto(Object[] anArray) {
        this.getDelegate().copyInto(anArray);
    }

    public synchronized Object elementAt(int index) {
        return this.getDelegate().elementAt(index);
    }

    public Enumeration elements() {
        return this.getDelegate().elements();
    }

    public synchronized void ensureCapacity(int minCapacity) {
        this.getDelegate().ensureCapacity(minCapacity);
    }

    public synchronized boolean equals(Object o) {
        return this.getDelegate().equals(o);
    }

    public synchronized Object firstElement() {
        return this.getDelegate().firstElement();
    }

    public synchronized Object get(int index) {
        return this.getDelegate().get(index);
    }

    protected synchronized Vector getDelegate() {
        if (this.delegate == null) {
            this.delegate = this.buildDelegate();
        }
        return this.delegate;
    }

    public synchronized ValueHolderInterface getValueHolder() {
        if (this.valueHolder == null) {
            this.valueHolder = new ValueHolder(new Vector(this.initialCapacity, this.capacityIncrement));
        }
        return this.valueHolder;
    }

    public boolean hasBeenRegistered() {
        return this.getValueHolder() instanceof UnitOfWorkQueryValueHolder;
    }

    public synchronized int hashCode() {
        return this.getDelegate().hashCode();
    }

    public int indexOf(Object elem) {
        return this.getDelegate().indexOf(elem);
    }

    public synchronized int indexOf(Object elem, int index) {
        return this.getDelegate().indexOf(elem, index);
    }

    protected void initialize(int initialCapacity, int capacityIncrement) {
        this.initialCapacity = initialCapacity;
        this.capacityIncrement = capacityIncrement;
        this.delegate = null;
        this.valueHolder = null;
    }

    protected void initialize(Collection c) {
        this.delegate = null;
        Vector temp = new Vector(c);
        this.valueHolder = new ValueHolder(temp);
    }

    public synchronized void insertElementAt(Object obj, int index) {
        this.getDelegate().insertElementAt(obj, index);
        this.raiseAddChangeEvent(obj);
    }

    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    public boolean isInstantiated() {
        return this.getValueHolder().isInstantiated();
    }

    public Iterator iterator() {
        return new Iterator(){
            Iterator delegateIterator;
            Object currentObject;
            {
                this.delegateIterator = IndirectList.this.getDelegate().iterator();
            }

            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            public Object next() {
                this.currentObject = this.delegateIterator.next();
                return this.currentObject;
            }

            public void remove() {
                this.delegateIterator.remove();
                IndirectList.this.raiseRemoveChangeEvent(this.currentObject);
            }
        };
    }

    public synchronized Object lastElement() {
        return this.getDelegate().lastElement();
    }

    public int lastIndexOf(Object elem) {
        return this.getDelegate().lastIndexOf(elem);
    }

    public synchronized int lastIndexOf(Object elem, int index) {
        return this.getDelegate().lastIndexOf(elem, index);
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(final int index) {
        return new ListIterator(){
            ListIterator delegateIterator;
            Object currentObject;
            {
                this.delegateIterator = IndirectList.this.getDelegate().listIterator(index);
            }

            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            public boolean hasPrevious() {
                return this.delegateIterator.hasPrevious();
            }

            public int previousIndex() {
                return this.delegateIterator.previousIndex();
            }

            public int nextIndex() {
                return this.delegateIterator.nextIndex();
            }

            public Object next() {
                this.currentObject = this.delegateIterator.next();
                return this.currentObject;
            }

            public Object previous() {
                this.currentObject = this.delegateIterator.previous();
                return this.currentObject;
            }

            public void remove() {
                this.delegateIterator.remove();
                IndirectList.this.raiseRemoveChangeEvent(this.currentObject);
            }

            public void set(Object object) {
                this.delegateIterator.set(object);
                IndirectList.this.raiseRemoveChangeEvent(this.currentObject);
                IndirectList.this.raiseAddChangeEvent(object);
            }

            public void add(Object object) {
                this.delegateIterator.add(object);
                IndirectList.this.raiseAddChangeEvent(object);
            }
        };
    }

    public synchronized Object remove(int index) {
        Object value = this.getDelegate().remove(index);
        this.raiseRemoveChangeEvent(value);
        return value;
    }

    public boolean remove(Object o) {
        if (this.getDelegate().remove(o)) {
            this.raiseRemoveChangeEvent(o);
            return true;
        }
        return false;
    }

    public synchronized boolean removeAll(Collection c) {
        if (this.hasBeenRegistered()) {
            Iterator objects = c.iterator();
            while (objects.hasNext()) {
                this.remove(objects.next());
            }
            return true;
        }
        return this.getDelegate().removeAll(c);
    }

    public synchronized void removeAllElements() {
        if (this.hasBeenRegistered()) {
            Iterator objects = this.iterator();
            while (objects.hasNext()) {
                Object object = objects.next();
                objects.remove();
                this.raiseRemoveChangeEvent(object);
            }
            return;
        }
        this.getDelegate().removeAllElements();
    }

    public synchronized boolean removeElement(Object obj) {
        return this.remove(obj);
    }

    public synchronized void removeElementAt(int index) {
        this.remove(index);
    }

    public synchronized boolean retainAll(Collection c) {
        if (this.hasBeenRegistered()) {
            Iterator objects = this.getDelegate().iterator();
            while (objects.hasNext()) {
                Object object = objects.next();
                if (c.contains(object)) continue;
                objects.remove();
                this.raiseRemoveChangeEvent(object);
            }
            return true;
        }
        return this.getDelegate().retainAll(c);
    }

    public synchronized Object set(int index, Object element) {
        Object oldValue = this.getDelegate().set(index, element);
        this.raiseRemoveChangeEvent(oldValue);
        this.raiseAddChangeEvent(element);
        return oldValue;
    }

    public synchronized void setElementAt(Object obj, int index) {
        this.set(index, obj);
    }

    public synchronized void setSize(int newSize) {
        if (this.hasBeenRegistered() && newSize > this.size()) {
            for (int index = this.size(); index > newSize; --index) {
                this.remove(index - 1);
            }
        }
        this.getDelegate().setSize(newSize);
    }

    public void setValueHolder(ValueHolderInterface valueHolder) {
        this.delegate = null;
        this.valueHolder = valueHolder;
    }

    public int size() {
        return this.getDelegate().size();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.getDelegate().subList(fromIndex, toIndex);
    }

    public synchronized Object[] toArray() {
        return this.getDelegate().toArray();
    }

    public synchronized Object[] toArray(Object[] a) {
        return this.getDelegate().toArray(a);
    }

    public String toString() {
        if (this.isInstantiated()) {
            return "{" + this.getDelegate().toString() + "}";
        }
        return "{" + Helper.getShortClassName(this.getClass()) + ": not instantiated}";
    }

    public synchronized void trimToSize() {
        this.getDelegate().trimToSize();
    }

    public String getTopLinkAttributeName() {
        return this.attributeName;
    }

    public void setTopLinkAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }
}

