/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.spi.project.ProjectFactory2;
import org.netbeans.spi.project.ProjectState;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;

public class NbMavenProjectFactory
implements ProjectFactory2 {
    public boolean isProject(FileObject fileObject) {
        File projectDir = FileUtil.toFile((FileObject)fileObject);
        if (projectDir == null) {
            return false;
        }
        File project = new File(projectDir, "pom.xml");
        if (project.isFile() && project.getAbsolutePath().contains("resources" + File.separator + "archetype-resources")) {
            return false;
        }
        return project.isFile() && !"nbproject".equalsIgnoreCase(projectDir.getName());
    }

    public ProjectManager.Result isProject2(FileObject projectDirectory) {
        if (this.isProject(projectDirectory)) {
            return new ProjectManager.Result((Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/resources/Maven2Icon.gif", (boolean)true));
        }
        return null;
    }

    public Project loadProject(FileObject fileObject, ProjectState projectState) throws IOException {
        if (FileUtil.toFile((FileObject)fileObject) == null) {
            return null;
        }
        if ("nbproject".equalsIgnoreCase(fileObject.getName())) {
            return null;
        }
        FileObject projectFile = fileObject.getFileObject("pom.xml");
        if (projectFile == null || !projectFile.isData()) {
            return null;
        }
        File projectDiskFile = FileUtil.normalizeFile((File)FileUtil.toFile((FileObject)projectFile));
        if (projectDiskFile == null) {
            return null;
        }
        if (projectDiskFile.isFile() && projectDiskFile.getAbsolutePath().contains("resources" + File.separator + "archetype-resources")) {
            return null;
        }
        try {
            NbMavenProjectImpl proj = new NbMavenProjectImpl(fileObject, projectFile, projectDiskFile, projectState);
            return proj;
        }
        catch (Exception exc) {
            ErrorManager.getDefault().getInstance(NbMavenProjectFactory.class.getName()).notify(1, (Throwable)exc);
            return null;
        }
    }

    public void saveProject(Project project) throws IOException {
    }
}

