/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.newproject;

import hidden.org.codehaus.plexus.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.netbeans.modules.maven.api.archetype.Archetype;
import org.netbeans.modules.maven.api.archetype.ArchetypeProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class CatalogRepoProvider
implements ArchetypeProvider {
    private static final String EL_ARCHETYPES = "archetypes";
    private static final String EL_ARCHETYPE = "archetype";
    private static final String EL_ARTIFACTID = "artifactId";
    private static final String EL_DESCRIPTION = "description";
    private static final String EL_GROUPID = "groupId";
    private static final String EL_REPOSITORY = "repository";
    private static final String EL_VERSION = "version";
    private final FileObject fo;

    public CatalogRepoProvider(File path) {
        this.fo = FileUtil.toFileObject((File)path);
    }

    public CatalogRepoProvider(FileObject path) {
        this.fo = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Archetype> getArchetypes() {
        if (this.fo == null) {
            return Collections.emptyList();
        }
        ArrayList<Archetype> toRet = new ArrayList<Archetype>();
        InputStream inStr = null;
        try {
            inStr = this.fo.getInputStream();
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(inStr);
            Element root = doc.getRootElement();
            Element list = root.getChild(EL_ARCHETYPES);
            if (list != null) {
                List archetypes = list.getChildren(EL_ARCHETYPE);
                for (Element el : archetypes) {
                    String grId = el.getChildText(EL_GROUPID);
                    String artId = el.getChildText(EL_ARTIFACTID);
                    String ver = el.getChildText(EL_VERSION);
                    String repo = el.getChildText(EL_REPOSITORY);
                    String desc = el.getChildText(EL_DESCRIPTION);
                    Archetype archetype = new Archetype(false);
                    if (grId == null || artId == null || ver == null) continue;
                    archetype.setArtifactId(artId);
                    archetype.setGroupId(grId);
                    archetype.setVersion(ver);
                    if (repo != null) {
                        archetype.setRepository(repo);
                    }
                    if (desc != null) {
                        archetype.setName(desc);
                    }
                    toRet.add(archetype);
                }
            }
        }
        catch (IOException exc) {
            Logger.getLogger(CatalogRepoProvider.class.getName()).log(Level.FINE, "", exc);
        }
        catch (JDOMException exc) {
            Logger.getLogger(CatalogRepoProvider.class.getName()).log(Level.FINE, "", exc);
        }
        finally {
            IOUtil.close((InputStream)inStr);
        }
        return toRet;
    }
}

