/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.operations;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.apache.maven.project.MavenProject;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.api.validation.adapters.DialogDescriptorAdapter;
import org.netbeans.api.validation.adapters.NotificationLineSupportAdapter;
import org.netbeans.modules.maven.MavenValidators;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Severity;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.builtin.Validators;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationUI;
import org.openide.DialogDescriptor;
import org.openide.LifecycleManager;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RenameProjectPanel
extends JPanel {
    private final NbMavenProjectImpl project;
    private ValidationGroup vg;
    private NotificationLineSupport nls;
    private JCheckBox cbArtifactId;
    private JCheckBox cbDisplayName;
    private JCheckBox cbFolder;
    private JLabel lblRename;
    private JTextArea taWarning;
    private JTextField txtArtifactId;
    private JTextField txtDisplayName;
    private JTextField txtFolder;
    private static final double NOTIFY_WORK = 0.1;
    private static final double FIND_PROJECT_WORK = 0.1;
    static final int MAX_WORK = 100;

    RenameProjectPanel(NbMavenProjectImpl prj) {
        this.initComponents();
        this.txtFolder.putClientProperty("_name", NbBundle.getMessage(RenameProjectPanel.class, (String)"NAME_Folder"));
        this.txtArtifactId.putClientProperty("_name", NbBundle.getMessage(RenameProjectPanel.class, (String)"NAME_Artifact"));
        this.project = prj;
        String folder = this.project.getProjectDirectory().getNameExt();
        this.txtFolder.setText(folder);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                MavenProject prj = RenameProjectPanel.this.project.getOriginalMavenProject();
                final String dn = prj.getName();
                final String artId = prj.getArtifactId();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RenameProjectPanel.this.txtArtifactId.setText(artId);
                        RenameProjectPanel.this.txtDisplayName.setText(dn);
                        RenameProjectPanel.this.lblRename.setText(NbBundle.getMessage(RenameProjectPanel.class, (String)"RenameProjectPanel.lblRename.text2", (Object)dn));
                    }
                });
            }
        });
    }

    void createValidations(DialogDescriptor dd) {
        this.nls = dd.createNotificationLineSupport();
        this.vg = ValidationGroup.create((ValidationUI[])new ValidationUI[]{new NotificationLineSupportAdapter(this.nls), new DialogDescriptorAdapter(dd)});
        this.vg.add((JTextComponent)this.txtFolder, new Validator[]{new OptionalValidator(this.cbFolder, (Validator<String>)Validators.merge((boolean)true, (Validator[])new Validator[]{Validators.REQUIRE_NON_EMPTY_STRING, Validators.REQUIRE_VALID_FILENAME, new FileNameExists(FileUtil.toFile((FileObject)this.project.getProjectDirectory().getParent()))}))});
        this.vg.add((JTextComponent)this.txtArtifactId, new Validator[]{new OptionalValidator(this.cbArtifactId, MavenValidators.createArtifactIdValidators())});
        this.checkEnablement();
    }

    private void checkEnablement() {
        this.txtArtifactId.setEnabled(this.cbArtifactId.isSelected());
        this.txtDisplayName.setEnabled(this.cbDisplayName.isSelected());
        this.txtFolder.setEnabled(this.cbFolder.isSelected());
        this.taWarning.setText(this.cbFolder.isSelected() ? NbBundle.getMessage(RenameProjectPanel.class, (String)"RenameProjectPanel.taWarning.text") : "");
    }

    private void initComponents() {
        this.lblRename = new JLabel();
        this.cbDisplayName = new JCheckBox();
        this.txtDisplayName = new JTextField();
        this.cbArtifactId = new JCheckBox();
        this.txtArtifactId = new JTextField();
        this.cbFolder = new JCheckBox();
        this.txtFolder = new JTextField();
        this.taWarning = new JTextArea();
        Mnemonics.setLocalizedText((JLabel)this.lblRename, (String)NbBundle.getMessage(RenameProjectPanel.class, (String)"RenameProjectPanel.lblRename.text"));
        this.cbDisplayName.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbDisplayName, (String)NbBundle.getMessage(RenameProjectPanel.class, (String)"RenameProjectPanel.cbDisplayName.text"));
        this.cbDisplayName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenameProjectPanel.this.cbDisplayNameActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbArtifactId, (String)NbBundle.getMessage(RenameProjectPanel.class, (String)"RenameProjectPanel.cbArtifactId.text"));
        this.cbArtifactId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenameProjectPanel.this.cbArtifactIdActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbFolder, (String)NbBundle.getMessage(RenameProjectPanel.class, (String)"RenameProjectPanel.cbFolder.text"));
        this.cbFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenameProjectPanel.this.cbFolderActionPerformed(evt);
            }
        });
        this.taWarning.setColumns(20);
        this.taWarning.setEditable(false);
        this.taWarning.setForeground(UIManager.getColor("nb.errorForeground"));
        this.taWarning.setLineWrap(true);
        this.taWarning.setRows(5);
        this.taWarning.setText(NbBundle.getMessage(RenameProjectPanel.class, (String)"RenameProjectPanel.taWarning.text"));
        this.taWarning.setWrapStyleWord(true);
        this.taWarning.setOpaque(false);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.lblRename).add(1, (GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(21, 21, 21).add((Component)this.taWarning, -2, 395, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.cbArtifactId).add((Component)this.cbDisplayName).add((Component)this.cbFolder)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.txtDisplayName, -1, 258, Short.MAX_VALUE).add((Component)this.txtArtifactId, -1, 258, Short.MAX_VALUE).add((Component)this.txtFolder, -1, 258, Short.MAX_VALUE)))))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.lblRename).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.cbDisplayName).add((Component)this.txtDisplayName, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.cbArtifactId).add((Component)this.txtArtifactId, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.cbFolder).add((Component)this.txtFolder, -2, -1, -2)).addPreferredGap(0).add((Component)this.taWarning, -2, 66, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void cbDisplayNameActionPerformed(ActionEvent evt) {
        this.vg.validateAll();
        this.checkEnablement();
    }

    private void cbArtifactIdActionPerformed(ActionEvent evt) {
        this.vg.validateAll();
        this.checkEnablement();
    }

    private void cbFolderActionPerformed(ActionEvent evt) {
        this.vg.validateAll();
        this.checkEnablement();
    }

    void renameProject() {
        final boolean artId = this.cbArtifactId.isSelected();
        final boolean dname = this.cbDisplayName.isSelected();
        final boolean folder = this.cbFolder.isSelected();
        final String newArtId = this.txtArtifactId.getText().trim();
        final String newDname = this.txtDisplayName.getText().trim();
        final String newFolder = this.txtFolder.getText().trim();
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList<Object> opers = new ArrayList<Object>();
                if (artId) {
                    opers.add(new ArtIdOperation(newArtId));
                }
                if (dname) {
                    opers.add(new DNameOperation(newDname));
                }
                FileObject pomFO = RenameProjectPanel.this.project.getProjectDirectory().getFileObject("pom.xml");
                Utilities.performPOMModelOperations((FileObject)pomFO, opers);
                if (folder) {
                    ProgressHandle handle = ProgressHandleFactory.createHandle((String)("Rename Project" + dname));
                    handle.start(100);
                    try {
                        RenameProjectPanel.this.checkParentProject(RenameProjectPanel.this.project.getProjectDirectory().getNameExt(), newFolder);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    try {
                        RenameProjectPanel.doMoveProject(handle, RenameProjectPanel.this.project, newFolder, RenameProjectPanel.this.project.getProjectDirectory().getParent());
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        handle.finish();
                    }
                }
            }
        });
    }

    private void checkParentProject(final String newName, final String oldName) throws IOException {
        NbMavenProjectImpl par;
        FileObject fo = this.project.getProjectDirectory().getParent();
        Project possibleParent = ProjectManager.getDefault().findProject(fo);
        if (possibleParent != null && (par = (NbMavenProjectImpl)possibleParent.getLookup().lookup(NbMavenProjectImpl.class)) != null) {
            FileObject pomFO = par.getProjectDirectory().getFileObject("pom.xml");
            ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

                public void performOperation(POMModel model) {
                    List modules = model.getProject().getModules();
                    if (modules != null && modules.contains(oldName)) {
                        model.getProject().removeModule(oldName);
                        model.getProject().addModule(newName);
                    }
                }
            };
            Utilities.performPOMModelOperations((FileObject)pomFO, Collections.singletonList(operation));
        }
    }

    static void doMoveProject(ProgressHandle handle, Project project, String nueFolderName, FileObject newTarget) throws Exception {
        boolean originalOK = true;
        Project main = OpenProjects.getDefault().getMainProject();
        boolean wasMain = main != null && project.getProjectDirectory().equals(main.getProjectDirectory());
        FileObject target = null;
        try {
            int lastWorkDone;
            int totalWork = 100;
            double currentWorkDone = 0.0;
            handle.progress((int)currentWorkDone);
            RenameProjectPanel.close(project);
            currentWorkDone = (double)totalWork * 0.1;
            handle.progress((int)currentWorkDone);
            FileObject projectDirectory = project.getProjectDirectory();
            ArrayList<FileObject> toMoveList = new ArrayList<FileObject>();
            for (FileObject child : projectDirectory.getChildren()) {
                if (!child.isValid()) continue;
                toMoveList.add(child);
            }
            double workPerFileAndOperation = (double)totalWork * 0.7000000000000001 / (double)toMoveList.size() / 2.0;
            target = newTarget.createFolder(nueFolderName);
            for (FileObject toCopy : toMoveList) {
                RenameProjectPanel.doCopy(project, toCopy, target);
                lastWorkDone = (int)currentWorkDone;
                if (lastWorkDone >= (int)(currentWorkDone += workPerFileAndOperation)) continue;
                handle.progress((int)currentWorkDone);
            }
            originalOK = false;
            for (FileObject toCopy : toMoveList) {
                RenameProjectPanel.doDelete(project, toCopy);
                lastWorkDone = (int)currentWorkDone;
                if (lastWorkDone >= (int)(currentWorkDone += workPerFileAndOperation)) continue;
                handle.progress((int)currentWorkDone);
            }
            if (projectDirectory.getChildren().length == 0) {
                projectDirectory.delete();
            }
            ProjectManager.getDefault().clearNonProjectCache();
            Project nue = ProjectManager.getDefault().findProject(target);
            handle.progress((int)(currentWorkDone += (double)totalWork * 0.1));
            assert (nue != null);
            handle.progress((int)(currentWorkDone += (double)totalWork * 0.1));
            ProjectManager.getDefault().saveProject(nue);
            RenameProjectPanel.open(nue, wasMain);
            handle.progress(totalWork);
        }
        catch (Exception e) {
            if (originalOK) {
                RenameProjectPanel.open(project, wasMain);
            } else {
                assert (target != null);
                ProjectManager.getDefault().clearNonProjectCache();
                Project nue = ProjectManager.getDefault().findProject(target);
                assert (nue != null);
                RenameProjectPanel.open(nue, wasMain);
            }
            throw e;
        }
    }

    private static boolean doDelete(Project original, FileObject toDelete) throws IOException {
        block7: {
            if (!original.getProjectDirectory().equals(FileOwnerQuery.getOwner((FileObject)toDelete).getProjectDirectory())) {
                return false;
            }
            if (toDelete.isFolder()) {
                boolean delete = true;
                for (FileObject kid : toDelete.getChildren()) {
                    delete &= RenameProjectPanel.doDelete(original, kid);
                }
                if (delete) {
                    DataFolder.findFolder((FileObject)toDelete).delete();
                }
                return delete;
            }
            assert (toDelete.isData());
            try {
                DataObject dobj = DataObject.find((FileObject)toDelete);
                dobj.delete();
            }
            catch (DataObjectNotFoundException ex) {
                if (!toDelete.isValid()) break block7;
                toDelete.delete();
            }
        }
        return true;
    }

    private static void doCopy(Project original, FileObject from, FileObject toParent) throws IOException {
        if (!VisibilityQuery.getDefault().isVisible(from)) {
            return;
        }
        if (!original.getProjectDirectory().equals(FileOwnerQuery.getOwner((FileObject)from).getProjectDirectory())) {
            return;
        }
        if (SharabilityQuery.getSharability((File)FileUtil.toFile((FileObject)from)) == 2) {
            return;
        }
        if (from.isFolder()) {
            FileObject copy = toParent.createFolder(from.getNameExt());
            for (FileObject kid : from.getChildren()) {
                RenameProjectPanel.doCopy(original, kid, copy);
            }
        } else {
            assert (from.isData());
            FileObject fileObject = FileUtil.copyFile((FileObject)from, (FileObject)toParent, (String)from.getName(), (String)from.getExt());
        }
    }

    private static void close(Project prj) {
        LifecycleManager.getDefault().saveAll();
        OpenProjects.getDefault().close(new Project[]{prj});
    }

    private static void open(Project prj, boolean setAsMain) {
        OpenProjects.getDefault().open(new Project[]{prj}, false);
        if (setAsMain) {
            OpenProjects.getDefault().setMainProject(prj);
        }
    }

    private class FileNameExists
    implements Validator<String> {
        private final File parent;

        public FileNameExists(File parent) {
            assert (parent.isDirectory() && parent.exists());
            this.parent = parent;
        }

        public boolean validate(Problems problems, String compName, String model) {
            File newDir = new File(this.parent, model);
            if (newDir.exists()) {
                problems.add("Folder with name '" + model + "' already exists.", Severity.FATAL);
                return false;
            }
            return true;
        }
    }

    private class OptionalValidator
    implements Validator<String> {
        private final JCheckBox checkbox;
        private final Validator<String> delegate;

        public OptionalValidator(JCheckBox cb, Validator<String> validator) {
            this.checkbox = cb;
            this.delegate = validator;
        }

        public boolean validate(Problems problems, String compName, String model) {
            if (this.checkbox.isSelected()) {
                return this.delegate.validate(problems, compName, (Object)model);
            }
            return true;
        }
    }

    private class DNameOperation
    implements ModelOperation<POMModel> {
        private final String name;

        DNameOperation(String nm) {
            this.name = nm;
        }

        public void performOperation(POMModel model) {
            model.getProject().setName(this.name);
        }
    }

    private class ArtIdOperation
    implements ModelOperation<POMModel> {
        private final String artifactId;

        ArtIdOperation(String art) {
            this.artifactId = art;
        }

        public void performOperation(POMModel model) {
            model.getProject().setArtifactId(this.artifactId);
        }
    }
}

