/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.classpath.ClassPathProviderImpl;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;

public class MavenFileLocator
implements LineConvertors.FileLocator {
    private ClassPath classpath;
    private final Project project;
    private static final Object LOCK = new Object();

    public MavenFileLocator(Project project) {
        this.project = project;
        NbMavenProject.addPropertyChangeListener(project, new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object object = LOCK;
                synchronized (object) {
                    MavenFileLocator.this.classpath = null;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject find(String filename) {
        ClassPath cp;
        if (filename == null) {
            return null;
        }
        Object object = LOCK;
        synchronized (object) {
            if (this.classpath == null) {
                this.classpath = this.getProjectClasspath(this.project);
            }
            cp = this.classpath;
        }
        return cp.findResource(filename);
    }

    private ClassPath getProjectClasspath(Project p) {
        ClassPath result = null;
        ClassPathProviderImpl cpp = (ClassPathProviderImpl)p.getLookup().lookup(ClassPathProviderImpl.class);
        HashSet<FileObject> roots = new HashSet<FileObject>();
        Sources sources = ProjectUtils.getSources((Project)p);
        if (sources != null) {
            SourceGroup[] groups;
            for (SourceGroup group : groups = sources.getSourceGroups("java")) {
                roots.add(group.getRootFolder());
            }
        }
        HashSet<ClassPath> setCP = new HashSet<ClassPath>();
        if (cpp != null) {
            for (FileObject file : roots) {
                ClassPath path = cpp.findClassPath(file, "classpath/compile");
                setCP.add(path);
            }
        }
        for (ClassPath cp : setCP) {
            FileObject[] rootsCP;
            for (FileObject fo : rootsCP = cp.getRoots()) {
                try {
                    FileObject[] aaa = SourceForBinaryQuery.findSourceRoots((URL)fo.getURL()).getRoots();
                    roots.addAll(Arrays.asList(aaa));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        JavaPlatform platform = cpp.getJavaPlatform();
        if (platform != null) {
            roots.addAll(Arrays.asList(platform.getSourceFolders().getRoots()));
        }
        result = ClassPathSupport.createClassPath((FileObject[])roots.toArray(new FileObject[roots.size()]));
        return result;
    }
}

