/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.structure.document;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.action.TwoStateHoverProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.structure.document.ComponentWidget;
import org.openide.util.NbBundle;

public class DocumentScene
extends ObjectScene {
    static final Color COLOR_HOVERED = Color.CYAN;
    static final Color COLOR_SELECTED = Color.YELLOW;
    private LabelWidget labelWidget;
    private WidgetAction hoverAction = ActionFactory.createHoverAction((TwoStateHoverProvider)new DocumentHoverProvider());
    private WidgetAction selectAction = ActionFactory.createSelectAction((SelectProvider)new DocumentSelectProvider());
    private DesignDocument document;

    public DocumentScene() {
        this.setOpaque(false);
        this.getActions().addAction(ActionFactory.createZoomAction());
        this.getActions().addAction(ActionFactory.createPanAction());
        this.getActions().addAction(this.hoverAction);
        this.labelWidget = new LabelWidget((Scene)this, NbBundle.getMessage(DocumentScene.class, (String)"MSG_Loading"));
        this.labelWidget.setFont(this.getDefaultFont().deriveFont(1, 24.0f));
    }

    public void clear() {
        ArrayList objects = new ArrayList(this.getObjects());
        for (Object object : objects) {
            this.findWidget(object).removeFromParent();
            this.removeObject(object);
        }
        if (this.getChildren().contains(this.labelWidget)) {
            this.removeChild((Widget)this.labelWidget);
        }
    }

    public void setRootNode(DesignDocument document, ComponentWidget widget) {
        this.document = document;
        this.addChild(widget);
        this.addObject(document, new Widget[]{widget});
    }

    public void setupLoadingDocument() {
        this.clear();
        if (this.getChildren().contains(this.labelWidget)) {
            return;
        }
        this.addChild((Widget)this.labelWidget);
        this.validate();
    }

    public WidgetAction getHoverAction() {
        return this.hoverAction;
    }

    public WidgetAction getSelectAction() {
        return this.selectAction;
    }

    private class DocumentSelectProvider
    implements SelectProvider {
        private DocumentSelectProvider() {
        }

        public boolean isAimingAllowed(Widget widget, Point point, boolean b) {
            return false;
        }

        public boolean isSelectionAllowed(Widget widget, Point point, boolean b) {
            return true;
        }

        public void select(Widget widget, Point localLocation, boolean invertSelection) {
            Object object = DocumentScene.this.findObject(widget);
            final DesignComponent component = object != null ? ((ComponentWidget)DocumentScene.this.findWidget(object)).getComponent() : null;
            final DesignDocument document = DocumentScene.this.document;
            if (document != null) {
                document.getTransactionManager().writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        if (component != null) {
                            document.setSelectedComponents("document", Collections.singleton(component));
                        } else {
                            document.setSelectedComponents("document", Collections.emptySet());
                        }
                    }
                });
            }
        }
    }

    private class DocumentHoverProvider
    implements TwoStateHoverProvider {
        private Paint background;

        private DocumentHoverProvider() {
        }

        public void unsetHovering(Widget widget) {
            widget.setBackground(this.background);
        }

        public void setHovering(Widget widget) {
            this.background = widget.getBackground();
            widget.setBackground((Paint)COLOR_HOVERED);
        }
    }
}

