/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.util;

import java.text.ParseException;
import java.util.concurrent.TimeUnit;
import javax.swing.JFormattedTextField;
import org.netbeans.modules.dlight.util.ValueFormatter;

public final class TimeFormatter
extends JFormattedTextField.AbstractFormatter
implements ValueFormatter {
    private static final String MAX = "max";

    @Override
    public Object stringToValue(String text) throws ParseException {
        if (MAX.equalsIgnoreCase(text)) {
            return Long.MAX_VALUE;
        }
        long minutes = 0L;
        int colonPos = text.indexOf(58);
        if (0 <= colonPos) {
            try {
                minutes = Long.parseLong(text.substring(0, colonPos));
                text = text.substring(colonPos + 1);
            }
            catch (NumberFormatException ex) {
                throw new ParseException(text, 0);
            }
        }
        long nanos = 0L;
        int dotPos = text.indexOf(46);
        if (0 <= dotPos) {
            nanos = TimeFormatter.parseNanos(text.substring(dotPos + 1));
            text = text.substring(0, dotPos);
        }
        long seconds = 0L;
        try {
            seconds = Long.parseLong(text);
        }
        catch (NumberFormatException ex) {
            throw new ParseException(text, 0);
        }
        return TimeFormatter.minutesToNanos(minutes) + TimeUnit.SECONDS.toNanos(seconds) + nanos;
    }

    @Override
    public String valueToString(Object value) {
        return this.format((Long)value);
    }

    @Override
    public String format(long value) {
        if (value == Long.MAX_VALUE) {
            return MAX;
        }
        long minutes = TimeFormatter.nanosToMinutes(value);
        long seconds = TimeUnit.NANOSECONDS.toSeconds(value - TimeFormatter.minutesToNanos(minutes));
        long nanos = value - TimeFormatter.minutesToNanos(minutes) - TimeUnit.SECONDS.toNanos(seconds);
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("%d:%02d", minutes, seconds));
        if (1000000L <= nanos) {
            buf.append('.');
            buf.append(nanos / 100000000L);
            if (0L < (nanos %= 100000000L)) {
                buf.append(nanos / 10000000L);
                if (0L < (nanos %= 10000000L)) {
                    buf.append(nanos / 1000000L);
                }
            }
        }
        return buf.toString();
    }

    private static long parseNanos(String frac) throws ParseException {
        long result = 0L;
        for (int i = 0; i < 9; ++i) {
            int c;
            int n = c = i < frac.length() ? (int)frac.charAt(i) : 48;
            if (c < 48 || 57 < c) {
                throw new ParseException(frac, i);
            }
            result = 10L * result + (long)(c - 48);
        }
        return result;
    }

    private static long minutesToNanos(long m) {
        return TimeUnit.SECONDS.toNanos(60L * m);
    }

    private static long nanosToMinutes(long m) {
        return TimeUnit.NANOSECONDS.toSeconds(m) / 60L;
    }
}

