/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.queue;

import org.netbeans.modules.cnd.repository.queue.KeyValueQueue;
import org.netbeans.modules.cnd.repository.queue.RepositoryQueue;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.testbench.Stats;

public class TickingRepositoryQueue
extends RepositoryQueue {
    protected int currentTick = 0;
    protected final int tickShift;
    public static final int queueTickShift = Stats.getInteger("cnd.repository.queue.tickshift", 8);

    public TickingRepositoryQueue(int tickShift) {
        this.tickShift = tickShift;
    }

    public TickingRepositoryQueue() {
        this(queueTickShift);
    }

    @Override
    protected void doReplaceAddLast(Key key, Persistent value, KeyValueQueue.Entry<Key, Persistent> existent) {
        if (existent instanceof TickingEntry) {
            super.doReplaceAddLast(key, value, existent);
            this.queue.remove(existent);
            this.queue.addLast(existent);
            ((TickingEntry)existent).setTick(this.currentTick);
        }
    }

    @Override
    protected void doPostPoll(KeyValueQueue.Entry<Key, Persistent> polled) {
        super.doPostPoll(polled);
        if (this.queue.isEmpty()) {
            this.currentTick = 0;
        }
    }

    protected TickingEntry createEntry(Key key, Persistent value) {
        return new TickingEntry(key, value, this.currentTick);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReady() {
        Object object = this.lock;
        synchronized (object) {
            if (this.queue.isEmpty()) {
                return false;
            }
            TickingEntry entry = (TickingEntry)this.queue.peek();
            boolean bl = this.currentTick - entry.getTick() > queueTickShift;
            return bl;
        }
    }

    @Override
    public void onIdle() {
        ++this.currentTick;
    }

    public class TickingEntry
    extends KeyValueQueue.Entry<Key, Persistent> {
        private int tick;

        protected TickingEntry(Key key, Persistent value, int tick) {
            super(key, value);
            this.tick = tick;
        }

        public int getTick() {
            return this.tick;
        }

        public void setTick(int tick) {
            this.tick = tick;
        }
    }
}

