/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.hibernate.refactoring.HibernateMappingWhereUsedQueryUI;
import org.netbeans.modules.hibernate.refactoring.MoveMappingFilesRefactoringUI;
import org.netbeans.modules.hibernate.refactoring.RenameMappingFileRefactoringUI;
import org.netbeans.modules.refactoring.api.ui.ExplorerContext;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.datatransfer.PasteType;

public class HibernateMappingRefactoringActionsProvider
extends ActionsImplementationProvider {
    public boolean canRename(Lookup lookup) {
        Collection collection = lookup.lookupAll(Node.class);
        if (collection.size() != 1) {
            return false;
        }
        return this.isHibernateMappingFile(lookup);
    }

    public void doRename(final Lookup lookup) {
        if (this.canRename(lookup)) {
            NodeToFileObjectTask nodeToFileObjectTask = new NodeToFileObjectTask(lookup.lookupAll(Node.class)){

                @Override
                protected RefactoringUI createRefactoringUI(FileObject[] fileObjectArray) {
                    String string = HibernateMappingRefactoringActionsProvider.getNewName(lookup);
                    return new RenameMappingFileRefactoringUI(fileObjectArray[0], string);
                }
            };
            nodeToFileObjectTask.run();
        }
    }

    public boolean canMove(Lookup lookup) {
        return this.isHibernateMappingFile(lookup);
    }

    public void doMove(final Lookup lookup) {
        if (this.canMove(lookup)) {
            NodeToFileObjectTask nodeToFileObjectTask = new NodeToFileObjectTask(lookup.lookupAll(Node.class)){

                @Override
                protected RefactoringUI createRefactoringUI(FileObject[] fileObjectArray) {
                    PasteType pasteType = HibernateMappingRefactoringActionsProvider.this.getPaste(lookup);
                    FileObject fileObject = HibernateMappingRefactoringActionsProvider.this.getTarget(lookup);
                    if (fileObjectArray.length == 1) {
                        return new MoveMappingFilesRefactoringUI(fileObjectArray, fileObject, pasteType);
                    }
                    return new MoveMappingFilesRefactoringUI(fileObjectArray, fileObject, pasteType);
                }
            };
            nodeToFileObjectTask.run();
        }
    }

    public boolean canFindUsages(Lookup lookup) {
        Collection collection = lookup.lookupAll(Node.class);
        if (collection.size() != 1) {
            return false;
        }
        return this.isHibernateMappingFile(lookup);
    }

    public void doFindUsages(Lookup lookup) {
        if (this.canFindUsages(lookup) && this.canRename(lookup)) {
            NodeToFileObjectTask nodeToFileObjectTask = new NodeToFileObjectTask(lookup.lookupAll(Node.class)){

                @Override
                protected RefactoringUI createRefactoringUI(FileObject[] fileObjectArray) {
                    return new HibernateMappingWhereUsedQueryUI(fileObjectArray[0]);
                }
            };
            nodeToFileObjectTask.run();
        }
    }

    private static String getNewName(Lookup lookup) {
        ExplorerContext explorerContext = (ExplorerContext)lookup.lookup(ExplorerContext.class);
        if (explorerContext == null) {
            return null;
        }
        return explorerContext.getNewName();
    }

    private FileObject getTarget(Lookup lookup) {
        ExplorerContext explorerContext = (ExplorerContext)lookup.lookup(ExplorerContext.class);
        if (explorerContext == null) {
            return null;
        }
        Node node = explorerContext.getTargetNode();
        if (node == null) {
            return null;
        }
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject != null) {
            return dataObject.getPrimaryFile();
        }
        return null;
    }

    private PasteType getPaste(Lookup lookup) {
        ExplorerContext explorerContext = (ExplorerContext)lookup.lookup(ExplorerContext.class);
        if (explorerContext == null) {
            return null;
        }
        Transferable transferable = explorerContext.getTransferable();
        if (transferable == null) {
            return null;
        }
        Node node = explorerContext.getTargetNode();
        if (node == null) {
            return null;
        }
        PasteType[] pasteTypeArray = node.getPasteTypes(transferable);
        if (pasteTypeArray.length == 1) {
            return null;
        }
        return pasteTypeArray[1];
    }

    private boolean isHibernateMappingFile(Lookup lookup) {
        Collection collection = lookup.lookupAll(Node.class);
        for (Node node : collection) {
            FileObject fileObject;
            DataObject dataObject;
            if (node == null || (dataObject = (DataObject)node.getLookup().lookup(DataObject.class)) == null || !(fileObject = dataObject.getPrimaryFile()).getMIMEType().equals("text/x-hibernate-mapping+xml")) continue;
            return true;
        }
        return false;
    }

    public static abstract class NodeToFileObjectTask
    implements Runnable {
        private Collection<? extends Node> nodes;

        public NodeToFileObjectTask(Collection<? extends Node> collection) {
            this.nodes = collection;
        }

        @Override
        public void run() {
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>(this.nodes.size());
            for (Node node : this.nodes) {
                FileObject fileObject;
                DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
                if (dataObject == null || (fileObject = dataObject.getPrimaryFile()) == null) continue;
                arrayList.add(fileObject);
            }
            UI.openRefactoringUI((RefactoringUI)this.createRefactoringUI(arrayList.toArray(new FileObject[arrayList.size()])));
        }

        protected abstract RefactoringUI createRefactoringUI(FileObject[] var1);
    }
}

