/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.commons.collections.comparators;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ComparatorChain
implements Comparator,
Serializable {
    protected List comparatorChain = null;
    protected BitSet orderingBits = null;
    protected boolean isLocked = false;

    public ComparatorChain() {
        this(new ArrayList(), new BitSet());
    }

    public ComparatorChain(Comparator comparator) {
        this(comparator, false);
    }

    public ComparatorChain(Comparator comparator, boolean bl) {
        this.comparatorChain = new ArrayList();
        this.comparatorChain.add(comparator);
        this.orderingBits = new BitSet(1);
        if (bl) {
            this.orderingBits.set(0);
        }
    }

    public ComparatorChain(List list) {
        this(list, new BitSet(list.size()));
    }

    public ComparatorChain(List list, BitSet bitSet) {
        this.comparatorChain = list;
        this.orderingBits = bitSet;
    }

    public void addComparator(Comparator comparator) {
        this.addComparator(comparator, false);
    }

    public void addComparator(Comparator comparator, boolean bl) {
        this.checkLocked();
        this.comparatorChain.add(comparator);
        if (bl) {
            this.orderingBits.set(this.comparatorChain.size() - 1);
        }
    }

    public void setComparator(int n, Comparator comparator) throws IndexOutOfBoundsException {
        this.setComparator(n, comparator, false);
    }

    public void setComparator(int n, Comparator comparator, boolean bl) {
        this.checkLocked();
        this.comparatorChain.set(n, comparator);
        if (bl) {
            this.orderingBits.set(n);
        } else {
            this.orderingBits.clear(n);
        }
    }

    public void setForwardSort(int n) {
        this.checkLocked();
        this.orderingBits.clear(n);
    }

    public void setReverseSort(int n) {
        this.checkLocked();
        this.orderingBits.set(n);
    }

    public int size() {
        return this.comparatorChain.size();
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    private void checkLocked() {
        if (this.isLocked) {
            throw new UnsupportedOperationException("Comparator ordering cannot be changed after the first comparison is performed");
        }
    }

    private void checkChainIntegrity() {
        if (this.comparatorChain.size() == 0) {
            throw new UnsupportedOperationException("ComparatorChains must contain at least one Comparator");
        }
    }

    public int compare(Object object, Object object2) throws UnsupportedOperationException {
        if (!this.isLocked) {
            this.checkChainIntegrity();
            this.isLocked = true;
        }
        Iterator iterator = this.comparatorChain.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Comparator comparator = (Comparator)iterator.next();
            int n2 = comparator.compare(object, object2);
            if (n2 != 0) {
                if (this.orderingBits.get(n)) {
                    n2 *= -1;
                }
                return n2;
            }
            ++n;
        }
        return 0;
    }
}

