/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.MainClassChooser;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class Utils {
    private static final Logger UI_LOGGER = Logger.getLogger("org.netbeans.ui.j2ee.clientproject");
    private static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.j2ee.clientproject");
    private static final String WIZARD_PANEL_CONTENT_DATA = "WizardPanel_contentData";
    private static final String WIZARD_PANEL_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";

    private Utils() {
    }

    private static void setSteps(WizardDescriptor.Panel[] panelArray, String[] stringArray, String[] stringArray2, int n) {
        int n2 = stringArray == null ? 0 : stringArray.length;
        for (int i = 0; i < panelArray.length; ++i) {
            String string;
            JComponent jComponent = (JComponent)panelArray[i].getComponent();
            String string2 = string = i < n2 ? stringArray[i] : null;
            if (string == null) {
                string = jComponent.getName();
            }
            jComponent.putClientProperty(WIZARD_PANEL_CONTENT_DATA, stringArray2);
            jComponent.putClientProperty(WIZARD_PANEL_CONTENT_SELECTED_INDEX, i);
            jComponent.getAccessibleContext().setAccessibleDescription(string);
            stringArray2[i + n] = string;
        }
    }

    public static void setSteps(WizardDescriptor.Panel[] panelArray, String[] stringArray) {
        Utils.setSteps(panelArray, stringArray, stringArray, 0);
    }

    public static void logUI(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        Parameters.notNull((CharSequence)"message", (Object)string);
        Parameters.notNull((CharSequence)"bundle", (Object)resourceBundle);
        LogRecord logRecord = new LogRecord(Level.INFO, string);
        logRecord.setLoggerName(UI_LOGGER.getName());
        logRecord.setResourceBundle(resourceBundle);
        if (objectArray != null) {
            logRecord.setParameters(objectArray);
        }
        UI_LOGGER.log(logRecord);
    }

    public static void logUsage(Class clazz, String string, Object[] objectArray) {
        Parameters.notNull((CharSequence)"message", (Object)string);
        LogRecord logRecord = new LogRecord(Level.INFO, string);
        logRecord.setLoggerName(USG_LOGGER.getName());
        logRecord.setResourceBundle(NbBundle.getBundle((Class)clazz));
        logRecord.setResourceBundleName(clazz.getPackage().getName() + ".Bundle");
        if (objectArray != null) {
            logRecord.setParameters(objectArray);
        }
        USG_LOGGER.log(logRecord);
    }

    public static boolean hasMainMethod(FileObject fileObject) {
        if (MainClassChooser.unitTestingSupport_hasMainMethodResult != null) {
            return MainClassChooser.unitTestingSupport_hasMainMethodResult;
        }
        if (fileObject == null) {
            return false;
        }
        return !SourceUtils.getMainClasses((FileObject)fileObject).isEmpty();
    }

    public static boolean isMainClass(String string, ClassPath classPath, ClassPath classPath2, ClassPath classPath3) {
        ClasspathInfo classpathInfo = ClasspathInfo.create((ClassPath)classPath, (ClassPath)classPath2, (ClassPath)classPath3);
        return SourceUtils.isMainClass((String)string, (ClasspathInfo)classpathInfo);
    }

    public static URL getRootURL(File file, String string) throws MalformedURLException {
        URL uRL = file.toURI().toURL();
        if (FileUtil.isArchiveFile((URL)uRL)) {
            uRL = FileUtil.getArchiveRoot((URL)uRL);
        } else if (!file.exists()) {
            uRL = new URL(uRL.toExternalForm() + "/");
        }
        if (string != null) {
            assert (string.endsWith("/"));
            uRL = new URL(uRL.toExternalForm() + string);
        }
        return uRL;
    }

    public static JavaPlatform getActivePlatform(String string) {
        JavaPlatformManager javaPlatformManager = JavaPlatformManager.getDefault();
        if (string == null) {
            return javaPlatformManager.getDefaultPlatform();
        }
        JavaPlatform[] javaPlatformArray = javaPlatformManager.getPlatforms(null, new Specification("j2se", null));
        for (int i = 0; i < javaPlatformArray.length; ++i) {
            String string2 = (String)javaPlatformArray[i].getProperties().get("platform.ant.name");
            if (string2 == null || !string2.equals(string)) continue;
            return javaPlatformArray[i];
        }
        return null;
    }
}

