/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Constants;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Pair;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.type.DeclaredType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Attribute
implements AnnotationValue {
    public Type type;

    public Attribute(Type type) {
        this.type = type;
    }

    public abstract void accept(Visitor var1);

    @Override
    public Object getValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
        throw new UnsupportedOperationException();
    }

    public static interface Visitor {
        public void visitConstant(Constant var1);

        public void visitClass(Class var1);

        public void visitCompound(Compound var1);

        public void visitArray(Array var1);

        public void visitEnum(Enum var1);

        public void visitError(Error var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Error
    extends Attribute {
        public Error(Type type) {
            super(type);
        }

        @Override
        public void accept(Visitor v) {
            v.visitError(this);
        }

        @Override
        public String toString() {
            return "<error>";
        }

        @Override
        public String getValue() {
            return this.toString();
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
            return v.visitString(this.toString(), p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Enum
    extends Attribute {
        public Symbol.VarSymbol value;

        public Enum(Type type, Symbol.VarSymbol value) {
            super(type);
            assert (value != null);
            this.value = value;
        }

        @Override
        public void accept(Visitor v) {
            v.visitEnum(this);
        }

        @Override
        public String toString() {
            return this.value.enclClass() + "." + this.value;
        }

        @Override
        public Symbol.VarSymbol getValue() {
            return this.value;
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
            return v.visitEnumConstant(this.value, p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Array
    extends Attribute {
        public final Attribute[] values;

        public Array(Type type, Attribute[] values) {
            super(type);
            this.values = values;
        }

        @Override
        public void accept(Visitor v) {
            v.visitArray(this);
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append('{');
            boolean first = true;
            for (Attribute value : this.values) {
                if (!first) {
                    buf.append(", ");
                }
                first = false;
                buf.append(value);
            }
            buf.append('}');
            return buf.toString();
        }

        @Override
        public List<Attribute> getValue() {
            return List.from(this.values);
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
            return v.visitArray((java.util.List<AnnotationValue>)this.getValue(), p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeCompound
    extends Compound {
        public TypeAnnotationPosition position;

        public TypeCompound(Compound compound, TypeAnnotationPosition position) {
            this(compound.type, compound.values, position);
        }

        public TypeCompound(Type type, List<Pair<Symbol.MethodSymbol, Attribute>> values, TypeAnnotationPosition position) {
            super(type, values);
            this.position = position;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Compound
    extends Attribute
    implements AnnotationMirror {
        public final List<Pair<Symbol.MethodSymbol, Attribute>> values;

        public Compound(Type type, List<Pair<Symbol.MethodSymbol, Attribute>> values) {
            super(type);
            this.values = values;
        }

        @Override
        public void accept(Visitor v) {
            v.visitCompound(this);
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("@");
            buf.append(this.type);
            int len = this.values.length();
            if (len > 0) {
                buf.append('(');
                boolean first = true;
                for (Pair<Symbol.MethodSymbol, Attribute> value : this.values) {
                    if (!first) {
                        buf.append(", ");
                    }
                    first = false;
                    Name name = ((Symbol.MethodSymbol)value.fst).name;
                    if (len > 1 || name != name.table.names.value) {
                        buf.append(name);
                        buf.append('=');
                    }
                    buf.append(value.snd);
                }
                buf.append(')');
            }
            return buf.toString();
        }

        public Attribute member(Name member) {
            for (Pair<Symbol.MethodSymbol, Attribute> pair : this.values) {
                if (((Symbol.MethodSymbol)pair.fst).name != member) continue;
                return (Attribute)pair.snd;
            }
            return null;
        }

        @Override
        public Compound getValue() {
            return this;
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
            return v.visitAnnotation(this, p);
        }

        @Override
        public DeclaredType getAnnotationType() {
            return (DeclaredType)((Object)this.type);
        }

        public Map<Symbol.MethodSymbol, Attribute> getElementValues() {
            LinkedHashMap<Symbol.MethodSymbol, Attribute> valmap = new LinkedHashMap<Symbol.MethodSymbol, Attribute>();
            for (Pair<Symbol.MethodSymbol, Attribute> value : this.values) {
                valmap.put((Symbol.MethodSymbol)value.fst, (Attribute)value.snd);
            }
            return valmap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Class
    extends Attribute {
        public final Type type;

        @Override
        public void accept(Visitor v) {
            v.visitClass(this);
        }

        public Class(Types types, Type type) {
            super(Class.makeClassType(types, type));
            this.type = type;
        }

        static Type makeClassType(Types types, Type type) {
            Type arg = type.isPrimitive() ? types.boxedClass((Type)type).type : types.erasure(type);
            return new Type.ClassType(types.syms.classType.getEnclosingType(), List.of(arg), types.syms.classType.tsym);
        }

        @Override
        public String toString() {
            return this.type + ".class";
        }

        @Override
        public Type getValue() {
            return this.type;
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
            return v.visitType(this.type, p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Constant
    extends Attribute {
        public final Object value;

        @Override
        public void accept(Visitor v) {
            v.visitConstant(this);
        }

        public Constant(Type type, Object value) {
            super(type);
            this.value = value;
        }

        @Override
        public String toString() {
            return Constants.format(this.value, this.type);
        }

        @Override
        public Object getValue() {
            return Constants.decode(this.value, this.type);
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> v, P p) {
            if (this.value instanceof String) {
                return v.visitString((String)this.value, p);
            }
            if (this.value instanceof Integer) {
                int i = (Integer)this.value;
                switch (this.type.tag) {
                    case 8: {
                        return v.visitBoolean(i != 0, p);
                    }
                    case 2: {
                        return v.visitChar((char)i, p);
                    }
                    case 1: {
                        return v.visitByte((byte)i, p);
                    }
                    case 3: {
                        return v.visitShort((short)i, p);
                    }
                    case 4: {
                        return v.visitInt(i, p);
                    }
                }
            }
            switch (this.type.tag) {
                case 5: {
                    return v.visitLong((Long)this.value, p);
                }
                case 6: {
                    return v.visitFloat(((Float)this.value).floatValue(), p);
                }
                case 7: {
                    return v.visitDouble((Double)this.value, p);
                }
            }
            throw new AssertionError((Object)("Bad annotation element value: " + this.value));
        }
    }
}

