/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.netbeans.modules.cnd.debugger.gdb.GdbCallStackFrame;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

public class CallStackTreeModel
implements TreeModel {
    private final GdbDebugger debugger;
    private final Collection<ModelListener> listeners = new HashSet<ModelListener>();
    private Listener listener;

    public CallStackTreeModel(ContextProvider lookupProvider) {
        this.debugger = (GdbDebugger)lookupProvider.lookupFirst(null, GdbDebugger.class);
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent.equals("Root")) {
            List<GdbCallStackFrame> stack = this.debugger.getCallStack();
            return stack.toArray(new GdbCallStackFrame[stack.size()]);
        }
        throw new UnknownTypeException(parent);
    }

    public int getChildrenCount(Object parent) throws UnknownTypeException {
        if (parent.equals("Root")) {
            return Integer.MAX_VALUE;
        }
        throw new UnknownTypeException(parent);
    }

    public Object getRoot() {
        return "Root";
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node.equals("Root")) {
            return false;
        }
        if (node instanceof GdbCallStackFrame) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        Collection<ModelListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(l);
            if (this.listener == null) {
                this.listener = new Listener(this, this.debugger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        Collection<ModelListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(l);
            if (this.listeners.isEmpty()) {
                this.listener.destroy();
                this.listener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTreeChanged() {
        Object[] ls;
        Collection<ModelListener> collection = this.listeners;
        synchronized (collection) {
            ls = this.listeners.toArray();
        }
        ModelEvent.TreeChanged ev = new ModelEvent.TreeChanged((Object)this);
        for (int i = 0; i < ls.length; ++i) {
            ((ModelListener)ls[i]).modelChanged((ModelEvent)ev);
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private final GdbDebugger debugger;
        private final WeakReference<CallStackTreeModel> model;
        private RequestProcessor.Task task;

        public Listener(CallStackTreeModel tm, GdbDebugger debugger) {
            this.debugger = debugger;
            this.model = new WeakReference<CallStackTreeModel>(tm);
            debugger.addPropertyChangeListener(this);
        }

        private CallStackTreeModel getModel() {
            CallStackTreeModel tm = (CallStackTreeModel)this.model.get();
            if (tm == null) {
                this.destroy();
            }
            return tm;
        }

        void destroy() {
            this.debugger.removePropertyChangeListener(this);
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("state") && this.debugger.isStopped()) {
                Listener listener = this;
                synchronized (listener) {
                    if (this.task == null) {
                        this.task = this.debugger.getRequestProcessor().create((Runnable)new Refresher());
                    }
                    this.task.schedule(200);
                }
            }
        }

        private class Refresher
        implements Runnable {
            private Refresher() {
            }

            @Override
            public void run() {
                CallStackTreeModel tm;
                if (Listener.this.debugger.isStopped() && (tm = Listener.this.getModel()) != null) {
                    tm.fireTreeChanged();
                }
            }
        }
    }
}

