/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.profiles;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ui.BuildToolsAction;
import org.netbeans.modules.cnd.api.toolchain.ui.LocalToolsPanelModel;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsPanelModel;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.profiles.GdbProfileXMLCodec;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.spi.toolchain.CompilerSetFactory;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.Path;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class GdbProfile
implements ConfigurationAuxObject {
    public static final String GDB_PROFILE_ID = "gdbdebugger";
    public static final String PROP_GDB_COMMAND = "gdb_command";
    public static final String PROP_ARRAY_REPEAT_THRESHOLD = "array_repeat_threshold";
    private PropertyChangeSupport pcs = null;
    private boolean needSave = false;
    private String gdb_command = "";

    public GdbProfile() {
        this.initialize();
    }

    protected GdbProfile(PropertyChangeSupport pcs) {
        this.pcs = pcs;
        this.initialize();
    }

    public void initialize() {
        if (this.gdb_command == null && GdbDebugger.isUnitTest()) {
            this.gdb_command = "gdb";
        }
    }

    public boolean shared() {
        return false;
    }

    public String getId() {
        return GDB_PROFILE_ID;
    }

    public String getGdbCommand() {
        return this.gdb_command;
    }

    public void setGdbCommand(String gdb_command) {
        int l = gdb_command.length();
        boolean b = this.gdb_command.equals(gdb_command);
        if (gdb_command.length() > 0 && !this.gdb_command.equals(gdb_command)) {
            if (this.pcs != null) {
                this.pcs.firePropertyChange(PROP_GDB_COMMAND, this.gdb_command, gdb_command);
            }
            this.gdb_command = gdb_command;
        }
    }

    public String getGdbPath(MakeConfiguration conf, boolean canAskUser) {
        CompilerSet cs;
        String csname;
        CompilerSet2Configuration csconf = conf.getCompilerSet();
        if (csconf.isValid()) {
            csname = csconf.getOption();
            cs = CompilerSetManager.get((ExecutionEnvironment)conf.getDevelopmentHost().getExecutionEnvironment()).getCompilerSet(csname);
        } else {
            int platform;
            csname = csconf.getOldName();
            CompilerFlavor flavor = CompilerFlavor.toFlavor((String)csname, (int)(platform = conf.getPlatformInfo().getPlatform()));
            flavor = flavor == null ? CompilerFlavor.getUnknown((int)platform) : flavor;
            cs = CompilerSetFactory.getCompilerSet((ExecutionEnvironment)conf.getDevelopmentHost().getExecutionEnvironment(), (CompilerFlavor)flavor, (String)csname);
            csconf.setValid();
        }
        Tool debuggerTool = cs.getTool((ToolKind)PredefinedToolKind.DebuggerTool);
        ExecutionEnvironment execEnv = null;
        if (debuggerTool != null) {
            String gdbPath = debuggerTool.getPath();
            execEnv = conf.getDevelopmentHost().getExecutionEnvironment();
            if (execEnv.isLocal()) {
                File gdbFile = new File(gdbPath);
                if (gdbFile.exists() && !gdbFile.isDirectory()) {
                    return gdbPath;
                }
                String fromUsersPath = Path.findCommand((String)gdbPath);
                if (fromUsersPath != null) {
                    return fromUsersPath;
                }
            } else if (ServerList.isValidExecutable((ExecutionEnvironment)execEnv, (String)gdbPath)) {
                return gdbPath;
            }
        }
        if (canAskUser) {
            LocalToolsPanelModel model = new LocalToolsPanelModel();
            model.setCRequired(false);
            model.setCppRequired(false);
            model.setFortranRequired(false);
            model.setMakeRequired(false);
            model.setDebuggerRequired(true);
            model.setShowRequiredBuildTools(false);
            model.setShowRequiredDebugTools(true);
            model.setCompilerSetName(null);
            model.setSelectedCompilerSetName(csname);
            model.setSelectedDevelopmentHost(execEnv);
            model.setEnableDevelopmentHostChange(false);
            BuildToolsAction bt = (BuildToolsAction)SystemAction.get(BuildToolsAction.class);
            bt.setTitle(NbBundle.getMessage(GdbProfile.class, (String)"LBL_ResolveMissingGdb_Title"));
            if (bt.initBuildTools((ToolsPanelModel)model, new ArrayList(), cs)) {
                conf.getCompilerSet().setValue(model.getSelectedCompilerSetName());
                cs = CompilerSetManager.get((ExecutionEnvironment)conf.getDevelopmentHost().getExecutionEnvironment()).getCompilerSet(model.getSelectedCompilerSetName());
                return cs.getTool((ToolKind)PredefinedToolKind.DebuggerTool).getPath();
            }
        }
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.pcs != null) {
            this.pcs.addPropertyChangeListener(l);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(l);
        }
    }

    public XMLDecoder getXMLDecoder() {
        return new GdbProfileXMLCodec(this);
    }

    public XMLEncoder getXMLEncoder() {
        return new GdbProfileXMLCodec(this);
    }

    public boolean hasChanged() {
        return this.needSave;
    }

    public void clearChanged() {
        this.needSave = false;
    }

    public void assign(ConfigurationAuxObject profileAuxObject) {
        assert (profileAuxObject instanceof GdbProfile);
        GdbProfile that = (GdbProfile)profileAuxObject;
        this.setGdbCommand(that.getGdbCommand());
    }

    public GdbProfile clone(Configuration conf) {
        GdbProfile p = new GdbProfile();
        p.setGdbCommand(this.getGdbCommand());
        return p;
    }

    public Sheet getSheet() {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("General");
        set.setDisplayName(NbBundle.getMessage(GdbProfile.class, (String)"LBL_GENERAL"));
        set.setShortDescription(NbBundle.getMessage(GdbProfile.class, (String)"HINT_GENERAL"));
        set.put((Node.Property)new GdbCommandNodeProp());
        sheet.put(set);
        return sheet;
    }

    private class GdbCommandNodeProp
    extends PropertySupport<String> {
        public GdbCommandNodeProp() {
            super(GdbProfile.PROP_GDB_COMMAND, String.class, NbBundle.getMessage(GdbProfile.class, (String)"LBL_GDB_COMMAND"), NbBundle.getMessage(GdbProfile.class, (String)"HINT_GDB_COMMAND"), true, false);
        }

        public String getValue() {
            return GdbProfile.this.getGdbCommand();
        }

        public void setValue(String v) {
            GdbProfile.this.setGdbCommand(v);
        }
    }
}

