/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.timer;

public class TimerRecord {
    private final RecordType type;
    private final long time;
    private final String message;

    public TimerRecord(RecordType type, String message) {
        this.type = type;
        this.time = System.currentTimeMillis();
        this.message = message != null && message.length() > 0 ? message + ": " : "";
    }

    public long getTime() {
        return this.time;
    }

    public String toString() {
        return this.toString(-1L);
    }

    public String toString(long relativeTo) {
        StringBuilder s = new StringBuilder();
        if (this.type == RecordType.Title) {
            s.append("\n\nGdbTimer Report: " + this.message);
        } else {
            s.append("    ");
            s.append(this.message);
            if (this.type == RecordType.Start) {
                s.append("Started at ");
            } else if (this.type == RecordType.Mark) {
                s.append("Marked at ");
            } else if (this.type == RecordType.Stop) {
                s.append("Stopped at ");
            } else if (this.type == RecordType.Restart) {
                s.append("Restarteded at ");
            }
            if (relativeTo < 0L) {
                s.append(this.time);
            } else {
                s.append(this.time - relativeTo);
                s.append(" ms");
            }
        }
        return s.toString();
    }

    static enum RecordType {
        Title,
        Start,
        Mark,
        Stop,
        Restart;

    }
}

