/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform.customwizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.modules.mobility.cldcplatform.customwizard.WizardPanel;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.NbBundle;

public class CommandLinesPanel
extends JPanel
implements WizardPanel.ComponentDescriptor {
    protected WizardPanel wizardPanel;
    private static final Set<Character> INVALID_CHARACTERS = new HashSet<Character>();
    private JButton browseButton;
    private JTextField debuggerCommand;
    private JTextField deviceName;
    private JTextField executionCommand;
    private JTextPane infoPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JTextField platformHome;
    private JTextField platformName;
    private JTextField preverifyCommand;

    public CommandLinesPanel() {
        JavaPlatform[] foundPlatforms;
        for (char c : "\\^$?*+-!.;:,=<>|/\"'[]{}()".toCharArray()) {
            INVALID_CHARACTERS.add(Character.valueOf(c));
        }
        this.initComponents();
        this.infoPanel.setEditorKit(new HTMLEditorKit());
        int i = 1;
        String platformNameString = NbBundle.getMessage(CommandLinesPanel.class, (String)"Preset_CmdLinesPanel_Custom_Platform");
        while ((foundPlatforms = JavaPlatformManager.getDefault().getPlatforms(platformNameString + i, null)) != null && foundPlatforms.length > 0) {
            ++i;
        }
        this.platformName.setText(platformNameString + i);
        this.deviceName.setText(NbBundle.getMessage(CommandLinesPanel.class, (String)"Preset_CmdLinesPanel_Custom_Device"));
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                CommandLinesPanel.this.wizardPanel.fireChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                CommandLinesPanel.this.wizardPanel.fireChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CommandLinesPanel.this.wizardPanel.fireChanged();
            }
        };
        this.platformHome.getDocument().addDocumentListener(documentListener);
        this.platformName.getDocument().addDocumentListener(documentListener);
        this.deviceName.getDocument().addDocumentListener(documentListener);
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Component component = e.getComponent();
                URL descURL = null;
                try {
                    if (component == CommandLinesPanel.this.preverifyCommand) {
                        descURL = new URL("nbresloc:/org/netbeans/modules/mobility/cldcplatform/customwizard/preverifyinfo.html");
                    } else if (component == CommandLinesPanel.this.executionCommand) {
                        descURL = new URL("nbresloc:/org/netbeans/modules/mobility/cldcplatform/customwizard/executioninfo.html");
                    } else if (component == CommandLinesPanel.this.debuggerCommand) {
                        descURL = new URL("nbresloc:/org/netbeans/modules/mobility/cldcplatform/customwizard/debuggerinfo.html");
                    }
                }
                catch (MalformedURLException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
                if (descURL != null) {
                    try {
                        String charset = CommandLinesPanel.findEncodingFromURL(descURL.openStream());
                        ErrorManager.getDefault().log(1, "Url " + descURL + " has charset " + charset);
                        if (charset != null) {
                            CommandLinesPanel.this.infoPanel.putClientProperty("charset", charset);
                        }
                        CommandLinesPanel.this.infoPanel.read(descURL.openStream(), (Object)descURL);
                    }
                    catch (ChangedCharSetException x) {
                        Document doc = CommandLinesPanel.this.infoPanel.getEditorKit().createDefaultDocument();
                        doc.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
                        try {
                            CommandLinesPanel.this.infoPanel.read(descURL.openStream(), (Object)doc);
                        }
                        catch (IOException ioe) {
                            ErrorManager.getDefault().notify(1, (Throwable)ioe);
                            CommandLinesPanel.this.infoPanel.setText(NbBundle.getBundle(CommandLinesPanel.class).getString("TXT_NoDescription"));
                        }
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                        CommandLinesPanel.this.infoPanel.setText(NbBundle.getBundle(CommandLinesPanel.class).getString("TXT_NoDescription"));
                    }
                } else {
                    CommandLinesPanel.this.infoPanel.setText(NbBundle.getBundle(CommandLinesPanel.class).getString("TXT_NoDescription"));
                }
                CommandLinesPanel.this.infoPanel.setCaretPosition(0);
            }

            @Override
            public void focusLost(FocusEvent e) {
                Component oppositeComponent = e.getOppositeComponent();
                if (oppositeComponent != null && oppositeComponent != CommandLinesPanel.this.preverifyCommand && oppositeComponent != CommandLinesPanel.this.executionCommand && oppositeComponent != CommandLinesPanel.this.debuggerCommand && oppositeComponent != CommandLinesPanel.this.infoPanel) {
                    CommandLinesPanel.this.infoPanel.setText("");
                }
            }
        };
        this.preverifyCommand.addFocusListener(focusListener);
        this.executionCommand.addFocusListener(focusListener);
        this.debuggerCommand.addFocusListener(focusListener);
        FocusListener selectAllFocusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ((JTextField)e.getComponent()).selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
        FocusListener zeroCaretPositionFocusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ((JTextField)e.getComponent()).setCaretPosition(0);
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
        this.platformHome.addFocusListener(selectAllFocusListener);
        this.platformName.addFocusListener(selectAllFocusListener);
        this.deviceName.addFocusListener(selectAllFocusListener);
        this.preverifyCommand.addFocusListener(zeroCaretPositionFocusListener);
        this.executionCommand.addFocusListener(zeroCaretPositionFocusListener);
        this.debuggerCommand.addFocusListener(zeroCaretPositionFocusListener);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.platformHome = new JTextField();
        this.browseButton = new JButton();
        this.jLabel2 = new JLabel();
        this.platformName = new JTextField();
        this.jLabel3 = new JLabel();
        this.deviceName = new JTextField();
        this.jLabel4 = new JLabel();
        this.preverifyCommand = new JTextField();
        this.jLabel5 = new JLabel();
        this.executionCommand = new JTextField();
        this.jLabel6 = new JLabel();
        this.debuggerCommand = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.infoPanel = new JTextPane();
        this.setName(NbBundle.getMessage(CommandLinesPanel.class, (String)"LBL_CmdLinesPanel_General_Information"));
        this.setPreferredSize(new Dimension(600, 400));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CommandLinesPanel.class, (String)"LBL_CmdLinePanel_Platform_Home"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommandLinesPanel.class, (String)"ACSD_CmdLinePanel_Platform_Home"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommandLinesPanel.class, (String)"ACSD_CmdLinePanel_Platform_Home"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.platformHome, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(CommandLinesPanel.class, (String)"LBL_CmdLinesPanel_Browse"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommandLinesPanel.this.browseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommandLinesPanel.class, (String)"ACSD_CmdLinesPanel_Browse"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommandLinesPanel.class, (String)"ACSD_CmdLinesPanel_Browse"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(CommandLinesPanel.class, (String)"LBL_CmdLinesPanel_Platform_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 6);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommandLinesPanel.class, (String)"ACSD_CmdLinesPanel_Platform_Name"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommandLinesPanel.class, (String)"ACSD_CmdLinesPanel_Platform_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.platformName, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(CommandLinesPanel.class, (String)"LBL_CmdLinesPanel_Device_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 6);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommandLinesPanel.class, (String)"ACSD_CmdLinesPanel_Device_Name"));
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommandLinesPanel.class, (String)"ACSD_CmdLinesPanel_Device_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.deviceName, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(CommandLinesPanel.class, (String)"LBL_CmdLinesPanel_Preverify_Command"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 6);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel4.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommandLinesPanel.class, (String)"ACSD_CmdLinesPanel_Preverify_Command"));
        this.jLabel4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommandLinesPanel.class, (String)"ACSD_CmdLinesPanel_Preverify_Command"));
        this.preverifyCommand.setText("\"{platformhome}{/}bin{/}preverify\" {classpath|-classpath \"{classpath}\"} -d \"{destdir}\" \"{srcdir}\"");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.preverifyCommand, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(CommandLinesPanel.class, (String)"LBL_CmdLinesPanel_Execution_Command"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 6);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel5.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommandLinesPanel.class, (String)"ACSD_CmdLinesPanel_Execution_Command"));
        this.jLabel5.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommandLinesPanel.class, (String)"ACSD_CmdLinesPanel_Execution_Command"));
        this.executionCommand.setText("\"{platformhome}{/}bin{/}emulator\" {device|-Xdevice:\"{device}\"} {jadfile|-Xdescriptor:\"{jadfile}\"} {securitydomain|-Xdomain:{securitydomain}} {cmdoptions}");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.executionCommand, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(CommandLinesPanel.class, (String)"LBL_CmdLinesPanel_Debugger_Command"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 6);
        this.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel6.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommandLinesPanel.class, (String)"ACSD_CmdLinesPanel_Debugger_Command"));
        this.jLabel6.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommandLinesPanel.class, (String)"ACSD_CmdLinesPanel_Debugger_Command"));
        this.debuggerCommand.setText("\"{platformhome}{/}bin{/}emulator\" {device|-Xdevice:\"{device}\"} {jadfile|-Xdescriptor:\"{jadfile}\"} {securitydomain|-Xdomain:{securitydomain}} {debug|-Xdebug -Xrunjdwp:transport={debugtransport},server={debugserver},suspend={debugsuspend},address={debugaddress}} {cmdoptions}");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.debuggerCommand, gridBagConstraints);
        this.infoPanel.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.infoPanel.setEditable(false);
        this.jScrollPane1.setViewportView(this.infoPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        String value = this.browseFolder(NbBundle.getMessage(CommandLinesPanel.class, (String)"TITLE_CommandLinesPanel_BrowseHome"));
        if (value == null) {
            return;
        }
        this.platformHome.setText(value);
    }

    @Override
    public void setWizardPanel(WizardPanel wizardPanel) {
        this.wizardPanel = wizardPanel;
    }

    @Override
    public void readSettings(WizardDescriptor wizardDescriptor) {
        J2MEPlatform platform = (J2MEPlatform)((Object)wizardDescriptor.getProperty("Platform"));
        if (platform == null) {
            return;
        }
        this.platformHome.setText(platform.getHomePath());
        this.platformName.setText(platform.getDisplayName());
        this.deviceName.setText(platform.getDevices()[0].getName());
        this.preverifyCommand.setText(platform.getPreverifyCmd());
        this.executionCommand.setText(platform.getRunCmd());
        this.debuggerCommand.setText(platform.getDebugCmd());
    }

    @Override
    public void storeSettings(WizardDescriptor wizardDescriptor) {
        J2MEPlatform platform = new J2MEPlatform(J2MEPlatform.computeUniqueName(this.platformName.getText()), this.platformHome.getText(), "CUSTOM", this.platformName.getText(), null, null, this.preverifyCommand.getText(), this.executionCommand.getText(), this.debuggerCommand.getText(), new J2MEPlatform.Device[]{new J2MEPlatform.Device(this.deviceName.getText(), null, null, new J2MEPlatform.J2MEProfile[0], null)});
        wizardDescriptor.putProperty("Platform", (Object)platform);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public boolean isPanelValid() {
        String message = null;
        JavaPlatform[] foundPlatforms = JavaPlatformManager.getDefault().getPlatforms(this.platformName.getText(), null);
        if (foundPlatforms != null && foundPlatforms.length > 0) {
            message = "ERR_PlatformExists";
        }
        if (this.deviceName.getText().length() <= 0) {
            message = "ERR_EnterDeviceName";
        }
        if (this.platformName.getText().length() <= 0) {
            message = "ERR_EnterPlatformName";
        }
        for (char c : this.platformName.getText().toCharArray()) {
            if (!INVALID_CHARACTERS.contains(Character.valueOf(c))) continue;
            message = "ERR_InvalidPlatformName";
        }
        for (char c : this.deviceName.getText().toCharArray()) {
            if (!INVALID_CHARACTERS.contains(Character.valueOf(c))) continue;
            message = "ERR_InvalidDeviceName";
        }
        String platformHomeString = this.platformHome.getText();
        if (platformHomeString == null || !new File(platformHomeString).isDirectory()) {
            message = "ERR_InvalidPlatformHome";
        }
        this.wizardPanel.setErrorMessage(CommandLinesPanel.class, message);
        return message == null;
    }

    @Override
    public boolean isFinishPanel() {
        return false;
    }

    private String browseFolder(String title) {
        File f = new FileChooserBuilder(CommandLinesPanel.class).setTitle(title).setDirectoriesOnly(true).setFileFilter((FileFilter)new FolderFilter()).showOpenDialog();
        if (f != null) {
            return f.getAbsolutePath();
        }
        return null;
    }

    private static String findEncodingFromURL(InputStream stream) {
        try {
            byte[] arr = new byte[4096];
            int len = stream.read(arr, 0, arr.length);
            String txt = new String(arr, 0, len >= 0 ? len : 0).toUpperCase();
            return CommandLinesPanel.findEncoding(txt);
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }

    private static String findEncoding(String txt) {
        int content;
        int headLen = txt.indexOf("</HEAD>");
        if (headLen == -1) {
            headLen = txt.length();
        }
        if ((content = txt.indexOf("CONTENT-TYPE")) == -1 || content > headLen) {
            return null;
        }
        int charset = txt.indexOf("CHARSET=", content);
        if (charset == -1) {
            return null;
        }
        int charend = txt.indexOf(34, charset);
        int charend2 = txt.indexOf(39, charset);
        if (charend == -1 && charend2 == -1) {
            return null;
        }
        if (charend2 != -1 && (charend == -1 || charend > charend2)) {
            charend = charend2;
        }
        return txt.substring(charset + "CHARSET=".length(), charend);
    }

    private static final class FolderFilter
    extends FileFilter {
        private FolderFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.exists() && f.canRead() && f.isDirectory();
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(CommandLinesPanel.class, (String)"TXT_FolderFilter");
        }
    }
}

