/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.SideBarFactory;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstNodeUtils;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.html.editor.HtmlCaretAwareSourceTask;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.spi.CursorMovedSchedulerEvent;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

public class NavigationSideBar
extends JPanel
implements Accessible {
    private JTextComponent component;
    private volatile AttributeSet attribs;
    private Lookup.Result<? extends FontColorSettings> fcsLookupResult;
    private final FileObject fileObject;
    private final Document doc;
    private final LookupListener fcsTracker = new LookupListener(){

        public void resultChanged(LookupEvent ev) {
            NavigationSideBar.this.attribs = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NavigationSideBar.this.repaint();
                }
            });
        }
    };
    private boolean enabled = true;
    private List<AstNode> nesting = new ArrayList<AstNode>(5);

    public NavigationSideBar() {
        this.doc = null;
        this.fileObject = null;
    }

    public NavigationSideBar(JTextComponent component) {
        this.setLayout(new FlowLayout(0, 14, 0));
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.component = component;
        this.doc = component.getDocument();
        this.fileObject = DataLoadersBridge.getDefault().getFileObject(this.doc);
        HtmlCaretAwareSourceTask.Source source = HtmlCaretAwareSourceTask.forDocument(this.doc);
        source.addChangeListener(new HtmlCaretAwareSourceTask.SourceListener(){

            @Override
            public void parsed(Parser.Result info, SchedulerEvent event) {
                NavigationSideBar.this.change(info, event);
            }
        });
        this.updatePreferredSize();
    }

    private void change(Parser.Result info, SchedulerEvent event) {
        int caretPosition = ((CursorMovedSchedulerEvent)event).getCaretOffset();
        AstNode root = ((HtmlParserResult)info).root();
        AstNode current = AstNodeUtils.findDescendant((AstNode)root, (int)info.getSnapshot().getEmbeddedOffset(caretPosition));
        if (current == null) {
            return;
        }
        this.updateNestingInfo(info, root, current);
    }

    private void updateNestingInfo(final Parser.Result tsource, AstNode root, AstNode node) {
        ArrayList<AstNode> newNesting = new ArrayList<AstNode>();
        do {
            if (node.type() != AstNode.NodeType.OPEN_TAG) continue;
            newNesting.add(0, node);
        } while ((node = node.parent()) != null && node != root);
        this.nesting = newNesting;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NavigationSideBar.this.updatePanelUI(tsource);
            }
        });
    }

    private void updatePanelUI(final Parser.Result tsource) {
        this.removeAll();
        for (final AstNode node : this.nesting) {
            final JLabel label = new JLabel();
            label.setForeground(Color.BLACK);
            label.setFont(new Font("Monospaced", 0, (int)((double)this.getColoring().getFont().getSize() * 0.9)));
            label.setCursor(Cursor.getPredefinedCursor(12));
            label.setText(this.getDrawText(node.name()));
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    label.setForeground(Color.BLUE);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    label.setForeground(Color.BLACK);
                }

                @Override
                public void mouseClicked(MouseEvent evt) {
                    int documentOffset = tsource.getSnapshot().getOriginalOffset(node.startOffset());
                    NavigationSideBar.this.component.getCaret().setDot(documentOffset);
                }
            });
            this.add(label);
        }
        this.revalidate();
        this.repaint();
    }

    private String getDrawText(String tagName) {
        return tagName;
    }

    private void updatePreferredSize() {
        if (this.enabled) {
            this.setPreferredSize(new Dimension(this.component.getWidth(), this.getColoring().getFont().getSize() + 4));
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        } else {
            this.setPreferredSize(new Dimension(0, 0));
            this.setMaximumSize(new Dimension(0, 0));
        }
        this.revalidate();
    }

    private Coloring getColoring() {
        if (this.attribs == null) {
            if (this.fcsLookupResult == null) {
                this.fcsLookupResult = MimeLookup.getLookup((String)DocumentUtilities.getMimeType((JTextComponent)this.component)).lookupResult(FontColorSettings.class);
                this.fcsLookupResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.fcsTracker, this.fcsLookupResult));
            }
            FontColorSettings fcs = (FontColorSettings)this.fcsLookupResult.allInstances().iterator().next();
            this.attribs = AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{this.attribs, fcs.getFontColors("default")});
        }
        return Coloring.fromAttributeSet((AttributeSet)this.attribs);
    }

    public static final class NavigationSideBarFactory
    implements SideBarFactory {
        public JComponent createSideBar(JTextComponent target) {
            return new NavigationSideBar(target);
        }
    }
}

