/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstNodeUtils;
import org.netbeans.editor.ext.html.parser.SyntaxParser;
import org.netbeans.editor.ext.html.parser.SyntaxParserContext;
import org.netbeans.editor.ext.html.parser.SyntaxParserResult;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.gsf.HtmlElementHandle;
import org.netbeans.modules.html.editor.gsf.HtmlParserResultAccessor;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;

public class HtmlGSFParser
extends Parser {
    private HtmlParserResult lastResult;
    private static final Logger TIMERS = Logger.getLogger("TIMER.j2ee.parser");
    private static final Logger LOGGER = Logger.getLogger(HtmlGSFParser.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent event) throws ParseException {
        this.lastResult = this.parse(snapshot, event);
    }

    public Parser.Result getResult(Task task) throws ParseException {
        assert (this.lastResult != null) : "getResult() called prior parse()";
        return this.lastResult;
    }

    public void cancel() {
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private HtmlParserResult parse(Snapshot snapshot, SourceModificationEvent event) {
        boolean embedded = snapshot.getMimePath().size() > 1;
        Document sourceDocument = snapshot.getSource().getDocument(false);
        DTD fallbackDTD = sourceDocument != null ? (DTD)sourceDocument.getProperty("fallbackDTD") : null;
        SyntaxParserContext context = SyntaxParserContext.createContext((CharSequence)snapshot.getText()).setDTD(fallbackDTD);
        if (embedded) {
            context.setProperty(SyntaxParser.Behaviour.DISABLE_STRUCTURE_CHECKS.name(), (Object)Boolean.TRUE);
        }
        SyntaxParserResult spresult = SyntaxParser.parse((SyntaxParserContext)context);
        HtmlParserResult result = HtmlParserResultAccessor.get().createInstance(snapshot, spresult);
        if (TIMERS.isLoggable(Level.FINE)) {
            LogRecord rec = new LogRecord(Level.FINE, "HTML parse result");
            rec.setParameters(new Object[]{result});
            TIMERS.log(rec);
        }
        return result;
    }

    public static ElementHandle resolveHandle(ParserResult info, ElementHandle oldElementHandle) {
        if (oldElementHandle instanceof HtmlElementHandle) {
            HtmlElementHandle element = (HtmlElementHandle)oldElementHandle;
            AstNode oldNode = element.node();
            AstNode oldRoot = AstNodeUtils.getRoot((AstNode)oldNode);
            HtmlParserResult newResult = (HtmlParserResult)info;
            AstNode newRoot = newResult.root();
            if (newRoot == null) {
                return null;
            }
            AstNode newNode = HtmlGSFParser.find(oldRoot, oldNode, newRoot);
            if (newNode != null) {
                return new HtmlElementHandle(newNode, info.getSnapshot().getSource().getFileObject());
            }
        }
        return null;
    }

    private static AstNode find(AstNode oldRoot, AstNode oldObject, AstNode newRoot) {
        if (oldRoot == oldObject) {
            return newRoot;
        }
        List oChildren = oldRoot.children();
        List nChildren = newRoot.children();
        for (int i = 0; i < oChildren.size(); ++i) {
            AstNode oCh = (AstNode)oChildren.get(i);
            if (i == nChildren.size()) {
                return null;
            }
            AstNode nCh = (AstNode)nChildren.get(i);
            if (oCh == oldObject) {
                return nCh;
            }
            AstNode match = HtmlGSFParser.find(oCh, oldObject, nCh);
            if (match == null) continue;
            return match;
        }
        return null;
    }
}

