/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.i18n.I18nUtil;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;

public class HelpStringCustomEditor
extends JPanel {
    private JComboBox combo;
    private JLabel comboLabel;
    private JList list;
    private JLabel listLabel;
    private JScrollPane scrollPane;

    public HelpStringCustomEditor(String value, List items, List helpItems, String comboText, String helpID) {
        this.initComponents();
        this.combo.setModel(new DefaultComboBoxModel<Object>(items.toArray()));
        this.combo.setSelectedItem(value);
        this.list.setListData(helpItems.toArray());
        this.list.setBackground(UIManager.getDefaults().getColor("TextField..disabledBackground"));
        Mnemonics.setLocalizedText((JLabel)this.comboLabel, (String)comboText);
        Mnemonics.setLocalizedText((JLabel)this.listLabel, (String)I18nUtil.getBundle().getString("LBL_Arguments"));
        this.initAccessibility();
        HelpCtx.setHelpIDString((JComponent)this, (String)helpID);
    }

    public Object getPropertyValue() {
        return ((JTextField)this.combo.getEditor().getEditorComponent()).getText();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_HelpStringCustomEditor"));
        this.combo.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_HelpStringCombo"));
        this.list.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_HelpStringList"));
    }

    private void initComponents() {
        this.combo = new JComboBox();
        this.scrollPane = new JScrollPane();
        this.list = new JList();
        this.comboLabel = new JLabel();
        this.listLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.combo.setEditable(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 11);
        this.add((Component)this.combo, gridBagConstraints);
        this.list.setSelectionMode(0);
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                HelpStringCustomEditor.this.listKeyPressed(evt);
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                HelpStringCustomEditor.this.listMouseClicked(evt);
            }
        });
        this.scrollPane.setViewportView(this.list);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 11, 11);
        this.add((Component)this.scrollPane, gridBagConstraints);
        this.comboLabel.setLabelFor(this.combo);
        this.comboLabel.setText("comboLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.comboLabel, gridBagConstraints);
        this.listLabel.setLabelFor(this.list);
        this.listLabel.setText("listLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 12, 0, 11);
        this.add((Component)this.listLabel, gridBagConstraints);
    }

    private void listKeyPressed(KeyEvent evt) {
        String selected = (String)this.list.getSelectedValue();
        if (evt.getKeyCode() == 10 && selected != null) {
            evt.consume();
            this.insertInFormat(selected);
        }
    }

    private void listMouseClicked(MouseEvent evt) {
        String selected = (String)this.list.getSelectedValue();
        if (evt.getClickCount() == 2 && selected != null) {
            this.insertInFormat(selected);
        }
    }

    private void insertInFormat(String selected) {
        int index = selected.indexOf(32);
        if (index < 0 || index > selected.length()) {
            return;
        }
        String replace = selected.substring(0, index);
        JTextField textField = (JTextField)this.combo.getEditor().getEditorComponent();
        try {
            textField.getDocument().insertString(textField.getCaretPosition(), replace, null);
        }
        catch (BadLocationException ble) {
            ErrorManager.getDefault().notify(1, (Throwable)ble);
        }
    }

    private static abstract class StringEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private static boolean useRaw = Boolean.getBoolean("netbeans.stringEditor.useRawCharacters");
        private boolean editable = true;
        private String instructions = null;
        private boolean oneline = false;
        private boolean customEd = true;
        private PropertyEnv env;

        private StringEditor() {
        }

        public boolean isEditable() {
            return this.editable;
        }

        @Override
        public void setAsText(String s) {
            if ("null".equals(s) && this.getValue() == null) {
                return;
            }
            this.setValue(s);
        }

        @Override
        public String getJavaInitializationString() {
            String s = (String)this.getValue();
            return "\"" + StringEditor.toAscii(s) + "\"";
        }

        @Override
        public boolean supportsCustomEditor() {
            return this.customEd;
        }

        @Override
        public abstract Component getCustomEditor();

        private static String toAscii(String str) {
            StringBuffer buf = new StringBuffer(str.length() * 6);
            char[] chars = str.toCharArray();
            block9: for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                switch (c) {
                    case '\b': {
                        buf.append("\\b");
                        continue block9;
                    }
                    case '\t': {
                        buf.append("\\t");
                        continue block9;
                    }
                    case '\n': {
                        buf.append("\\n");
                        continue block9;
                    }
                    case '\f': {
                        buf.append("\\f");
                        continue block9;
                    }
                    case '\r': {
                        buf.append("\\r");
                        continue block9;
                    }
                    case '\"': {
                        buf.append("\\\"");
                        continue block9;
                    }
                    case '\\': {
                        buf.append("\\\\");
                        continue block9;
                    }
                    default: {
                        if (c >= ' ' && (useRaw || c <= '\u007f')) {
                            buf.append(c);
                            continue block9;
                        }
                        buf.append("\\u");
                        String hex = Integer.toHexString(c);
                        for (int j = 0; j < 4 - hex.length(); ++j) {
                            buf.append('0');
                        }
                        buf.append(hex);
                    }
                }
            }
            return buf.toString();
        }

        public void attachEnv(PropertyEnv env) {
            this.env = env;
            FeatureDescriptor desc = env.getFeatureDescriptor();
            if (desc instanceof Node.Property) {
                Node.Property prop = (Node.Property)desc;
                this.editable = prop.canWrite();
                this.instructions = (String)prop.getValue("instructions");
                this.oneline = Boolean.TRUE.equals(prop.getValue("oneline"));
                this.customEd = !Boolean.TRUE.equals(prop.getValue("suppressCustomEditor"));
            }
        }
    }

    public static class I18nRegExpEditor
    extends StringEditor {
        @Override
        public Component getCustomEditor() {
            return new HelpStringCustomEditor((String)this.getValue(), I18nUtil.getI18nRegExpItems(), I18nUtil.getRegExpHelpItems(), I18nUtil.getBundle().getString("LBL_I18nRegExpFormat"), "i18n.pe.testregexp");
        }
    }

    public static class RegExpEditor
    extends StringEditor {
        @Override
        public Component getCustomEditor() {
            return new HelpStringCustomEditor((String)this.getValue(), I18nUtil.getRegExpItems(), I18nUtil.getRegExpHelpItems(), I18nUtil.getBundle().getString("LBL_NonI18nRegExpFormat"), "i18n.pe.i18nregexp");
        }
    }

    public static class ReplaceCodeEditor
    extends StringEditor {
        @Override
        public Component getCustomEditor() {
            return new HelpStringCustomEditor((String)this.getValue(), I18nUtil.getReplaceFormatItems(), I18nUtil.getReplaceHelpItems(), I18nUtil.getBundle().getString("LBL_ReplaceCodeFormat"), "i18n.pe.replacestring");
        }
    }

    public static class InitCodeEditor
    extends StringEditor {
        @Override
        public Component getCustomEditor() {
            return new HelpStringCustomEditor((String)this.getValue(), I18nUtil.getInitFormatItems(), I18nUtil.getInitHelpItems(), I18nUtil.getBundle().getString("LBL_InitCodeFormat"), "i18n.pe.bundlestring");
        }
    }
}

