/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.spi.java.queries.AccessibilityQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class AccessibilityQueryImpl
implements AccessibilityQueryImplementation {
    private final NbModuleProject project;

    public AccessibilityQueryImpl(NbModuleProject project) {
        this.project = project;
    }

    public Boolean isPubliclyAccessible(FileObject pkg) {
        String path;
        FileObject srcdir = this.project.getSourceDirectory();
        if (srcdir != null && (path = FileUtil.getRelativePath((FileObject)srcdir, (FileObject)pkg)) != null) {
            String name = path.replace('/', '.');
            Element config = this.project.getPrimaryConfigurationData();
            Element pubPkgs = XMLUtil.findElement((Element)config, (String)"public-packages", (String)"http://www.netbeans.org/ns/nb-module-project/3");
            if (pubPkgs == null) {
                pubPkgs = XMLUtil.findElement((Element)config, (String)"friend-packages", (String)"http://www.netbeans.org/ns/nb-module-project/3");
            }
            if (pubPkgs != null) {
                for (Element pubPkg : XMLUtil.findSubElements((Element)pubPkgs)) {
                    boolean sub = "subpackages".equals(pubPkg.getLocalName());
                    String pubPkgS = XMLUtil.findText((Node)pubPkg);
                    if (!name.equals(pubPkgS) && (!sub || !name.startsWith(pubPkgS + '.'))) continue;
                    return true;
                }
            } else {
                Util.err.log(16, "Invalid project.xml for " + this.project);
                return null;
            }
        }
        return false;
    }
}

