/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.branding;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.ui.branding.AbstractBrandingPanel;
import org.netbeans.modules.apisupport.project.ui.branding.BasicBrandingModel;
import org.netbeans.modules.apisupport.project.ui.branding.BasicBrandingPanel;
import org.netbeans.modules.apisupport.project.ui.branding.ResourceBundleBrandingPanel;
import org.netbeans.modules.apisupport.project.ui.branding.SplashBrandingPanel;
import org.netbeans.modules.apisupport.project.ui.branding.WindowSystemBrandingPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;

class BrandingEditorPanel
extends JPanel {
    private final Project project;
    private final String title;
    private final BasicBrandingModel model;
    private final AbstractBrandingPanel[] panels;
    private boolean isModified = false;
    private boolean isValid = true;
    private final boolean contextAvailable;
    private DialogDescriptor descriptor;
    private boolean brandingEnabled = true;
    private JLabel lblError;
    private JTabbedPane tabbedPane;

    public BrandingEditorPanel(String title, Project p, BasicBrandingModel model, boolean contextAvailable) {
        this.initComponents();
        this.project = p;
        this.title = title;
        this.contextAvailable = contextAvailable;
        this.model = model;
        for (AbstractBrandingPanel panel : this.panels = new AbstractBrandingPanel[]{new BasicBrandingPanel(model), new SplashBrandingPanel(model), new WindowSystemBrandingPanel(model), new ResourceBundleBrandingPanel(model)}) {
            panel.init(this);
            this.tabbedPane.add(panel.getDisplayName(), panel);
        }
        this.lblError.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/apisupport/project/ui/resources/error.gif", (boolean)true));
        this.lblError.setVisible(false);
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.lblError = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout(0, 5));
        this.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BrandingEditorPanel.class, (String)"ACS_BrandingTabs"));
        this.tabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrandingEditorPanel.class, (String)"ACS_BrandingTabs"));
        this.add((Component)this.lblError, "South");
    }

    Dialog open() {
        this.descriptor = new DialogDescriptor((Object)this, this.title, false, 2, null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BrandingEditorPanel.this.descriptor.getValue() == DialogDescriptor.OK_OPTION) {
                    BrandingEditorPanel.this.doSave();
                }
            }
        });
        Dialog dlg = DialogDisplayer.getDefault().createDialog(this.descriptor);
        dlg.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BrandingEditorPanel.class, (String)"ACS_BrandingCustomizer"));
        dlg.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrandingEditorPanel.class, (String)"ACS_BrandingCustomizer"));
        dlg.setVisible(true);
        dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                BrandingEditorPanel.this.refreshBrandingEnabled();
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
                BrandingEditorPanel.this.refreshBrandingEnabled();
            }
        });
        return dlg;
    }

    void setModified() {
        this.isModified = true;
    }

    boolean isModified() {
        return this.isModified;
    }

    private void doSave() {
        for (AbstractBrandingPanel panel : this.panels) {
            panel.store();
        }
        final SuiteProperties props = this.model.getSuiteProperties();
        if (null != props) {
            try {
                ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    public Void run() throws IOException {
                        props.storeProperties();
                        return null;
                    }
                });
            }
            catch (MutexException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        } else {
            try {
                this.model.store();
            }
            catch (IOException ioE) {
                Exceptions.printStackTrace((Throwable)ioE);
            }
        }
        this.isModified = false;
    }

    void onBrandingValidation() {
        this.isValid = true;
        String errMessage = null;
        for (AbstractBrandingPanel panel : this.panels) {
            this.isValid &= panel.isBrandingValid();
            String msg = panel.getErrorMessage();
            if (null == msg || null != errMessage) continue;
            errMessage = msg;
        }
        this.lblError.setText(errMessage);
        this.lblError.setVisible(!this.isValid);
        if (null != this.descriptor) {
            this.descriptor.setValid(this.isValid && this.brandingEnabled);
        }
    }

    private void refreshBrandingEnabled() {
        SuiteProperties props = this.model.getSuiteProperties();
        if (null != props) {
            props.reloadProperties();
        }
        this.model.brandingEnabledRefresh();
        this.brandingEnabled = this.model.isBrandingEnabled();
        if (null != this.descriptor) {
            this.descriptor.setValid(this.isValid && this.brandingEnabled);
        }
    }
}

