/**
* <h2> <span> Summary </span></h2>
* <p><b>Core Object</b>
* </p><p>A JavaScript reference to a Java package.
* </p>
* <h2> <span> Created by </span></h2>
* <p>A reference to the package name used with the <code>Packages</code> keyword:
* </p>
* <pre style="background:#EEEEEE none repeat scroll 0% 50%;border:1px solid #666666;padding:5px 5px" xml:space="preserve">Packages.<i>JavaPackage</i>
* </pre>
* <p><i>JavaPackage</i> is the name of the object's Java package. If the package is in the <code>java</code>, <code>netscape</code>, or <code>sun</code> packages, the <code>Packages</code> keyword is optional.
* </p>
* <h2> <span> Description </span></h2>
* <p>In Java, a package is a collection of Java classes or other Java packages. For example, the <code>netscape</code> package contains the package <code>netscape.javascript</code>; the <code>netscape.javascript</code> package contains the classes <code>JSObject</code> and <code>JSException</code>.
* </p><p>In JavaScript, a <code>JavaPackage</code> is a reference to a Java package. For example, a reference to <code>netscape</code> is a <code>JavaPackage</code>. <code>netscape.javascript</code> is both a <code>JavaPackage</code> and a property of the <code>netscape</code> JavaPackage.
* </p><p>A <code>JavaClass</code> object is a reference to one of the classes in a package, such as <code>netscape.javascript.JSObject</code>. The <code>JavaPackage</code> and <code>JavaClass</code> hierarchy reflect the Java package and class hierarchy.
* </p><p>Although the packages and classes contained in a <code>JavaPackage</code> are its properties, you cannot use a <code>for...in</code> statement to enumerate them as you can enumerate the properties of other objects.
* </p>
* <h2> <span> Properties </span></h2>
* <p>The properties of a <code>JavaPackage</code> are the <code>JavaClass</code> objects and any other <code>JavaPackage</code> objects it contains.
* </p>
* <h2> <span> Examples </span></h2>
* <p>Suppose the Redwood corporation uses the Java <code>redwood</code> package to contain various Java classes that it implements. The following code creates the <code>JavaPackage</code> red:
* </p>
* <pre style="background:#EEEEEE none repeat scroll 0% 50%;border:1px solid #666666;padding:5px 5px" xml:space="preserve">var red = Packages.redwood;
* </pre>
* <h2> <span> See also </span></h2>
* <p><a href="Core_JavaScript_1.5_Reference:Global_Objects:JavaArray" shape="rect" title="Core JavaScript 1.5 Reference:Global Objects:JavaArray">JavaArray</a>,
* <a href="JavaClass" shape="rect" title="Core JavaScript 1.5 Reference:Global Objects:JavaClass">JavaClass</a>,
* <a href="JavaObject" shape="rect" title="Core JavaScript 1.5 Reference:Global Objects:JavaObject">JavaObject</a>,
* <a href="Packages" shape="rect" title="Core JavaScript 1.5 Reference:Global Objects:Packages">Packages</a>
* </p>
* 
* <ul style="list-style-type:none;font-size:0.9em;text-align:center">
* <li id="f-copyright">Content is available under <a href="http://developer.mozilla.org/en/docs/MDC:Copyrights" shape="rect" title="MDC:Copyrights">these licenses</a>.</li>	  		<li id="f-about"><a href="http://developer.mozilla.org/en/docs/MDC:About" shape="rect" title="MDC:About">About MDC</a></li>	  				</ul>
*/
var JavaPackage = {
  // This is just a stub for a builtin native JavaScript object.
};
/**
* <h2> <span> Summary </span></h2>
* <p><b>Core Object</b>
* </p><p>A JavaScript reference to a Java package.
* </p>
* <h2> <span> Created by </span></h2>
* <p>A reference to the package name used with the <code>Packages</code> keyword:
* </p>
* <pre style="background:#EEEEEE none repeat scroll 0% 50%;border:1px solid #666666;padding:5px 5px" xml:space="preserve">Packages.<i>JavaPackage</i>
* </pre>
* <p><i>JavaPackage</i> is the name of the object's Java package. If the package is in the <code>java</code>, <code>netscape</code>, or <code>sun</code> packages, the <code>Packages</code> keyword is optional.
* </p>
* <h2> <span> Description </span></h2>
* <p>In Java, a package is a collection of Java classes or other Java packages. For example, the <code>netscape</code> package contains the package <code>netscape.javascript</code>; the <code>netscape.javascript</code> package contains the classes <code>JSObject</code> and <code>JSException</code>.
* </p><p>In JavaScript, a <code>JavaPackage</code> is a reference to a Java package. For example, a reference to <code>netscape</code> is a <code>JavaPackage</code>. <code>netscape.javascript</code> is both a <code>JavaPackage</code> and a property of the <code>netscape</code> JavaPackage.
* </p><p>A <code>JavaClass</code> object is a reference to one of the classes in a package, such as <code>netscape.javascript.JSObject</code>. The <code>JavaPackage</code> and <code>JavaClass</code> hierarchy reflect the Java package and class hierarchy.
* </p><p>Although the packages and classes contained in a <code>JavaPackage</code> are its properties, you cannot use a <code>for...in</code> statement to enumerate them as you can enumerate the properties of other objects.
* </p>
* <h2> <span> Properties </span></h2>
* <p>The properties of a <code>JavaPackage</code> are the <code>JavaClass</code> objects and any other <code>JavaPackage</code> objects it contains.
* </p>
* <h2> <span> Examples </span></h2>
* <p>Suppose the Redwood corporation uses the Java <code>redwood</code> package to contain various Java classes that it implements. The following code creates the <code>JavaPackage</code> red:
* </p>
* <pre style="background:#EEEEEE none repeat scroll 0% 50%;border:1px solid #666666;padding:5px 5px" xml:space="preserve">var red = Packages.redwood;
* </pre>
* <h2> <span> See also </span></h2>
* <p><a href="Core_JavaScript_1.5_Reference:Global_Objects:JavaArray" shape="rect" title="Core JavaScript 1.5 Reference:Global Objects:JavaArray">JavaArray</a>,
* <a href="JavaClass" shape="rect" title="Core JavaScript 1.5 Reference:Global Objects:JavaClass">JavaClass</a>,
* <a href="JavaObject" shape="rect" title="Core JavaScript 1.5 Reference:Global Objects:JavaObject">JavaObject</a>,
* <a href="Packages" shape="rect" title="Core JavaScript 1.5 Reference:Global Objects:Packages">Packages</a>
* </p>
* 
* <ul style="list-style-type:none;font-size:0.9em;text-align:center">
* <li id="f-copyright">Content is available under <a href="http://developer.mozilla.org/en/docs/MDC:Copyrights" shape="rect" title="MDC:Copyrights">these licenses</a>.</li>	  		<li id="f-about"><a href="http://developer.mozilla.org/en/docs/MDC:About" shape="rect" title="MDC:About">About MDC</a></li>	  				</ul>
*/
function JavaPackage() {};

