/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.trafo;

import de.escape.quincunx.trafo.Point2D;
import de.escape.quincunx.trafo.Vector2D;

public final class Matrix3D {
    private static final double DEG2RAD = Math.PI / 180;
    public float xx;
    public float xy;
    public float xw;
    public float yx;
    public float yy;
    public float yw;
    public float wx;
    public float wy;
    public float ww;

    public Matrix3D() {
        this.ww = 1.0f;
        this.yy = 1.0f;
        this.xx = 1.0f;
    }

    public Matrix3D(Matrix3D m) {
        this.xx = m.xx;
        this.xy = m.xy;
        this.xw = m.xw;
        this.yx = m.yx;
        this.yy = m.yy;
        this.yw = m.yw;
        this.wx = m.wx;
        this.wy = m.wy;
        this.ww = m.ww;
    }

    public Matrix3D(float mxx, float mxy, float mxw, float myx, float myy, float myw, float mwx, float mwy, float mww) {
        this.xx = mxx;
        this.xy = mxy;
        this.xw = mxw;
        this.yx = myx;
        this.yy = myy;
        this.yw = myw;
        this.wx = mwx;
        this.wy = mwy;
        this.ww = mww;
    }

    public void identity() {
        this.ww = 1.0f;
        this.yy = 1.0f;
        this.xx = 1.0f;
        this.wy = 0.0f;
        this.wx = 0.0f;
        this.yw = 0.0f;
        this.yx = 0.0f;
        this.xw = 0.0f;
        this.xy = 0.0f;
    }

    public void transponize() {
        float t = this.xy;
        this.xy = this.yx;
        this.yx = t;
        t = this.xw;
        this.xw = this.wx;
        this.wx = t;
        t = this.yw;
        this.yw = this.wy;
        this.wy = t;
    }

    public Vector2D mult(Vector2D v) {
        return new Vector2D(this.xx * v.x + this.xy * v.y, this.yx * v.x + this.yy * v.y);
    }

    public void transform(Vector2D v) {
        float x = this.xx * v.x + this.xy * v.y;
        float y = this.yx * v.x + this.yy * v.y;
        v.x = x;
        v.y = y;
    }

    public Point2D mult(Point2D p) {
        Point2D ret = new Point2D(this.xx * p.x + this.xy * p.y + this.xw, this.yx * p.x + this.yy * p.y + this.yw);
        ret.scale(1.0f / (this.wx * p.x + this.wy * p.y + this.ww));
        return ret;
    }

    public void transform(Point2D p) {
        float x = this.xx * p.x + this.xy * p.y + this.xw;
        float y = this.yx * p.x + this.yy * p.y + this.yw;
        float w = this.wx * p.x + this.wy * p.y + this.ww;
        p.x = x / w;
        p.y = y / w;
    }

    public Matrix3D mult(Matrix3D m) {
        if (m != null) {
            return new Matrix3D(this.xx * m.xx + this.xy * m.yx + this.xw * m.wx, this.xx * m.xy + this.xy * m.yy + this.xw * m.wy, this.xx * m.xw + this.xy * m.yw + this.xw * m.ww, this.yx * m.xx + this.yy * m.yx + this.yw * m.wx, this.yx * m.xy + this.yy * m.yy + this.yw * m.wy, this.yx * m.xw + this.yy * m.yw + this.yw * m.ww, this.wx * m.xx + this.wy * m.yx + this.ww * m.wx, this.wx * m.xy + this.wy * m.yy + this.ww * m.wy, this.wx * m.xw + this.wy * m.yw + this.ww * m.ww);
        }
        return new Matrix3D(this);
    }

    public void multBy(Matrix3D m) {
        float x = this.xx * m.xx + this.xy * m.yx + this.xw * m.wx;
        float y = this.xx * m.xy + this.xy * m.yy + this.xw * m.wy;
        float w = this.xx * m.xw + this.xy * m.yw + this.xw * m.ww;
        this.xx = x;
        this.xy = y;
        this.xw = w;
        x = this.yx * m.xx + this.yy * m.yx + this.yw * m.wx;
        y = this.yx * m.xy + this.yy * m.yy + this.yw * m.wy;
        w = this.yx * m.xw + this.yy * m.yw + this.yw * m.ww;
        this.yx = x;
        this.yy = y;
        this.yw = w;
        x = this.wx * m.xx + this.wy * m.yx + this.ww * m.wx;
        y = this.wx * m.xy + this.wy * m.yy + this.ww * m.wy;
        w = this.wx * m.xw + this.wy * m.yw + this.ww * m.ww;
        this.wx = x;
        this.wy = y;
        this.ww = w;
    }

    public void multLeftBy(Matrix3D m) {
        float x = m.xx * this.xx + m.xy * this.yx + m.xw * this.wx;
        float y = m.yx * this.xx + m.yy * this.yx + m.yw * this.wx;
        float w = m.wx * this.xx + m.wy * this.yx + m.ww * this.wx;
        this.xx = x;
        this.yx = y;
        this.wx = w;
        x = m.xx * this.xy + m.xy * this.yy + m.xw * this.wy;
        y = m.yx * this.xy + m.yy * this.yy + m.yw * this.wy;
        w = m.wx * this.xy + m.wy * this.yy + m.ww * this.wy;
        this.xy = x;
        this.yy = y;
        this.wy = w;
        x = m.xx * this.xw + m.xy * this.yw + m.xw * this.ww;
        y = m.yx * this.xw + m.yy * this.yw + m.yw * this.ww;
        w = m.wx * this.xw + m.wy * this.yw + m.ww * this.ww;
        this.xw = x;
        this.yw = y;
        this.ww = w;
    }

    public void translate(float x, float y) {
        this.xw += x * this.xx + y * this.xy;
        this.yw += x * this.yx + y * this.yy;
        this.ww += x * this.wx + y * this.wy;
    }

    public void translate(Vector2D v) {
        this.translate(v.x, v.y);
    }

    public void translateLeft(float x, float y) {
        if (x != 0.0f) {
            this.xx += x * this.wx;
            this.xy += x * this.wy;
            this.xw += x * this.ww;
        }
        if (y != 0.0f) {
            this.yx += y * this.wx;
            this.yy += y * this.wy;
            this.yw += y * this.ww;
        }
    }

    public void translateLeft(Vector2D v) {
        this.translateLeft(v.x, v.y);
    }

    public void moveBy(float x, float y) {
        if (x != 0.0f) {
            this.xx += x * this.xw;
            this.yx += x * this.yw;
            this.wx += x * this.ww;
        }
        if (y != 0.0f) {
            this.xy += y * this.xw;
            this.yy += y * this.yw;
            this.wy += y * this.ww;
        }
    }

    public void moveBy(Vector2D v) {
        this.moveBy(v.x, v.y);
    }

    public void rot(double theta) {
        if (theta == 0.0) {
            return;
        }
        double ct = Math.cos(theta);
        double st = Math.sin(theta);
        float Nx = (float)((double)this.xx * ct - (double)this.yx * st);
        float Ny = (float)((double)this.xx * st + (double)this.yx * ct);
        this.xx = Nx;
        this.yx = Ny;
        Nx = (float)((double)this.xy * ct - (double)this.yy * st);
        Ny = (float)((double)this.xy * st + (double)this.yy * ct);
        this.xy = Nx;
        this.yy = Ny;
        Nx = (float)((double)this.xw * ct - (double)this.yw * st);
        Ny = (float)((double)this.xw * st + (double)this.yw * ct);
        this.xw = Nx;
        this.yw = Ny;
    }

    public void scale(float f) {
        this.xx *= f;
        this.yx *= f;
        this.wx *= f;
        this.xy *= f;
        this.yy *= f;
        this.wy *= f;
    }

    public void scale(float fx, float fy) {
        this.xx *= fx;
        this.yx *= fx;
        this.wx *= fx;
        this.xy *= fy;
        this.yy *= fy;
        this.wy *= fy;
    }

    public void transform(Point2D[] v, int[] tx, int[] ty, int npoints) {
        int i = npoints;
        while (--i >= 0) {
            Point2D tmp = this.mult(v[i]);
            tx[i] = (int)tmp.x;
            ty[i] = (int)tmp.y;
        }
    }

    public String toString() {
        return new String(new StringBuffer().append("{{").append(this.xx).append(",").append(this.xy).append(",").append(this.xw).append("},{").append(this.yx).append(",").append(this.yy).append(",").append(this.yw).append("},{").append(this.wx).append(",").append(this.wy).append(",").append(this.ww).append("}}"));
    }
}

