/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre.ui.ribbon;

import com.projity.util.BrowserControl;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandToggleButtonGroup;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.JScrollablePanel;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonFrame;
import org.pushingpixels.flamingo.api.ribbon.RibbonContextualTaskGroup;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.api.ribbon.resize.RibbonBandResizePolicy;
import org.pushingpixels.flamingo.internal.ui.ribbon.AbstractBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonTaskToggleButton;
import org.pushingpixels.flamingo.internal.ui.ribbon.RibbonBandUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.RibbonUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuButton;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.flamingo.internal.utils.KeyTipManager;
import org.pushingpixels.flamingo.internal.utils.RenderingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectLibreRibbonUI
extends RibbonUI {
    public static final String IS_USING_TITLE_PANE = "ribbon.internal.isUsingTitlePane";
    private static final String JUST_MINIMIZED = "ribbon.internal.justMinimized";
    protected JRibbon ribbon;
    protected JPanel taskBarPanel;
    protected JScrollablePanel<BandHostPanel> bandScrollablePanel;
    protected JScrollablePanel<TaskToggleButtonsHostPanel> taskToggleButtonsScrollablePanel;
    protected JCommandButton applicationMenuButton;
    protected JPanel helpPanel;
    protected Map<RibbonTask, JRibbonTaskToggleButton> taskToggleButtons;
    protected CommandToggleButtonGroup taskToggleButtonGroup;
    protected ChangeListener ribbonChangeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected ContainerListener ribbonContainerListener;
    protected ComponentListener ribbonComponentListener;
    public static final Color RIBBON_MENU_COLOR = new Color(200, 200, 200);
    public static final Color RIBBON_MENU_DARK_COLOR = new Color(140, 140, 140);
    protected int appMenuButtonWidth = 180;
    protected int appMenuButtonHeight = 40;
    protected int appMenuButtonXOffset = 0;
    protected int appMenuButtonYOffset = 8;
    protected int applicationMenuButtonOutlineMarginX = 10;
    protected int defaultTaskbartHeight = 34;
    protected int defaultTaskToggleButtonHeight = 32;
    protected int openprojLogoWidth = 120;
    protected int openprojLogoHeight = 27;
    protected int openprojLogoXOffset = 17;
    protected int openprojLogoYOffset = 3;
    protected Color background3;
    protected Color background1 = this.background3 = RIBBON_MENU_COLOR;
    protected Color background2 = this.background3;
    protected int fileSelectorOffsetX = 300;
    protected int projectViewsOffsetX = 600;
    protected int heightToReduce = 20;
    protected int helpSpaceWidth = 30;

    public static ComponentUI createUI(JComponent jComponent) {
        return new ProjectLibreRibbonUI();
    }

    public ProjectLibreRibbonUI() {
        this.taskToggleButtons = new HashMap<RibbonTask, JRibbonTaskToggleButton>();
        this.taskToggleButtonGroup = new CommandToggleButtonGroup();
        this.taskToggleButtonGroup.setAllowsClearingSelection(false);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.ribbon = (JRibbon)jComponent;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.ribbon = null;
    }

    protected void installListeners() {
        this.ribbonChangeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ProjectLibreRibbonUI.this.syncRibbonState();
            }
        };
        this.ribbon.addChangeListener(this.ribbonChangeListener);
        this.propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object;
                if ("selectedTask".equals(propertyChangeEvent.getPropertyName())) {
                    JRibbonTaskToggleButton jRibbonTaskToggleButton;
                    object = (RibbonTask)propertyChangeEvent.getOldValue();
                    final RibbonTask ribbonTask = (RibbonTask)propertyChangeEvent.getNewValue();
                    if (object != null && ProjectLibreRibbonUI.this.taskToggleButtons.get(object) != null) {
                        ProjectLibreRibbonUI.this.taskToggleButtons.get(object).getActionModel().setSelected(false);
                    }
                    if (ribbonTask != null && ProjectLibreRibbonUI.this.taskToggleButtons.get(ribbonTask) != null) {
                        ProjectLibreRibbonUI.this.taskToggleButtons.get(ribbonTask).getActionModel().setSelected(true);
                    }
                    if (ProjectLibreRibbonUI.this.isShowingScrollsForTaskToggleButtons() && ribbonTask != null && (jRibbonTaskToggleButton = ProjectLibreRibbonUI.this.taskToggleButtons.get(ribbonTask)) != null) {
                        ProjectLibreRibbonUI.this.scrollAndRevealTaskToggleButton(jRibbonTaskToggleButton);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            KeyTipManager keyTipManager = KeyTipManager.defaultManager();
                            if (keyTipManager.isShowingKeyTips()) {
                                KeyTipManager.KeyTipChain keyTipChain = keyTipManager.getCurrentlyShownKeyTipChain();
                                if (keyTipChain.chainParentComponent == ProjectLibreRibbonUI.this.taskToggleButtons.get(ribbonTask)) {
                                    keyTipManager.refreshCurrentChain();
                                }
                            }
                        }
                    });
                }
                if ("applicationMenuRichTooltip".equals(propertyChangeEvent.getPropertyName())) {
                    ProjectLibreRibbonUI.this.syncApplicationMenuTips();
                }
                if ("applicationMenuKeyTip".equals(propertyChangeEvent.getPropertyName())) {
                    ProjectLibreRibbonUI.this.syncApplicationMenuTips();
                }
                if ("applicationMenu".equals(propertyChangeEvent.getPropertyName())) {
                    ProjectLibreRibbonUI.this.ribbon.revalidate();
                    ProjectLibreRibbonUI.this.ribbon.doLayout();
                    ProjectLibreRibbonUI.this.ribbon.repaint();
                    object = SwingUtilities.getWindowAncestor(ProjectLibreRibbonUI.this.ribbon);
                    if (object instanceof JRibbonFrame) {
                        FlamingoUtilities.updateRibbonFrameIconImages((JRibbonFrame)object);
                    }
                }
                if ("minimized".equals(propertyChangeEvent.getPropertyName())) {
                    PopupPanelManager.defaultManager().hidePopups(null);
                    ProjectLibreRibbonUI.this.ribbon.revalidate();
                    ProjectLibreRibbonUI.this.ribbon.doLayout();
                    ProjectLibreRibbonUI.this.ribbon.repaint();
                }
            }
        };
        this.ribbon.addPropertyChangeListener(this.propertyChangeListener);
        this.ribbonContainerListener = new ContainerAdapter(){

            public void componentAdded(ContainerEvent containerEvent) {
                if (ProjectLibreRibbonUI.this.isUsingTitlePane()) {
                    return;
                }
                Component component = containerEvent.getComponent();
                if (component != ProjectLibreRibbonUI.this.applicationMenuButton) {
                    ProjectLibreRibbonUI.this.ribbon.setComponentZOrder(ProjectLibreRibbonUI.this.applicationMenuButton, ProjectLibreRibbonUI.this.ribbon.getComponentCount() - 1);
                }
            }
        };
        this.ribbon.addContainerListener(this.ribbonContainerListener);
        this.ribbonComponentListener = new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                KeyTipManager.defaultManager().hideAllKeyTips();
            }
        };
        this.ribbon.addComponentListener(this.ribbonComponentListener);
    }

    protected void uninstallListeners() {
        this.ribbon.removeChangeListener(this.ribbonChangeListener);
        this.ribbonChangeListener = null;
        this.ribbon.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        this.ribbon.removeContainerListener(this.ribbonContainerListener);
        this.ribbonContainerListener = null;
        this.ribbon.removeComponentListener(this.ribbonComponentListener);
        this.ribbonComponentListener = null;
    }

    protected void installDefaults() {
        Border border;
        Border border2 = this.ribbon.getBorder();
        if ((border2 == null || border2 instanceof UIResource) && (border = UIManager.getBorder("Ribbon.border")) == null) {
            border = new BorderUIResource.EmptyBorderUIResource(1, 2, 1, 2);
        }
    }

    protected void uninstallDefaults() {
    }

    protected void installComponents() {
        this.taskBarPanel = new TaskbarPanel();
        this.taskBarPanel.setName("JRibbon Task Bar");
        this.taskBarPanel.setLayout(this.createTaskbarLayoutManager());
        this.ribbon.add(this.taskBarPanel);
        BandHostPanel bandHostPanel = this.createBandHostPanel();
        bandHostPanel.setLayout(this.createBandHostPanelLayoutManager());
        this.bandScrollablePanel = new JScrollablePanel<BandHostPanel>(bandHostPanel, JScrollablePanel.ScrollType.HORIZONTALLY);
        this.bandScrollablePanel.setScrollOnRollover(false);
        this.ribbon.add(this.bandScrollablePanel);
        TaskToggleButtonsHostPanel taskToggleButtonsHostPanel = this.createTaskToggleButtonsHostPanel();
        taskToggleButtonsHostPanel.setLayout(this.createTaskToggleButtonsHostPanelLayoutManager());
        this.taskToggleButtonsScrollablePanel = new JScrollablePanel<TaskToggleButtonsHostPanel>(taskToggleButtonsHostPanel, JScrollablePanel.ScrollType.HORIZONTALLY);
        this.taskToggleButtonsScrollablePanel.setScrollOnRollover(false);
        this.taskToggleButtonsScrollablePanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ProjectLibreRibbonUI.this.ribbon.repaint();
            }
        });
        this.ribbon.add(this.taskToggleButtonsScrollablePanel);
        this.ribbon.setLayout(this.createLayoutManager());
        this.syncRibbonState();
        this.ribbon.add(this.ribbon.getOpenprojLogo());
        this.ribbon.add(this.ribbon.getFileSelector());
        this.ribbon.add(this.ribbon.getProjectViews());
        this.applicationMenuButton = new JRibbonApplicationMenuButton(this.ribbon);
        this.syncApplicationMenuTips();
        this.ribbon.add(this.applicationMenuButton);
        Window window = SwingUtilities.getWindowAncestor(this.ribbon);
        if (window instanceof JRibbonFrame) {
            FlamingoUtilities.updateRibbonFrameIconImages((JRibbonFrame)window);
        }
        this.applicationMenuButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                BrowserControl.displayURL("http://www.projectlibre.com/");
            }
        });
    }

    protected LayoutManager createTaskToggleButtonsHostPanelLayoutManager() {
        return new TaskToggleButtonsHostPanelLayout();
    }

    protected TaskToggleButtonsHostPanel createTaskToggleButtonsHostPanel() {
        return new TaskToggleButtonsHostPanel();
    }

    protected BandHostPanel createBandHostPanel() {
        return new BandHostPanel();
    }

    protected LayoutManager createBandHostPanelLayoutManager() {
        return new BandHostPanelLayout();
    }

    protected void uninstallComponents() {
        this.taskBarPanel.removeAll();
        this.taskBarPanel.setLayout(null);
        this.ribbon.remove(this.taskBarPanel);
        BandHostPanel bandHostPanel = this.bandScrollablePanel.getView();
        bandHostPanel.removeAll();
        bandHostPanel.setLayout(null);
        this.ribbon.remove(this.bandScrollablePanel);
        TaskToggleButtonsHostPanel taskToggleButtonsHostPanel = this.taskToggleButtonsScrollablePanel.getView();
        taskToggleButtonsHostPanel.removeAll();
        taskToggleButtonsHostPanel.setLayout(null);
        this.ribbon.remove(this.taskToggleButtonsScrollablePanel);
        if (this.ribbon.getOpenprojLogo() != null) {
            this.ribbon.remove(this.ribbon.getOpenprojLogo());
        }
        if (this.ribbon.getFileSelector() != null) {
            this.ribbon.remove(this.ribbon.getFileSelector());
        }
        if (this.ribbon.getProjectViews() != null) {
            this.ribbon.remove(this.ribbon.getProjectViews());
        }
        this.ribbon.remove(this.applicationMenuButton);
        if (this.helpPanel != null) {
            this.ribbon.remove(this.helpPanel);
        }
        this.ribbon.setLayout(null);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints(graphics2D);
        super.update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.paintBackground(graphics);
        if (!this.ribbon.isMinimized()) {
            Insets insets = jComponent.getInsets();
            int n = this.getTaskToggleButtonHeight();
            if (!this.isUsingTitlePane()) {
                n += this.getTaskbarHeight();
            }
            this.paintTaskArea(graphics, 0, insets.top + n, jComponent.getWidth(), jComponent.getHeight() - n - insets.top - insets.bottom);
        } else {
            this.paintMinimizedRibbonSeparator(graphics);
        }
    }

    protected void paintMinimizedRibbonSeparator(Graphics graphics) {
        Color color = FlamingoUtilities.getBorderColor();
        graphics.setColor(color);
        Insets insets = this.ribbon.getInsets();
        graphics.drawLine(0, this.ribbon.getHeight() - insets.bottom, this.ribbon.getWidth(), this.ribbon.getHeight() - insets.bottom);
    }

    protected void paintBackground(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        int n = 200;
        int n2 = 66;
        graphics2D.setColor(this.background1);
        graphics2D.fillRect(0, 0, this.ribbon.getWidth(), this.ribbon.getHeight());
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, RIBBON_MENU_DARK_COLOR, 200.0f, 0.0f, this.background1);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setColor(this.background1);
        BasicStroke basicStroke = new BasicStroke(2.0f);
        graphics2D.setStroke(basicStroke);
        graphics2D.draw(new Line2D.Double(0.0, 64.0, n, 64.0));
        graphics2D.draw(new Line2D.Double(0.0, 59.0, n, 59.0));
        graphics2D.draw(new Line2D.Double(0.0, 53.0, n, 53.0));
        graphics2D.draw(new Line2D.Double(0.0, 45.0, n, 45.0));
        graphics2D.draw(new Line2D.Double(0.0, 33.0, n, 33.0));
        graphics2D.draw(new Line2D.Double(0.0, 25.0, this.ribbon.getWidth(), 25.0));
        graphics2D.draw(new Line2D.Double(0.0, 11.0, this.ribbon.getWidth(), 11.0));
        graphics2D.dispose();
    }

    protected void paintTaskArea(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.ribbon.getTaskCount() == 0) {
            return;
        }
        JRibbonTaskToggleButton jRibbonTaskToggleButton = this.taskToggleButtons.get(this.ribbon.getSelectedTask());
        Rectangle rectangle = jRibbonTaskToggleButton.getBounds();
        Point point = SwingUtilities.convertPoint(jRibbonTaskToggleButton.getParent(), rectangle.getLocation(), this.ribbon);
        Rectangle rectangle2 = this.taskToggleButtonsScrollablePanel.getView().getParent().getBounds();
        rectangle2.setLocation(SwingUtilities.convertPoint(this.taskToggleButtonsScrollablePanel, rectangle2.getLocation(), this.ribbon));
        int n5 = Math.max(point.x + 1, (int)rectangle2.getMinX());
        n5 = Math.min(n5, (int)rectangle2.getMaxX());
        int n6 = Math.min(point.x + rectangle.width - 1, (int)rectangle2.getMaxX());
        n6 = Math.max(n6, (int)rectangle2.getMinX());
        GeneralPath generalPath = FlamingoUtilities.getRibbonBorderOutline(n + 1, n + n3 - 3, n5, n6, point.y, n2, n2 + n4, 2.0f);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setColor(FlamingoUtilities.getBorderColor());
        graphics2D.drawLine(n, n2, n + n3, n2);
        RibbonTask ribbonTask = this.ribbon.getSelectedTask();
        RibbonContextualTaskGroup ribbonContextualTaskGroup = ribbonTask.getContextualGroup();
        if (ribbonContextualTaskGroup != null) {
            Insets insets = this.ribbon.getInsets();
            int n7 = insets.top + this.getTaskbarHeight();
            int n8 = n7 + 5;
            Color color = ribbonContextualTaskGroup.getHueColor();
            GradientPaint gradientPaint = new GradientPaint(0.0f, n7, FlamingoUtilities.getAlphaColor(color, 63), 0.0f, n8, FlamingoUtilities.getAlphaColor(color, 0));
            graphics2D.setPaint(gradientPaint);
            graphics2D.clip(generalPath);
            graphics2D.fillRect(0, n7, n3, n8 - n7 + 1);
        }
        graphics2D.dispose();
    }

    @Override
    public Rectangle getContextualTaskGroupBounds(RibbonContextualTaskGroup ribbonContextualTaskGroup) {
        Serializable serializable;
        int n;
        Rectangle rectangle = null;
        for (n = 0; n < ribbonContextualTaskGroup.getTaskCount(); ++n) {
            serializable = this.taskToggleButtons.get(ribbonContextualTaskGroup.getTask(n));
            rectangle = rectangle == null ? serializable.getBounds() : rectangle.union(serializable.getBounds());
        }
        n = this.getTabButtonGap();
        serializable = SwingUtilities.convertPoint(this.taskToggleButtonsScrollablePanel.getView(), rectangle.getLocation(), this.ribbon);
        return new Rectangle(((Point)serializable).x - n / 3, ((Point)serializable).y - 1, rectangle.width + n * 2 / 3 - 1, rectangle.height + 1);
    }

    protected int getBandGap() {
        return 2;
    }

    protected int getTabButtonGap() {
        return 6;
    }

    protected LayoutManager createLayoutManager() {
        return new RibbonLayout();
    }

    protected LayoutManager createTaskbarLayoutManager() {
        return new TaskbarLayout();
    }

    public int getTaskbarHeight() {
        return this.defaultTaskbartHeight;
    }

    public int getTaskToggleButtonHeight() {
        return this.defaultTaskToggleButtonHeight;
    }

    protected void syncRibbonState() {
        int n;
        Object object;
        BandHostPanel bandHostPanel = this.bandScrollablePanel.getView();
        bandHostPanel.removeAll();
        TaskToggleButtonsHostPanel taskToggleButtonsHostPanel = this.taskToggleButtonsScrollablePanel.getView();
        taskToggleButtonsHostPanel.removeAll();
        if (this.helpPanel != null) {
            this.ribbon.remove(this.helpPanel);
            this.helpPanel = null;
        }
        List<RibbonTask> list = this.getCurrentlyShownRibbonTasks();
        RibbonTask ribbonTask = this.ribbon.getSelectedTask();
        for (final RibbonTask ribbonTask2 : list) {
            object = new JRibbonTaskToggleButton(ribbonTask2);
            ((JRibbonTaskToggleButton)object).setKeyTip(ribbonTask2.getKeyTip());
            ((AbstractCommandButton)object).addActionListener(new ActionListener((JRibbonTaskToggleButton)object, ribbonTask2){
                final /* synthetic */ JRibbonTaskToggleButton val$taskToggleButton;
                final /* synthetic */ RibbonTask val$task;
                {
                    this.val$taskToggleButton = jRibbonTaskToggleButton;
                    this.val$task = ribbonTask;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ProjectLibreRibbonUI.this.scrollAndRevealTaskToggleButton(val$taskToggleButton);
                            ProjectLibreRibbonUI.this.ribbon.setSelectedTask(val$task);
                            if (ProjectLibreRibbonUI.this.ribbon.isMinimized()) {
                                int n;
                                Serializable serializable;
                                AbstractRibbonBand<?> abstractRibbonBand;
                                if (Boolean.TRUE.equals(ProjectLibreRibbonUI.this.ribbon.getClientProperty(ProjectLibreRibbonUI.JUST_MINIMIZED))) {
                                    ProjectLibreRibbonUI.this.ribbon.putClientProperty(ProjectLibreRibbonUI.JUST_MINIMIZED, null);
                                    return;
                                }
                                List<PopupPanelManager.PopupInfo> list = PopupPanelManager.defaultManager().getShownPath();
                                if (list.size() > 0) {
                                    for (PopupPanelManager.PopupInfo object2 : list) {
                                        if (object2.getPopupOriginator() != val$taskToggleButton) continue;
                                        PopupPanelManager.defaultManager().hidePopups(null);
                                        return;
                                    }
                                }
                                PopupPanelManager.defaultManager().hidePopups(null);
                                ProjectLibreRibbonUI.this.ribbon.remove(ProjectLibreRibbonUI.this.bandScrollablePanel);
                                int n2 = ProjectLibreRibbonUI.this.bandScrollablePanel.getView().getPreferredSize().height;
                                Insets insets = ProjectLibreRibbonUI.this.ribbon.getInsets();
                                n2 += insets.top + insets.bottom;
                                AbstractRibbonBand<?> abstractRibbonBand2 = abstractRibbonBand = ProjectLibreRibbonUI.this.ribbon.getSelectedTask().getBandCount() > 0 ? ProjectLibreRibbonUI.this.ribbon.getSelectedTask().getBand(0) : null;
                                if (abstractRibbonBand != null) {
                                    serializable = abstractRibbonBand.getInsets();
                                    n2 += ((Insets)serializable).top + ((Insets)serializable).bottom;
                                }
                                serializable = new BandHostPopupPanel(ProjectLibreRibbonUI.this.bandScrollablePanel, new Dimension(ProjectLibreRibbonUI.this.ribbon.getWidth(), n2));
                                int n3 = ProjectLibreRibbonUI.this.ribbon.getLocationOnScreen().x;
                                int n4 = ProjectLibreRibbonUI.this.ribbon.getLocationOnScreen().y + ProjectLibreRibbonUI.this.ribbon.getHeight();
                                Rectangle rectangle = ProjectLibreRibbonUI.this.ribbon.getGraphicsConfiguration().getBounds();
                                int n5 = ((JComponent)serializable).getPreferredSize().width;
                                if (n3 + n5 > rectangle.x + rectangle.width) {
                                    n3 = rectangle.x + rectangle.width - n5;
                                }
                                if (n4 + (n = ((JComponent)serializable).getPreferredSize().height) > rectangle.y + rectangle.height) {
                                    n4 = rectangle.y + rectangle.height - n;
                                }
                                ((JComponent)serializable).setPreferredSize(new Dimension(ProjectLibreRibbonUI.this.ribbon.getWidth(), n2));
                                Popup popup = PopupFactory.getSharedInstance().getPopup(val$taskToggleButton, (Component)serializable, n3, n4);
                                PopupPanelManager.PopupListener popupListener = new PopupPanelManager.PopupListener(){

                                    public void popupShown(PopupPanelManager.PopupEvent popupEvent) {
                                        JComponent jComponent = popupEvent.getPopupOriginator();
                                        if (jComponent instanceof JRibbonTaskToggleButton) {
                                            ProjectLibreRibbonUI.this.bandScrollablePanel.doLayout();
                                            ProjectLibreRibbonUI.this.bandScrollablePanel.repaint();
                                        }
                                    }

                                    public void popupHidden(PopupPanelManager.PopupEvent popupEvent) {
                                        JComponent jComponent = popupEvent.getPopupOriginator();
                                        if (jComponent instanceof JRibbonTaskToggleButton) {
                                            ProjectLibreRibbonUI.this.ribbon.add(ProjectLibreRibbonUI.this.bandScrollablePanel);
                                            PopupPanelManager.defaultManager().removePopupListener(this);
                                            ProjectLibreRibbonUI.this.ribbon.revalidate();
                                            ProjectLibreRibbonUI.this.ribbon.doLayout();
                                            ProjectLibreRibbonUI.this.ribbon.repaint();
                                        }
                                    }
                                };
                                PopupPanelManager.defaultManager().addPopupListener(popupListener);
                                PopupPanelManager.defaultManager().addPopup(val$taskToggleButton, popup, (JPopupPanel)serializable);
                            }
                        }
                    });
                }
            });
            ((Component)object).addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (ProjectLibreRibbonUI.this.ribbon.getSelectedTask() == ribbonTask2 && mouseEvent.getClickCount() == 2) {
                        boolean bl = ProjectLibreRibbonUI.this.ribbon.isMinimized();
                        ProjectLibreRibbonUI.this.ribbon.setMinimized(!bl);
                        if (!bl) {
                            ProjectLibreRibbonUI.this.ribbon.putClientProperty(ProjectLibreRibbonUI.JUST_MINIMIZED, Boolean.TRUE);
                        }
                    }
                }
            });
            if (ribbonTask2.getContextualGroup() != null) {
                ((JRibbonTaskToggleButton)object).setContextualGroupHueColor(ribbonTask2.getContextualGroup().getHueColor());
            }
            ((JComponent)object).putClientProperty("flamingo.internal.commandButton.ui.dontDisposePopups", Boolean.TRUE);
            this.taskToggleButtonGroup.add((JCommandToggleButton)object);
            taskToggleButtonsHostPanel.add((Component)object);
            this.taskToggleButtons.put(ribbonTask2, (JRibbonTaskToggleButton)object);
        }
        JRibbonTaskToggleButton jRibbonTaskToggleButton = this.taskToggleButtons.get(ribbonTask);
        if (jRibbonTaskToggleButton != null) {
            jRibbonTaskToggleButton.getActionModel().setSelected(true);
        }
        for (n = 0; n < this.ribbon.getTaskCount(); ++n) {
            object = this.ribbon.getTask(n);
            for (AbstractRibbonBand<?> object2 : ((RibbonTask)object).getBands()) {
                bandHostPanel.add(object2);
                object2.setVisible(ribbonTask == object);
            }
        }
        for (n = 0; n < this.ribbon.getContextualTaskGroupCount(); ++n) {
            object = this.ribbon.getContextualTaskGroup(n);
            for (int i = 0; i < ((RibbonContextualTaskGroup)object).getTaskCount(); ++i) {
                RibbonTask ribbonTask2 = ((RibbonContextualTaskGroup)object).getTask(i);
                for (AbstractRibbonBand<?> abstractRibbonBand : ribbonTask2.getBands()) {
                    bandHostPanel.add(abstractRibbonBand);
                    abstractRibbonBand.setVisible(ribbonTask == ribbonTask2);
                }
            }
        }
        ActionListener actionListener = this.ribbon.getHelpActionListener();
        if (actionListener != null) {
            this.helpPanel = new JPanel();
            this.helpPanel.setBackground(this.taskToggleButtonsScrollablePanel.getBackground());
            object = new JPanel();
            ((JComponent)object).setBackground(this.taskToggleButtonsScrollablePanel.getBackground());
            ((JComponent)object).setPreferredSize(new Dimension(this.helpSpaceWidth, 5));
            this.helpPanel.add((Component)object);
            JButton jButton = new JButton("", this.ribbon.getHelpIcon());
            jButton.setOpaque(true);
            jButton.setBackground(this.taskToggleButtonsScrollablePanel.getBackground());
            jButton.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
            jButton.setIcon(this.ribbon.getHelpIcon());
            jButton.setContentAreaFilled(false);
            jButton.setFocusPainted(false);
            jButton.setBorder(BorderFactory.createEmptyBorder());
            jButton.addActionListener(actionListener);
            this.helpPanel.add(jButton);
            this.ribbon.add(this.helpPanel);
        }
        this.ribbon.revalidate();
        this.ribbon.repaint();
    }

    protected List<RibbonTask> getCurrentlyShownRibbonTasks() {
        Object object;
        int n;
        ArrayList<RibbonTask> arrayList = new ArrayList<RibbonTask>();
        for (n = 0; n < this.ribbon.getTaskCount(); ++n) {
            object = this.ribbon.getTask(n);
            arrayList.add((RibbonTask)object);
        }
        for (n = 0; n < this.ribbon.getContextualTaskGroupCount(); ++n) {
            object = this.ribbon.getContextualTaskGroup(n);
            if (!this.ribbon.isVisible((RibbonContextualTaskGroup)object)) continue;
            for (int i = 0; i < ((RibbonContextualTaskGroup)object).getTaskCount(); ++i) {
                RibbonTask ribbonTask = ((RibbonContextualTaskGroup)object).getTask(i);
                arrayList.add(ribbonTask);
            }
        }
        return arrayList;
    }

    protected boolean isUsingTitlePane() {
        return Boolean.TRUE.equals(this.ribbon.getClientProperty(IS_USING_TITLE_PANE));
    }

    protected void syncApplicationMenuTips() {
        this.applicationMenuButton.setPopupRichTooltip(this.ribbon.getApplicationMenuRichTooltip());
        this.applicationMenuButton.setPopupKeyTip(this.ribbon.getApplicationMenuKeyTip());
    }

    @Override
    public boolean isShowingScrollsForTaskToggleButtons() {
        return this.taskToggleButtonsScrollablePanel.isShowingScrollButtons();
    }

    @Override
    public boolean isShowingScrollsForBands() {
        return this.bandScrollablePanel.isShowingScrollButtons();
    }

    public Map<RibbonTask, JRibbonTaskToggleButton> getTaskToggleButtons() {
        return Collections.unmodifiableMap(this.taskToggleButtons);
    }

    @Override
    public void handleMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        int n;
        if (this.ribbon.isMinimized()) {
            return;
        }
        final List<RibbonTask> list = this.getCurrentlyShownRibbonTasks();
        if (list.size() == 0) {
            return;
        }
        int n2 = mouseWheelEvent.getWheelRotation();
        if (n2 == 0) {
            return;
        }
        int n3 = list.indexOf(this.ribbon.getSelectedTask());
        if (!this.ribbon.getComponentOrientation().isLeftToRight()) {
            n2 = -n2;
        }
        if ((n = n3 + (n2 > 0 ? 1 : -1)) < 0) {
            return;
        }
        if (n >= list.size()) {
            return;
        }
        final int n4 = n;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProjectLibreRibbonUI.this.ribbon.setCursor(Cursor.getPredefinedCursor(3));
                ProjectLibreRibbonUI.this.ribbon.setSelectedTask((RibbonTask)list.get(n4));
                ProjectLibreRibbonUI.this.ribbon.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }

    protected void scrollAndRevealTaskToggleButton(JRibbonTaskToggleButton jRibbonTaskToggleButton) {
        Point point = SwingUtilities.convertPoint(jRibbonTaskToggleButton.getParent(), jRibbonTaskToggleButton.getLocation(), this.taskToggleButtonsScrollablePanel.getView());
        this.taskToggleButtonsScrollablePanel.scrollToIfNecessary(point.x, jRibbonTaskToggleButton.getWidth());
    }

    protected static class BandHostPopupPanel
    extends JPopupPanel {
        public BandHostPopupPanel(Component component, Dimension dimension) {
            this.setLayout(new BorderLayout());
            this.add(component, "Center");
            this.setPreferredSize(dimension);
            this.setSize(dimension);
        }
    }

    private class TaskToggleButtonsHostPanelLayout
    implements LayoutManager {
        private TaskToggleButtonsHostPanelLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            int n = ProjectLibreRibbonUI.this.getTabButtonGap();
            int n2 = ProjectLibreRibbonUI.this.getTaskToggleButtonHeight();
            int n3 = 0;
            List<RibbonTask> list = ProjectLibreRibbonUI.this.getCurrentlyShownRibbonTasks();
            for (RibbonTask ribbonTask : list) {
                JRibbonTaskToggleButton jRibbonTaskToggleButton = ProjectLibreRibbonUI.this.taskToggleButtons.get(ribbonTask);
                int n4 = jRibbonTaskToggleButton.getPreferredSize().width;
                n3 += n4 + n;
            }
            return new Dimension(n3, n2);
        }

        public Dimension minimumLayoutSize(Container container) {
            int n = ProjectLibreRibbonUI.this.getTabButtonGap();
            int n2 = ProjectLibreRibbonUI.this.getTaskToggleButtonHeight();
            int n3 = 0;
            List<RibbonTask> list = ProjectLibreRibbonUI.this.getCurrentlyShownRibbonTasks();
            for (RibbonTask ribbonTask : list) {
                JRibbonTaskToggleButton jRibbonTaskToggleButton = ProjectLibreRibbonUI.this.taskToggleButtons.get(ribbonTask);
                int n4 = jRibbonTaskToggleButton.getMinimumSize().width;
                n3 += n4 + n;
            }
            return new Dimension(n3, n2);
        }

        public void layoutContainer(Container container) {
            int n = 0;
            int n2 = ProjectLibreRibbonUI.this.getTabButtonGap();
            int n3 = ProjectLibreRibbonUI.this.getTaskToggleButtonHeight();
            int n4 = 0;
            int n5 = 0;
            List<RibbonTask> list = ProjectLibreRibbonUI.this.getCurrentlyShownRibbonTasks();
            HashMap<JRibbonTaskToggleButton, Integer> hashMap = new HashMap<JRibbonTaskToggleButton, Integer>();
            int n6 = 0;
            for (RibbonTask ribbonTask : list) {
                JRibbonTaskToggleButton jRibbonTaskToggleButton = ProjectLibreRibbonUI.this.taskToggleButtons.get(ribbonTask);
                int n7 = jRibbonTaskToggleButton.getPreferredSize().width;
                int n8 = jRibbonTaskToggleButton.getMinimumSize().width;
                hashMap.put(jRibbonTaskToggleButton, n7 - n8);
                n6 += n7 - n8;
                n4 += n7;
                n5 += n8;
            }
            n5 += n2 * list.size();
            boolean bl = container.getComponentOrientation().isLeftToRight();
            if ((n4 += n2 * list.size()) <= container.getWidth()) {
                int n9 = bl ? 0 : container.getWidth();
                for (RibbonTask ribbonTask : list) {
                    JRibbonTaskToggleButton jRibbonTaskToggleButton = ProjectLibreRibbonUI.this.taskToggleButtons.get(ribbonTask);
                    int n10 = jRibbonTaskToggleButton.getPreferredSize().width;
                    if (bl) {
                        jRibbonTaskToggleButton.setBounds(n9, n + 1, n10, n3 - 1);
                        n9 += n10 + n2;
                    } else {
                        jRibbonTaskToggleButton.setBounds(n9 - n10, n + 1, n10, n3 - 1);
                        n9 -= n10 + n2;
                    }
                    jRibbonTaskToggleButton.setActionRichTooltip(null);
                }
                ((JComponent)container).putClientProperty("flamingo.internal.ribbon.taskToggleButtonsHostPanel.isSquished", null);
            } else {
                if (n5 > container.getWidth()) {
                    throw new IllegalStateException("Available width not enough to host minimized task tab buttons");
                }
                int n11 = bl ? 0 : container.getWidth();
                int n12 = n4 - container.getWidth() + 2;
                for (RibbonTask ribbonTask : list) {
                    JRibbonTaskToggleButton jRibbonTaskToggleButton = ProjectLibreRibbonUI.this.taskToggleButtons.get(ribbonTask);
                    int n13 = jRibbonTaskToggleButton.getPreferredSize().width;
                    int n14 = n12 * (Integer)hashMap.get(jRibbonTaskToggleButton) / n6;
                    int n15 = n13 - n14;
                    if (bl) {
                        jRibbonTaskToggleButton.setBounds(n11, n + 1, n15, n3 - 1);
                        n11 += n15 + n2;
                    } else {
                        jRibbonTaskToggleButton.setBounds(n11 - n15, n + 1, n15, n3 - 1);
                        n11 -= n15 + n2;
                    }
                    RichTooltip richTooltip = new RichTooltip();
                    richTooltip.setTitle(ribbonTask.getTitle());
                    jRibbonTaskToggleButton.setActionRichTooltip(richTooltip);
                }
                ((JComponent)container).putClientProperty("flamingo.internal.ribbon.taskToggleButtonsHostPanel.isSquished", Boolean.TRUE);
            }
        }
    }

    protected class TaskToggleButtonsHostPanel
    extends JPanel {
        public static final String IS_SQUISHED = "flamingo.internal.ribbon.taskToggleButtonsHostPanel.isSquished";

        protected TaskToggleButtonsHostPanel() {
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.paintContextualTaskGroupsOutlines(graphics);
            if (Boolean.TRUE.equals(this.getClientProperty(IS_SQUISHED))) {
                this.paintTaskOutlines(graphics);
            }
        }

        protected void paintTaskOutlines(Graphics graphics) {
            Object object;
            Object object22;
            int n;
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            Color color = FlamingoUtilities.getBorderColor();
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, FlamingoUtilities.getAlphaColor(color, 0), 0.0f, this.getHeight(), color);
            graphics2D.setPaint(gradientPaint);
            HashSet<Object> hashSet = new HashSet<Object>();
            for (n = 0; n < ProjectLibreRibbonUI.this.ribbon.getTaskCount() - 1; ++n) {
                object22 = ProjectLibreRibbonUI.this.ribbon.getTask(n);
                hashSet.add(object22);
            }
            for (n = 0; n < ProjectLibreRibbonUI.this.ribbon.getContextualTaskGroupCount(); ++n) {
                object22 = ProjectLibreRibbonUI.this.ribbon.getContextualTaskGroup(n);
                if (!ProjectLibreRibbonUI.this.ribbon.isVisible((RibbonContextualTaskGroup)object22)) continue;
                for (int i = 0; i < ((RibbonContextualTaskGroup)object22).getTaskCount() - 1; ++i) {
                    object = ((RibbonContextualTaskGroup)object22).getTask(i);
                    hashSet.add(object);
                }
            }
            for (Object object22 : hashSet) {
                JRibbonTaskToggleButton jRibbonTaskToggleButton = ProjectLibreRibbonUI.this.taskToggleButtons.get(object22);
                object = jRibbonTaskToggleButton.getBounds();
                int n2 = ((Rectangle)object).x + ((Rectangle)object).width + ProjectLibreRibbonUI.this.getTabButtonGap() / 2 - 1;
                graphics2D.drawLine(n2, 0, n2, this.getHeight());
            }
            graphics2D.dispose();
        }

        protected void paintContextualTaskGroupsOutlines(Graphics graphics) {
            for (int i = 0; i < ProjectLibreRibbonUI.this.ribbon.getContextualTaskGroupCount(); ++i) {
                RibbonContextualTaskGroup ribbonContextualTaskGroup = ProjectLibreRibbonUI.this.ribbon.getContextualTaskGroup(i);
                if (!ProjectLibreRibbonUI.this.ribbon.isVisible(ribbonContextualTaskGroup)) continue;
                Rectangle rectangle = ProjectLibreRibbonUI.this.getContextualTaskGroupBounds(ribbonContextualTaskGroup);
                rectangle.setLocation(SwingUtilities.convertPoint(ProjectLibreRibbonUI.this.ribbon, rectangle.getLocation(), ProjectLibreRibbonUI.this.taskToggleButtonsScrollablePanel.getView()));
                this.paintContextualTaskGroupOutlines(graphics, ribbonContextualTaskGroup, rectangle);
            }
        }

        protected void paintContextualTaskGroupOutlines(Graphics graphics, RibbonContextualTaskGroup ribbonContextualTaskGroup, Rectangle rectangle) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            Color color = FlamingoUtilities.getBorderColor();
            GradientPaint gradientPaint = new GradientPaint(0.0f, rectangle.y, color, 0.0f, rectangle.y + rectangle.height, FlamingoUtilities.getAlphaColor(color, 0));
            graphics2D.setPaint(gradientPaint);
            int n = rectangle.x;
            graphics2D.drawLine(n, rectangle.y, n, rectangle.y + rectangle.height);
            n = rectangle.x + rectangle.width;
            graphics2D.drawLine(n, rectangle.y, n, rectangle.y + rectangle.height);
            graphics2D.dispose();
        }
    }

    private class BandHostPanelLayout
    implements LayoutManager {
        private BandHostPanelLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            int n = 0;
            if (ProjectLibreRibbonUI.this.ribbon.getTaskCount() > 0) {
                RibbonTask ribbonTask = ProjectLibreRibbonUI.this.ribbon.getSelectedTask();
                for (AbstractRibbonBand<?> abstractRibbonBand : ribbonTask.getBands()) {
                    int n2 = abstractRibbonBand.getPreferredSize().height;
                    Insets insets = abstractRibbonBand.getInsets();
                    n = Math.max(n, n2 + insets.top + insets.bottom);
                }
            }
            return new Dimension(container.getWidth(), n);
        }

        public Dimension minimumLayoutSize(Container container) {
            int n = 0;
            int n2 = 0;
            int n3 = ProjectLibreRibbonUI.this.getBandGap();
            RibbonTask ribbonTask = ProjectLibreRibbonUI.this.ribbon.getSelectedTask();
            for (AbstractRibbonBand<?> abstractRibbonBand : ribbonTask.getBands()) {
                int n4 = abstractRibbonBand.getMinimumSize().height;
                Insets insets = abstractRibbonBand.getInsets();
                RibbonBandUI ribbonBandUI = abstractRibbonBand.getUI();
                int n5 = ribbonBandUI.getPreferredCollapsedWidth() + insets.left + insets.right;
                n += n5;
                n2 = Math.max(n2, n4);
            }
            return new Dimension(n += n3 * (ribbonTask.getBandCount() + 1), n2);
        }

        /*
         * WARNING - void declaration
         */
        public void layoutContainer(Container container) {
            boolean bl;
            int n;
            Object object;
            Object object3;
            Object object4;
            int n2 = ProjectLibreRibbonUI.this.getBandGap();
            int n3 = 0;
            int n4 = 0;
            RibbonTask ribbonTask = ProjectLibreRibbonUI.this.ribbon.getSelectedTask();
            if (ribbonTask == null) {
                return;
            }
            for (AbstractRibbonBand<?> abstractRibbonBand : ribbonTask.getBands()) {
                FlamingoUtilities.checkResizePoliciesConsistency(abstractRibbonBand);
            }
            for (AbstractRibbonBand<?> abstractRibbonBand : ribbonTask.getBands()) {
                object4 = abstractRibbonBand.getResizePolicies();
                object3 = object4.get(0);
                abstractRibbonBand.setCurrentResizePolicy((RibbonBandResizePolicy)object3);
            }
            int n5 = container.getHeight();
            int n6 = container.getWidth();
            if (ribbonTask.getBandCount() > 0) {
                object4 = ribbonTask.getResizeSequencingPolicy();
                object4.reset();
                object3 = object4.next();
                while (true) {
                    boolean bl2 = true;
                    for (AbstractRibbonBand<?> abstractRibbonBand : ribbonTask.getBands()) {
                        RibbonBandResizePolicy ribbonBandResizePolicy = abstractRibbonBand.getCurrentResizePolicy();
                        if (ribbonBandResizePolicy == (object = abstractRibbonBand.getResizePolicies()).get(object.size() - 1)) continue;
                        bl2 = false;
                        break;
                    }
                    if (bl2) break;
                    int n7 = 0;
                    for (AbstractRibbonBand<?> abstractRibbonBand : ribbonTask.getBands()) {
                        object = abstractRibbonBand.getCurrentResizePolicy();
                        Insets insets = abstractRibbonBand.getInsets();
                        Object object2 = abstractRibbonBand.getControlPanel();
                        if (object2 == null) {
                            object2 = abstractRibbonBand.getPopupRibbonBand().getControlPanel();
                        }
                        Insets insets2 = ((JComponent)object2).getInsets();
                        n = ((AbstractBandControlPanel)object2).getUI().getLayoutGap();
                        int n8 = n5 - insets.top - insets.bottom;
                        int n9 = n8 - abstractRibbonBand.getUI().getBandTitleHeight();
                        if (object2 != null) {
                            n9 = n9 - insets2.top - insets2.bottom;
                        }
                        int n10 = object.getPreferredWidth(n9, n) + insets.left + insets.right;
                        n7 += n10 + n2;
                    }
                    if (n7 < n6) break;
                    List<RibbonBandResizePolicy> list2 = ((AbstractRibbonBand)object3).getResizePolicies();
                    int n11 = list2.indexOf(((AbstractRibbonBand)object3).getCurrentResizePolicy());
                    if (n11 != list2.size() - 1) {
                        ((AbstractRibbonBand)object3).setCurrentResizePolicy(list2.get(n11 + 1));
                    }
                    object3 = object4.next();
                }
            }
            n3 = (bl = container.getComponentOrientation().isLeftToRight()) ? 1 : container.getWidth() - 1;
            for (AbstractRibbonBand<?> abstractRibbonBand : ribbonTask.getBands()) {
                void var13_32;
                Insets insets = abstractRibbonBand.getInsets();
                RibbonBandResizePolicy ribbonBandResizePolicy = abstractRibbonBand.getCurrentResizePolicy();
                Object obj = abstractRibbonBand.getControlPanel();
                if (obj == null) {
                    Object t = abstractRibbonBand.getPopupRibbonBand().getControlPanel();
                }
                object = var13_32.getInsets();
                int n12 = var13_32.getUI().getLayoutGap();
                int n13 = n5;
                int n14 = n13 - insets.top - insets.bottom - abstractRibbonBand.getUI().getBandTitleHeight();
                if (object != null) {
                    n14 = n14 - ((Insets)object).top - ((Insets)object).bottom;
                }
                n = ribbonBandResizePolicy.getPreferredWidth(n14, n12) + insets.left + insets.right;
                if (bl) {
                    abstractRibbonBand.setBounds(n3, n4, n, n13);
                } else {
                    abstractRibbonBand.setBounds(n3 - n, n4, n, n13);
                }
                if (abstractRibbonBand.getHeight() > 0) {
                    abstractRibbonBand.doLayout();
                }
                if (bl) {
                    n3 += n + n2;
                    continue;
                }
                n3 -= n + n2;
            }
        }
    }

    protected static class BandHostPanel
    extends JPanel {
        protected BandHostPanel() {
        }
    }

    private class TaskbarPanel
    extends JPanel {
        public TaskbarPanel() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setBackground(ProjectLibreRibbonUI.this.background3);
        }

        protected void paintComponent(Graphics graphics) {
            int n;
            int n2;
            Shape shape = this.getOutline(this);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            RenderingUtils.installDesktopHints(graphics2D);
            if (shape != null) {
                graphics2D.setComposite(AlphaComposite.SrcOver.derive(0.6f));
                graphics2D.setColor(ProjectLibreRibbonUI.this.background2);
                graphics2D.fill(shape);
                graphics2D.setColor(FlamingoUtilities.getBorderColor().darker());
                graphics2D.draw(shape);
            }
            boolean bl = this.getComponentOrientation().isLeftToRight();
            int n3 = 0;
            int n4 = this.getWidth();
            if (this.getComponentCount() == 0) {
                n3 = 1;
                n4 = this.getWidth() - 1;
                if (ProjectLibreRibbonUI.this.applicationMenuButton.isVisible()) {
                    n3 += ProjectLibreRibbonUI.this.applicationMenuButton.getX() + ProjectLibreRibbonUI.this.applicationMenuButton.getWidth() + ProjectLibreRibbonUI.this.applicationMenuButtonOutlineMarginX;
                    n4 = ProjectLibreRibbonUI.this.applicationMenuButton.getX() - 1 + ProjectLibreRibbonUI.this.applicationMenuButton.getWidth() + ProjectLibreRibbonUI.this.applicationMenuButtonOutlineMarginX;
                }
            } else {
                for (n2 = 0; n2 < this.getComponentCount(); ++n2) {
                    Component component = this.getComponent(n2);
                    n3 = Math.max(n3, component.getX() + component.getWidth());
                    n4 = Math.min(n4, component.getX());
                }
            }
            n2 = this.getHeight();
            if (bl) {
                graphics2D.drawLine(n3, n2 - 1, this.getWidth(), n2 - 1);
            } else {
                graphics2D.drawLine(0, n2 - 1, n4, n2 - 1);
            }
            int n5 = shape != null ? (int)shape.getBounds2D().getMaxX() + 6 : 6;
            int n6 = n = shape != null ? (int)shape.getBounds2D().getMinX() - 6 : 6;
            if (!ProjectLibreRibbonUI.this.isShowingScrollsForTaskToggleButtons()) {
                graphics2D.setComposite(AlphaComposite.SrcOver);
                graphics2D.translate(-this.getBounds().x, 0);
                for (int i = 0; i < ProjectLibreRibbonUI.this.ribbon.getContextualTaskGroupCount(); ++i) {
                    int n7;
                    RibbonContextualTaskGroup ribbonContextualTaskGroup = ProjectLibreRibbonUI.this.ribbon.getContextualTaskGroup(i);
                    if (!ProjectLibreRibbonUI.this.ribbon.isVisible(ribbonContextualTaskGroup)) continue;
                    Rectangle rectangle = ProjectLibreRibbonUI.this.getContextualTaskGroupBounds(ribbonContextualTaskGroup);
                    Color color = ribbonContextualTaskGroup.getHueColor();
                    GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, FlamingoUtilities.getAlphaColor(color, 0), 0.0f, n2, FlamingoUtilities.getAlphaColor(color, 63));
                    graphics2D.setPaint(gradientPaint);
                    int n8 = bl ? rectangle.x : Math.min(n, rectangle.x);
                    int n9 = n7 = bl ? rectangle.x + rectangle.width - n8 : Math.min(rectangle.x + rectangle.width, n) - n8;
                    if (n7 <= 0) continue;
                    graphics2D.fillRect(n8, 0, n7, n2);
                    graphics2D.setColor(color);
                    graphics2D.drawLine(n8 + 1, n2 - 1, n8 + n7, n2 - 1);
                    graphics2D.setColor(FlamingoUtilities.getColor(Color.black, "Button.foreground"));
                    FontMetrics fontMetrics = this.getFontMetrics(ProjectLibreRibbonUI.this.ribbon.getFont());
                    int n10 = (n2 + fontMetrics.getHeight()) / 2 - fontMetrics.getDescent();
                    int n11 = n7 - 10;
                    String string = ribbonContextualTaskGroup.getTitle();
                    if (fontMetrics.stringWidth(string) > n11) {
                        while (string.length() != 0 && fontMetrics.stringWidth(string + "...") > n11) {
                            string = string.substring(0, string.length() - 1);
                        }
                        string = string + "...";
                    }
                    if (bl) {
                        BasicGraphicsUtils.drawString(graphics2D, string, -1, n8 + 5, n10);
                    } else {
                        BasicGraphicsUtils.drawString(graphics2D, string, -1, n8 + n7 - 5 - fontMetrics.stringWidth(string), n10);
                    }
                    Color color2 = FlamingoUtilities.getBorderColor();
                    graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, FlamingoUtilities.getAlphaColor(color2, 0), 0.0f, n2, color2));
                    graphics2D.drawLine(n8, 0, n8, n2);
                    graphics2D.drawLine(n8 + n7, 0, n8 + n7, n2);
                }
            }
            graphics2D.dispose();
        }

        protected Shape getOutline(TaskbarPanel taskbarPanel) {
            Serializable serializable;
            double d = this.getHeight() - 1;
            boolean bl = taskbarPanel.getComponentOrientation().isLeftToRight();
            if (this.getComponentCount() == 0) {
                if (ProjectLibreRibbonUI.this.applicationMenuButton.isVisible()) {
                    if (bl) {
                        int n = 1;
                        if (ProjectLibreRibbonUI.this.applicationMenuButton.isVisible()) {
                            n += ProjectLibreRibbonUI.this.applicationMenuButton.getX() + ProjectLibreRibbonUI.this.applicationMenuButton.getWidth() + ProjectLibreRibbonUI.this.applicationMenuButtonOutlineMarginX;
                        }
                        return new Arc2D.Double((double)(n - 1) - 2.0 * d, 0.0, 2.0 * d, 2.0 * d, 0.0, 90.0, 0);
                    }
                    int n = taskbarPanel.getWidth() - 1;
                    if (ProjectLibreRibbonUI.this.applicationMenuButton.isVisible()) {
                        n = ProjectLibreRibbonUI.this.applicationMenuButton.getX() - 1;
                    }
                    return new Arc2D.Double(n + 1, 0.0, 2.0 * d, 2.0 * d, 90.0, 90.0, 0);
                }
                return null;
            }
            int n = this.getWidth();
            int n2 = 0;
            for (int i = 0; i < this.getComponentCount(); ++i) {
                serializable = this.getComponent(i);
                n = Math.min(n, ((Component)serializable).getX());
                n2 = Math.max(n2, ((Component)serializable).getX() + ((Component)serializable).getWidth());
            }
            float f = (float)d / 2.0f;
            serializable = new GeneralPath();
            if (bl) {
                if (ProjectLibreRibbonUI.this.applicationMenuButton.isVisible()) {
                    ((Path2D.Float)serializable).moveTo((float)(n + 5) - 2.0f * f, 0.0f);
                } else {
                    ((Path2D.Float)serializable).moveTo(n - 1, 0.0f);
                }
                ((Path2D.Float)serializable).lineTo(n2, 0.0f);
                ((Path2D)((Object)serializable)).append(new Arc2D.Double((float)n2 - f, 0.0, d, d, 90.0, -180.0, 0), true);
                ((Path2D.Float)serializable).lineTo(n - 1, d);
                if (ProjectLibreRibbonUI.this.applicationMenuButton.isVisible()) {
                    ((Path2D)((Object)serializable)).append(new Arc2D.Double((double)(n - 1) - 2.0 * d, 0.0, 2.0 * d, 2.0 * d, 0.0, 90.0, 0), true);
                } else {
                    ((Path2D.Float)serializable).lineTo(n - 1, 0.0f);
                }
            } else {
                if (ProjectLibreRibbonUI.this.applicationMenuButton.isVisible()) {
                    ((Path2D.Float)serializable).moveTo((float)(n2 - 5) + 2.0f * f, 0.0f);
                } else {
                    ((Path2D.Float)serializable).moveTo(n2 - 1, 0.0f);
                }
                ((Path2D.Float)serializable).lineTo(n, 0.0f);
                ((Path2D)((Object)serializable)).append(new Arc2D.Double((float)n - f, 0.0, d, d, 90.0, 180.0, 0), true);
                ((Path2D.Float)serializable).lineTo(n2 - 1, d);
                if (ProjectLibreRibbonUI.this.applicationMenuButton.isVisible()) {
                    ((Path2D)((Object)serializable)).append(new Arc2D.Double(n2 - 1, 0.0, 2.0 * d, 2.0 * d, 180.0, -90.0, 0), true);
                } else {
                    ((Path2D.Float)serializable).lineTo(n2 + 1, 0.0f);
                }
            }
            return serializable;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(dimension.width + dimension.height / 2, dimension.height);
        }
    }

    private class TaskbarLayout
    implements LayoutManager {
        private TaskbarLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            Insets insets = container.getInsets();
            int n = 0;
            int n2 = ProjectLibreRibbonUI.this.getBandGap();
            for (Component component : ProjectLibreRibbonUI.this.ribbon.getTaskbarComponents()) {
                n += component.getPreferredSize().width;
                n += n2;
            }
            return new Dimension(n + insets.left + insets.right, ProjectLibreRibbonUI.this.getTaskbarHeight() + insets.top + insets.bottom);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            Insets insets = container.getInsets();
            int n = ProjectLibreRibbonUI.this.getBandGap();
            boolean bl = container.getComponentOrientation().isLeftToRight();
            if (bl) {
                int n2 = insets.left + 1;
                if (ProjectLibreRibbonUI.this.applicationMenuButton.isVisible()) {
                    n2 += ProjectLibreRibbonUI.this.applicationMenuButton.getX() + ProjectLibreRibbonUI.this.applicationMenuButton.getWidth();
                }
                for (Component component : ProjectLibreRibbonUI.this.ribbon.getTaskbarComponents()) {
                    int n3 = component.getPreferredSize().width;
                    component.setBounds(n2, insets.top + 1, n3, container.getHeight() - insets.top - insets.bottom - 2);
                    n2 += n3 + n;
                }
            } else {
                int n4 = container.getWidth() - insets.right - 1;
                if (ProjectLibreRibbonUI.this.applicationMenuButton.isVisible()) {
                    n4 = ProjectLibreRibbonUI.this.applicationMenuButton.getX() - 1;
                }
                for (Component component : ProjectLibreRibbonUI.this.ribbon.getTaskbarComponents()) {
                    int n5 = component.getPreferredSize().width;
                    component.setBounds(n4 - n5, insets.top + 1, n5, container.getHeight() - insets.top - insets.bottom - 2);
                    n4 -= n5 + n;
                }
            }
        }
    }

    private class RibbonLayout
    implements LayoutManager {
        private RibbonLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            Insets insets = container.getInsets();
            int n = 0;
            boolean bl = ProjectLibreRibbonUI.this.ribbon.isMinimized();
            if (!bl && ProjectLibreRibbonUI.this.ribbon.getTaskCount() > 0) {
                RibbonTask ribbonTask = ProjectLibreRibbonUI.this.ribbon.getSelectedTask();
                for (AbstractRibbonBand<?> abstractRibbonBand : ribbonTask.getBands()) {
                    int n2 = abstractRibbonBand.getPreferredSize().height;
                    Insets insets2 = abstractRibbonBand.getInsets();
                    n = Math.max(n, n2 + insets2.top + insets2.bottom);
                }
            }
            int n3 = ProjectLibreRibbonUI.this.getTaskToggleButtonHeight();
            if (!ProjectLibreRibbonUI.this.isUsingTitlePane()) {
                n3 += ProjectLibreRibbonUI.this.getTaskbarHeight();
            }
            int n4 = n + n3 + insets.top + insets.bottom - ProjectLibreRibbonUI.this.heightToReduce;
            return new Dimension(container.getWidth(), n4);
        }

        public Dimension minimumLayoutSize(Container container) {
            Insets insets = container.getInsets();
            int n = 0;
            int n2 = 0;
            int n3 = ProjectLibreRibbonUI.this.getBandGap();
            int n4 = ProjectLibreRibbonUI.this.getTaskToggleButtonHeight();
            if (!ProjectLibreRibbonUI.this.isUsingTitlePane()) {
                n4 += ProjectLibreRibbonUI.this.getTaskbarHeight();
            }
            if (ProjectLibreRibbonUI.this.ribbon.getTaskCount() > 0) {
                boolean bl = ProjectLibreRibbonUI.this.ribbon.isMinimized();
                RibbonTask ribbonTask = ProjectLibreRibbonUI.this.ribbon.getSelectedTask();
                for (AbstractRibbonBand<?> abstractRibbonBand : ribbonTask.getBands()) {
                    int n5 = abstractRibbonBand.getMinimumSize().height;
                    Insets insets2 = abstractRibbonBand.getInsets();
                    RibbonBandUI ribbonBandUI = abstractRibbonBand.getUI();
                    n += ribbonBandUI.getPreferredCollapsedWidth();
                    if (bl) continue;
                    n2 = Math.max(n2, n5 + insets2.top + insets2.bottom);
                }
                n += n3 * (ribbonTask.getBandCount() - 1);
            } else {
                n = 50;
            }
            return new Dimension(n, n2 + n4 + insets.top + insets.bottom);
        }

        public void layoutContainer(Container container) {
            int n;
            int n2;
            int n3;
            int n4;
            Serializable serializable;
            Insets insets = container.getInsets();
            int n5 = ProjectLibreRibbonUI.this.getTabButtonGap();
            boolean bl = ProjectLibreRibbonUI.this.ribbon.getComponentOrientation().isLeftToRight();
            int n6 = container.getWidth();
            int n7 = ProjectLibreRibbonUI.this.getTaskbarHeight();
            int n8 = insets.top;
            boolean bl2 = ProjectLibreRibbonUI.this.isUsingTitlePane();
            if (!bl2) {
                ProjectLibreRibbonUI.this.taskBarPanel.removeAll();
                for (Component component : ProjectLibreRibbonUI.this.ribbon.getTaskbarComponents()) {
                    ProjectLibreRibbonUI.this.taskBarPanel.add(component);
                    if (!(component instanceof AbstractCommandButton)) continue;
                    serializable = (AbstractCommandButton)component;
                    ((JComponent)serializable).setOpaque(true);
                    ((JComponent)serializable).setBackground(ProjectLibreRibbonUI.this.taskBarPanel.getBackground());
                }
                ProjectLibreRibbonUI.this.taskBarPanel.setBounds(insets.left + ProjectLibreRibbonUI.this.applicationMenuButtonOutlineMarginX, insets.top, n6 - insets.left - insets.right, n7);
                n8 += n7;
            } else {
                ProjectLibreRibbonUI.this.taskBarPanel.setBounds(0, 0, 0, 0);
            }
            ProjectLibreRibbonUI.this.ribbon.getFileSelector().setBounds(ProjectLibreRibbonUI.this.fileSelectorOffsetX, insets.top, n6 - insets.right - ProjectLibreRibbonUI.this.fileSelectorOffsetX, n7);
            int n9 = ProjectLibreRibbonUI.this.getTaskToggleButtonHeight();
            int n10 = n4 = bl ? ProjectLibreRibbonUI.this.appMenuButtonXOffset + insets.left : n6 - insets.right;
            if (!bl2) {
                ProjectLibreRibbonUI.this.applicationMenuButton.setVisible(ProjectLibreRibbonUI.this.ribbon.getApplicationMenu() != null);
                ProjectLibreRibbonUI.this.ribbon.getOpenprojLogo().setVisible(true);
                if (ProjectLibreRibbonUI.this.ribbon.getApplicationMenu() != null) {
                    if (bl) {
                        ProjectLibreRibbonUI.this.applicationMenuButton.setBounds(n4, insets.top + ProjectLibreRibbonUI.this.appMenuButtonYOffset, ProjectLibreRibbonUI.this.appMenuButtonWidth, ProjectLibreRibbonUI.this.appMenuButtonHeight);
                        ProjectLibreRibbonUI.this.ribbon.getOpenprojLogo().setBounds(n4 + ProjectLibreRibbonUI.this.openprojLogoXOffset, insets.top + n7 + n9 - ProjectLibreRibbonUI.this.openprojLogoHeight + ProjectLibreRibbonUI.this.openprojLogoYOffset, ProjectLibreRibbonUI.this.openprojLogoWidth, ProjectLibreRibbonUI.this.openprojLogoHeight);
                    } else {
                        ProjectLibreRibbonUI.this.applicationMenuButton.setBounds(n4 - ProjectLibreRibbonUI.this.appMenuButtonWidth, insets.top, ProjectLibreRibbonUI.this.appMenuButtonWidth, ProjectLibreRibbonUI.this.appMenuButtonHeight);
                    }
                }
            } else {
                ProjectLibreRibbonUI.this.applicationMenuButton.setVisible(false);
                ProjectLibreRibbonUI.this.ribbon.getOpenprojLogo().setVisible(false);
            }
            int n11 = n4 = bl ? n4 + 2 : n4 - 2;
            if (FlamingoUtilities.getApplicationMenuButton(SwingUtilities.getWindowAncestor(ProjectLibreRibbonUI.this.ribbon)) != null) {
                int n12 = n4 = bl ? n4 + ProjectLibreRibbonUI.this.appMenuButtonWidth + ProjectLibreRibbonUI.this.applicationMenuButtonOutlineMarginX : n4 - ProjectLibreRibbonUI.this.appMenuButtonWidth;
            }
            if (ProjectLibreRibbonUI.this.helpPanel != null) {
                serializable = ProjectLibreRibbonUI.this.helpPanel.getPreferredSize();
                if (bl) {
                    ProjectLibreRibbonUI.this.helpPanel.setBounds(n6 - insets.right - ((Dimension)serializable).width, n8, ((Dimension)serializable).width, n9);
                } else {
                    ProjectLibreRibbonUI.this.helpPanel.setBounds(insets.left, n8, ((Dimension)serializable).width, n9);
                }
            }
            if ((serializable = ProjectLibreRibbonUI.this.ribbon.getProjectViews()) != null) {
                Dimension dimension = ((JComponent)serializable).getPreferredSize();
                n3 = ((JComponent)serializable).getPreferredSize().width;
                n2 = ProjectLibreRibbonUI.this.helpPanel != null ? ProjectLibreRibbonUI.this.helpPanel.getX() - n3 : container.getWidth() - insets.right - n3;
                ((Component)serializable).setBounds(n2, n8, n3, n9);
            }
            if (bl) {
                int n13 = n = ProjectLibreRibbonUI.this.helpPanel != null ? ProjectLibreRibbonUI.this.helpPanel.getX() - n4 : container.getWidth() - insets.right - n4;
                if (serializable != null) {
                    n -= ((JComponent)serializable).getWidth();
                }
                ProjectLibreRibbonUI.this.taskToggleButtonsScrollablePanel.setBounds(n4, n8, n, n9);
            } else {
                n = ProjectLibreRibbonUI.this.helpPanel != null ? n4 - n5 - ProjectLibreRibbonUI.this.helpPanel.getX() - ProjectLibreRibbonUI.this.helpPanel.getWidth() : n4 - insets.left;
                ProjectLibreRibbonUI.this.taskToggleButtonsScrollablePanel.setBounds(n4 - n, n8, n, n9);
            }
            TaskToggleButtonsHostPanel taskToggleButtonsHostPanel = ProjectLibreRibbonUI.this.taskToggleButtonsScrollablePanel.getView();
            n3 = taskToggleButtonsHostPanel.getMinimumSize().width;
            taskToggleButtonsHostPanel.setPreferredSize(new Dimension(n3, ProjectLibreRibbonUI.this.taskToggleButtonsScrollablePanel.getBounds().height));
            ProjectLibreRibbonUI.this.taskToggleButtonsScrollablePanel.doLayout();
            n8 += n9;
            n2 = n9;
            if (!bl2) {
                n2 += n7;
            }
            if (ProjectLibreRibbonUI.this.bandScrollablePanel.getParent() == ProjectLibreRibbonUI.this.ribbon) {
                if (!ProjectLibreRibbonUI.this.ribbon.isMinimized() && ProjectLibreRibbonUI.this.ribbon.getTaskCount() > 0) {
                    Insets insets2 = ProjectLibreRibbonUI.this.ribbon.getSelectedTask().getBandCount() == 0 ? new Insets(0, 0, 0, 0) : ProjectLibreRibbonUI.this.ribbon.getSelectedTask().getBand(0).getInsets();
                    ProjectLibreRibbonUI.this.bandScrollablePanel.setBounds(1 + insets.left, n8 + insets2.top, container.getWidth() - 2 * insets.left - 2 * insets.right - 1, container.getHeight() - n2 - insets.top - insets.bottom - insets2.top - 1);
                    BandHostPanel bandHostPanel = ProjectLibreRibbonUI.this.bandScrollablePanel.getView();
                    int n14 = bandHostPanel.getMinimumSize().width;
                    bandHostPanel.setPreferredSize(new Dimension(n14, ProjectLibreRibbonUI.this.bandScrollablePanel.getBounds().height));
                    ProjectLibreRibbonUI.this.bandScrollablePanel.doLayout();
                    bandHostPanel.doLayout();
                } else {
                    ProjectLibreRibbonUI.this.bandScrollablePanel.setBounds(0, 0, 0, 0);
                }
            }
        }
    }
}

