/*
 * Decompiled with CFR 0.152.
 */
package com.projity.util;

import com.projity.util.Environment;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Enumeration;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class FontUtil {
    public static void setUIFont(String string) {
        Enumeration enumeration = UIManager.getDefaults().keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object object = UIManager.get(k);
            if (!(object instanceof FontUIResource)) continue;
            UIManager.put(k, new FontUIResource(Font.decode(string)));
        }
    }

    public static Font getUIFont() {
        Enumeration enumeration = UIManager.getDefaults().keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object object = UIManager.get(k);
            if (!(object instanceof FontUIResource)) continue;
            return (FontUIResource)object;
        }
        return null;
    }

    public static String getValidFont(String[] stringArray) {
        String[] stringArray2 = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!stringArray2[j].equals(stringArray[i])) continue;
                return stringArray[i];
            }
        }
        return null;
    }

    public static void listFonts() {
        Font font = FontUtil.getUIFont();
        System.out.println("Current font: " + font);
        System.out.println("Available fonts: ");
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("\t" + stringArray[i]);
        }
    }

    public static Font getFont(String string, int n) {
        Font font = Font.decode(Environment.getFont(n));
        if (string == null) {
            return font;
        }
        Font font2 = Font.decode(string);
        if (font2.getName().equals("_Default_")) {
            return font.deriveFont(font2.getStyle(), font2.getSize() + font.getSize() - 12);
        }
        return font2;
    }
}

